# -*- makefile -*-
#######################################################################
#
# Makefile for Gnu C++ Compiler
# The settings work well for my computer, but maybe not on yours
#
# --------------------------------------------------------------------

#
#  uncomment the following 2 lines to use C++17
#
#SEVEN    = -std=c++17 -DFORCE_CPP17=1
#SEVENLIB = -lstdc++fs
#
#  uncomment the following line to use C++20 (experimental)
#
SEVEN    = -std=c++2a
# no SEVENLIB required

ifneq ($(HOMEDRIVE),)  ## windows
  FOXVERSION=1.7.82
else
  FOXVERSION=1.7.82
endif
#
# Location of FOX Library
# FOX versions 1.7.x is needed
#
FOXTOPDIR = /usr/local/fox-$(FOXVERSION)
#
# the directory where to put the .o files (if necessary, it will be created)
# (for a first try the current working directory . is a good choice)
#
ifneq ($(HOMEDRIVE),)  ## windows
oBJ = '$(USERPROFILE)'/odir/fox-$(FOXVERSION)
#oBJ = '$(TMP)'/odir/fox-$(FOXVERSION)
else
##      ODIR is a global variable on my computer
oBJ = $(ODIR)/fox-$(FOXVERSION)
#oBJ = /tmp/fox-$(FOXVERSION)
#oBJ = .
endif
#
# the directory where to put the executable (must be present)
#
ifneq ($(HOMEDRIVE),)
EXEDIR = /usr/local/bin
# EXEDIR = '$(TMP)'
else
## EXEDIR is a global variable on my computer, you need to set it
#EXEDIR = .
#EXEDIR = /usr/local/bin
endif
#
# the compiler
#
CXX   = g++ $(SEVEN)
RM    = rm -f
# STRIP = strip --strip-all    same as -s
#
# tell the compiler where the #include directories are
#
CXXFLAGS = -I$(FOXTOPDIR)/include -I. -I/usr/local/include
#
# tell the linker where to find the libraries
#
ifneq ($(HOMEDRIVE),)  # windows
#
# additional compiler flags
#
CXXFLAGS += -O2 -DWIN32 
LIBDIRS   = -L$(FOXTOPDIR)/lib -L/usr/local/lib -mwindows -static
EXESUFFIX = .exe
else
#
# additional compiler flags
#
CXXFLAGS +=  -Wno-unused-result -O2
LIBDIRS   = -L$(FOXTOPDIR)/src/.libs
endif

#USE_MSC   = $(shell if which $(MSCXX) > /tmp/null 2> /tmp/null ;then echo yes; else echo no;fi)

#############################################
##                                         ##
## from here on everything should be right ##
##                                         ##
#############################################

.SUFFIXES:
.SUFFIXES: .cc .c++ .h .fm .f  .d .fh .o .io .obi .obj .a .lib
.DELETE_ON_ERROR:              .d .fh .o .io .obi .obj .a .lib

OBJ   = $(shell mkdir -p $(oBJ); cd $(oBJ); pwd -P)
VPATH = $(OBJ) $(EXEDIR)

OUTPUT = "----> "

########################################################################
############################### the rules ##############################
########################################################################

## icon for windows file explorer
$(OBJ)/%.oi : %.rc
	windres $< -o $@

#### c -> o  ## only gcc  not needed anymore

#$(OBJ)/%.o: %.c
#	echo $(OUTPUT) $@
#	$(CC) -c  -ansi -pedantic $< -o $@
#$(OBJ)/%.d: %.c
#	echo $(OUTPUT) $@
#ifneq ($(HOMEDRIVE),)
#	echo -n $(OBJ)/ > $@
#	$(CC) -MM  $<  >> $@
#else
#	$(CC) -MM -MT $(@:.d=.o) -MF $@ $<
#endif

######################### c++ source ---> o #########################

$(OBJ)/%.o : %.c++
	echo $(OUTPUT) $@
	$(CXX) -c $(CXXFLAGS) $< -o $@

$(OBJ)/%.o : %.cc
	echo $(OUTPUT) $@
	$(CXX) -c $(CXXFLAGS) -I$(FOXTOPDIR)/include $(FOXFLAGS) $< -o $@

########## MSyS (not MinGW) needs the line with echo ##########

$(OBJ)/%.d : %.cc
	echo $(OUTPUT) $@
#ifeq ($(HOMEDRIVE),)
#	$(CXX) $(CXXFLAGS) -I$(FOXTOPDIR)/include $(FOXFLAGS) -MM -MT $(@:.d=.o) -MF $@  $<
#else
	echo $(@:.d=.obj) "\\"       > $@
	echo -n $(OBJ)/             >> $@
	$(CXX) $(CXXFLAGS) -I$(FOXTOPDIR)/include $(FOXFLAGS) -MM $<  >> $@
#endif

$(OBJ)/%.d : %.c++
	echo $(OUTPUT) $@

#ifeq ($(HOMEDRIVE),)
#	$(CXX) -MM $(CXXFLAGS) -MT $(@:.d=.o) -MF $@  $<
#else
	echo $(@:.d=.obj) "\\"     > $@
	echo -n $(OBJ)/           >> $@
	$(CXX) -MM $(CXXFLAGS) $<  >> $@
#endif

###################################

#define SINGLE_CXX_FILE_template
#include $(OBJ)/$(1).d
#$(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1))) : $(OBJ)/$(1).o
#	$(CXX)   $(LINKOPTS) $(OBJ)/$(1).o -o $(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1)))
#endef

## -----------------------------------------------------------------

define CXX_PROGRAM_template
-include $($(1):.o=.d)

$(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1))) : $($(1)) $(ICO_FILE)
	echo $(OUTPUT) GCC $(OUTPUT)  $(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1)))
	$(CXX) -s  $(LINKOPTS) $($(1)) $(ICO_FILE)  $(SEVENLIB) -o tmp.ex
	mv -f tmp.ex    $(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1)))
endef


define PROGRAM_template
-include $($(1):.o=.d)

$(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1))) : $($(1)) $(ICO_FILE)
	echo $(OUTPUT) GCC $(OUTPUT) $(EXEDIR)/$(addsuffix $(EXESUFFIX),$(1))
	$(EXEDIR)/$(addsuffix $(EXESUFFIX),moddate) $(addsuffix _a.c++,$(1)) $($(1):.o=.d)
	$(CXX) -s  $(LINKOPTS) $($(1)) $(ICO_FILE) $(addsuffix _a.c++,$(1)) $(LIBDIRS) $(FOXLIBS) $(SEVENLIB) -o tmp.efx
	mv -f tmp.efx   $(addprefix $(EXEDIR)/,$(addsuffix $(EXESUFFIX),$(1)))
endef

