/* Pingo.cpp
   Copyright (C) 2001 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pinglob.h"
#include "charly.h"
#include "charlyfoto.h"

#include "charly.fm"
#define INTCAT(s,n)      sprintf(&s[strlen(s)],"%d",(int)(n))


// Construct a Charly
Charly::Charly(FXApp *appli,
         FXComposite *p,FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
         FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
  FXVerticalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {

  app=appli;
  totalstop=2;
  karl = new Karl[MAXPEN];

  pinpaint(); // create animated penguins

  // Make image widget
  ice = new Pinscroll(this,NULL,NULL,0,
              LAYOUT_FILL_X|LAYOUT_FILL_Y|SCROLLERS_NORMAL);
  ice->setFormerGlobals(karl, beamcoor, ID_SUPER, ID_WALKER, face_wid, face_hei);
  ice->pressed=ID_WALKER;
  ice->setBackColor(EXITCOL);

 // -------------- lower pane for the buttons  ---------------------

  buttonFrame = new FXHorizontalFrame(this,
     LAYOUT_FILL_X|LAYOUT_RIGHT|LAYOUT_FIX_HEIGHT,0,0,0,60);

  // penguin buttons
  FXHorizontalFrame *pinFrame = new FXHorizontalFrame(buttonFrame,
     LAYOUT_FILL_Y|LAYOUT_LEFT|FRAME_RIDGE);
  FXuint opti=FRAME_THICK|FRAME_RAISED|LAYOUT_LEFT;

  new FXButton(pinFrame,"",painticon(ID_WALKER),   this,ID_WALKER,   opti);
  new FXButton(pinFrame,"",painticon(ID_STOPPER),  this,ID_STOPPER,  opti);
  new FXButton(pinFrame,"",painticon(ID_U_BRIDGER),this,ID_U_BRIDGER,opti);
  new FXButton(pinFrame,"",painticon(ID_H_BRIDGER),this,ID_H_BRIDGER,opti);
  new FXButton(pinFrame,"",painticon(ID_D_BRIDGER),this,ID_D_BRIDGER,opti);
  new FXButton(pinFrame,"",painticon(ID_U_MINER),  this,ID_U_MINER,  opti);
  new FXButton(pinFrame,"",painticon(ID_BASHER),   this,ID_BASHER,   opti);
  new FXButton(pinFrame,"",painticon(ID_D_MINER),  this,ID_D_MINER,  opti);
  new FXButton(pinFrame,"",painticon(ID_DIGGER),   this,ID_DIGGER,   opti);
  new FXButton(pinFrame,"",painticon(ID_FLOATER),  this,ID_FLOATER,  opti);
  new FXButton(pinFrame,"",painticon(ID_SUPER),    this,ID_SUPER,    opti);

  probar = new FXProgressBar(buttonFrame,this,0,
   PROGRESSBAR_PERCENTAGE|PROGRESSBAR_DIAL|LAYOUT_FILL_Y|FRAME_RAISED);
  probar->setBarColor(FXRGB(250,0,0));

  numpin=spielzeit=0;
  strcpy(imgfile,"??");
} // end of constructor


// Create and initialize 
void Charly::create(){
  FXVerticalFrame::create();  // Create the windows
  //  font->create();  // Font too
  //  update();  // First time repaint
}

static FXColor fade(FXColor p, int &k) {
  int c[3], d[] = {EXRED,EXGREEN,EXBLUE};
  c[0] = FXREDVAL(p);
  c[1] = FXGREENVAL(p);
  c[2] = FXBLUEVAL(p);

  LOOP(i,3) {
    if (c[i]==d[i]) continue; // leaves k unchanged !
    if (c[i]>d[i]) {
      c[i]-=8; if (c[i]<d[i]) c[i]=d[i]; else k=0;
    } else {
      c[i]+=8; if (c[i]>d[i]) c[i]=d[i]; else k=0;
    }
  } 
  return FXRGB(c[0],c[1],c[2]);
}


long Charly::onTimer(FXObject*,FXSelector,void*){
  int j,k;

  if (!totalstop) {   //  game is running
    sec = int(time(NULL)-startzeit);
    probar->setProgress(sec);
    if (saved_pen==numpin || sec>spielzeit-1) {
      totalstop=1; // stop->disable();
    } else {
      app->addTimeout(this,ID_TIMELEFT,1000*TIMEOUTFAK);
    }
  }
  if (totalstop) {    // game over
    if (totalstop==1) { // fade out
      FXColor *p = ice->getImage()->getData();
      k=j=imgwid*imghei;
      LOOP(i,j) p[i] = fade(p[i],k);
      ice->getImage()->render(); ice->update();
      if (k) totalstop=2;
      app->addTimeout(this,ID_TIMELEFT,100*TIMEOUTFAK);
    } else {
      finished();
    }
  }
  return 1;
}


void Charly::finished() {
  int i,j,k;
  char ss[200];                     

  ice->running=0;
  delete [] icecopy;                DBGINFO(in charly: vor FXDCWindow);
  FXDCWindow dc(ice->getImage());   DBGINFO(in charly: nach FXDCWindow);

  FXGIFIcon *peng = new FXGIFIcon(app,charlygif,0,IMAGE_OPAQUE,300,259);
  peng->create();

#ifdef LINUX
  FXFont *font=new FXFont(app,"helvetica",22,FXFont::Bold);  // Make font
#else
  FXFont *font=new FXFont(app,"helvetica",16,FXFont::Bold);
#endif
  font->create();

  ice->getPosition(i,j);
  dc.drawIcon(peng,60-i,20-j);
  dc.setForeground(FXRGB(240,240,240)); dc.setFont(font);
  if (ice->language==GERMAN)  strcpy(ss,"Du hast ");
  if (ice->language==ENGLISH) strcpy(ss,"You saved "); 
                         INTCAT(ss,saved_pen);
  if (ice->language==GERMAN)  strcat(ss," von ");
  if (ice->language==ENGLISH) strcat(ss," of "); 
                         INTCAT(ss,numpin);
  if (ice->language==GERMAN)  strcat(ss," Charlies gerettet");
  if (ice->language==ENGLISH) strcat(ss," Charlies");
  k=strlen(ss);
  dc.drawText(60-i,310-j,ss,k);

                         strcpy(ss,"[in ");
                         INTCAT(ss,sec);
  if (ice->language==GERMAN)  strcat(ss," Sekunden]");
  if (ice->language==ENGLISH) strcat(ss," seconds]");
  k=strlen(ss);
  dc.drawText(60-i,340-j,ss,k);

  ice->update();
  delete peng; delete font;
}


// Switch to another type
long Charly::onCmdPlay(FXObject*,FXSelector sel,void*){
  ice->pressed = FXSELID(sel);
  return 1;
}
long Charly::onUpdPlay(FXObject *sender,FXSelector sel,void*){
  FXuint msg = ((FXSELID(sel))==ice->pressed) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),NULL);
  return 1;
}


int Charly::isbackcol(int x, int y) {
  FXColor c = icecopy[x+imgwid*y];
  if (c==back || c==EXITCOL || c==BEAMCOL) return 1;
  return 0;
}

void Charly::setparam(char im[], int np, int ex, int ey,
          int sz, int sp, int b1, int b2, int b3, int b4) {
  strcpy(imgfile,im);
  numpin=np;
  ice->exitx=ex;
  ice->exity=ey;
  spielzeit=sz;
  speed=sp;
  beamcoor[1]=b1;
  beamcoor[2]=b2;
  beamcoor[3]=b3;
  beamcoor[4]=b4;

  pinopen();
}

void Charly::start_the_game() {
  startzeit=time(NULL);
  totalstop=saved_pen=lost_pen=ice->gameover=ice->running=0;
  probar->setTotal(spielzeit);
  probar->setProgress(0);
  app->addTimeout(this,ID_TIMELEFT,1000*TIMEOUTFAK);
  app->addTimeout(this,ID_PLAYTIME,(50+speed)*TIMEOUTFAK);
}

//----------------------------------------------------------------

void Charly::pinopen() {

  totalstop=2;

  FXImage *img=NULL;
  FXFileStream stream;
  FXString ext=FXPath::extension(FXString(imgfile));

  if (FXString::comparecase(ext,"bmp")==0) {  // bmp
    img=new FXBMPImage(app,NULL,IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP);
    if (stream.open(imgfile,FXStreamLoad)) {
      img->loadPixels(stream); stream.close();
    }

  } else if (FXString::comparecase(ext,"ppm")==0) {  // ppm
    img=new FXPPMImage(app,NULL,IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP);
    if (stream.open(imgfile,FXStreamLoad)) {
      img->loadPixels(stream); stream.close();
    }

  } else {
    if (ice->language==GERMAN) {
      FXMessageBox err(this,"FEHLER :-(",
      "falsches Bildformat",
      NULL,MBOX_OK);
    err.execute();
    }
    if (ice->language==ENGLISH) {
      FXMessageBox err(this,"ERROR :-(",
      "wrong image format",
      NULL,MBOX_OK);
      err.execute();
    }
    return;
  }

  img->create();
  FXImage *old=ice->getImage();
  ice->setImage(img);
  delete old;
  imgwid = img->getWidth(); imghei = img->getHeight();

  // ---- check for beamer color (before painting beamers)
  FXColor *p = img->getData();
  icen  = imgwid*imghei;
  int i = BERED; if (i<156) i++; else i--;
  FOM(icen) {
    if (p[m]==BEAMCOL) p[m]=FXRGB(m,BEGREEN,BEBLUE);
  }

  // ---- paint the exit
  if (ice->exitx>0 && ice->exity>0) ice->paintexit();

  // paint beamers
  beamcoor[0]=0;  // beamers ???
  if (beamcoor[1]) {beamcoor[0]++; ice->paintbeamer(1);}
  if (beamcoor[3]) {beamcoor[0]++; ice->paintbeamer(2);}

 // give icecopy some extra pixel, just in case to avoid crashes
  icecopy = new FXColor[icen+5*imgwid];
  memcpy(icecopy,p,sizeof(FXColor)*icen);

   back = p[0];
   iron = p[imgwid-1];
      i = FXREDVAL(back); if (i<156) i++; else i--;
  block = FXRGB(i,FXGREENVAL(back),FXBLUEVAL(back));

  ice->gameover=1;
}
