/* 
 * Copyright (C) 2002 Clemens Schiff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 *
 * or get it at http://www.fsf.org
 */

#ifndef CHARLY_H
#define CHARLY_H 1
using namespace std;

#include "pinscroll.h"  // defines struct Karl
struct Face {int x; int y; FXColor c;}; 


class Charly : public FXVerticalFrame {

protected:
  FXApp             *app;
  FXHorizontalFrame *buttonFrame;
  Pinscroll         *ice;
  int  totalstop;  // stops all animations 

  char imgfile[255];
  int  maxlevel,  // total number of levels in charly.dat
    spielzeit,    // time in [s] the game is on
    numpin,       // number of penguins
    face_wid,     // width and height of an animated charly
    face_hei,
    speed,        // was speed of game - now additional time between 2 animations
    beamcoor[5];  // position of beamers

private:
  FXColor         *icecopy;
  FXProgressBar   *probar;

  Face  ***face;
  Karl  *karl;

  int imgwid, imghei, sec, icen;
  int wi2, hi2;
  FXColor back, block, iron;

  time_t startzeit;
  int saved_pen,       // number of saved charlies
      lost_pen;        // number of UNsaved charlies

public:

#include "charly.fh"

  void drawstopper(int n, FXColor col);
   int erase(int xx, int yy, int w, int h);
   int drawminer(int n, int xx, int yy, int f);
   int stair(int n, int x, int y, int f);

  void pinpaint(void);
   int createpenguins(const char *xpm[],
      const int NUM, const int DIR, int tot);
  void setpin(const int ID, const int NUM, const int DIR, int tot);
   int beamerout(int tot, const int DIR, const int NUM);
  FXIcon *painticon(const int ID, int wi=0, int di=1);
#ifdef DOKU
  void dokument(const int ID, const int NUM, const int DIR);
  void drawthem(void);
#endif

  int piccount(const int ID, int n) {
    karl[n].pic++;
    if (karl[n].pic == pin[ID-ID_WALKER][1]) karl[n].pic = 0;
    return karl[n].pic;
  }
  int isbackcol(int x, int y);

  void turnCharlyAndWalk(int n);
  int  whichbeamer(int x, int y);
  int  charlyinexit(int x, int y);

  virtual void pinopen();
  virtual void finished();
  virtual void create();  // Initialize

  void setparam(char im[], int np, int ex, int ey,
     int sz=3000, int sp=50, int b1=0, int b2=0, int b3=0, int b4=0);
  void start_the_game();
  void stop_the_game() {totalstop=1;}

private:
// defined here because ID_WALKER is set in "charly.fh"
  int pin[LAST_FUNC-ID_WALKER][2];

public:
  Charly(FXApp *appli,
         FXComposite *p,FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  virtual ~Charly() {delete [] karl; } // Charly  destructor

};

#endif

