/*   ----------------------------
 *    figure out OS and Compiler
 *   ----------------------------   C++17 is a requirement
 *    no #include in this file

 show GCC defines on Windows:  gcc -dM -E - < NUL:
 on Linux:                     gcc -dM -E - < /dev/null
*/

#ifndef CLEMILER_H
#define CLEMILER_H 1

/* ---------------------------  supported OSes  --------------------------- */

#if defined(_WIN32) || defined(_WIN64) || defined(WIN32) || defined(WIN64)
#define MINGW 1
#define LINUX 0
#define MACOS 0

// opensolaris is quite similar to linux
#elif defined(__linux__) || defined (sun) || defined (__sun)
#define MINGW 0
#define LINUX 1
#define MACOS 0

// #elif defined( __APPLE__ & __MACH__)
// #define MACOS 1
#else
#error Sorry, I know only of LINUX, SOLARIS and WINDOWS
#endif

/* -------------------------  supported compilers  ------------------------- */

#ifdef __INTEL_COMPILER
#define INTELCOMPILER  1  // no longer up-to-date, was used only between 2012 and 14
  
#else
#define INTELCOMPILER 0

// unfortunately INTELCOMPILER also defines __GNUG__ and __GNUC__ on linux and _MSC_VER on Windows ...
#ifdef  _MSC_VER
#if  _MSC_VER > 1899
# define MSCOMPILER  1
//define ALLOW_CPP17 1   // since 2017   with  -std:c++17
# define ALLOW_CPP20 1   //              with  -std:c++latest
#else
# error switch to a modern compiler, need at least MSC++ 19
#endif

#else
#define MSCOMPILER  0
#define GNUCOMPILER 1

// unfortunately clang also defines __GNUG__
#ifdef  __clang__
#if  __clang_major__ > 4
# if __clang_major__ > 8
#  define ALLOW_CPP20 1
# endif
#else
# error switch to a modern compiler, need at least Clang 5
#endif

#else

#ifdef  __GNUG__
#if  __GNUC__ > 7
# if __GNUC__ > 8
#  define ALLOW_CPP20 1
# endif
#else
# error switch to a modern compiler, need at least GCC 8
#endif

#else
# error unsupported compiler, must be INTEL, MS, GCC or Clang
#endif  // not GCC
#endif  // not clang
#endif  // not MS compiler
#endif  // not intel compiler

/* -------------------------------------------------------------- */

#define ALLOW_CPP11    1  // was needed when C++11 was new
#define ALLOW_VARIADIC 1  // maybe these defs are still somewhere around
#define ALLOW_CPP14    1  // was needed when C++14 was new
#define ALLOW_CPP17    1  // was needed when C++17 was new

#ifdef  FORCE_CPP17
#undef  ALLOW_CPP20
#endif
#ifndef ALLOW_CPP20
#define ALLOW_CPP20  0
#endif

/* -------------------------------------------------------------- */

#endif


