 /* COmment CArd INput:
  *   returns one line of input as a string or a string "EOF"
  *   COCAIN (e.g. '#') removes everything to the right of
  *   the COCAIN token and leading + trailing blanks
  * if COCAIN=='C' the comment functionality is ignored
  */

#include "clemens.h"
#include "cocain.h"


FILE *Cocain::open(string fina) {
  FILE *il;
  if ( (il=FOPEN(fina)) != NULL) {
    nuthinOpen = false;
    file.push_back(il);
    if (file.size()==1) first=il;
    path = clh::getfdir(fina); // empty if no directory
    if (path.size() > 1) path += DIRSEP;
  }
  return il;
}

void Cocain::totop() {
  fileclear(1);
  defin.clear();
  if (first!=NULL) TOTOP(first);
}

void Cocain::close() {
  if (file.size() > 0) fileclear();
  defin.clear();
}


string Cocain::read() {
  // this happens if constructor tries to open a file that does not exist
  if (nuthinOpen) return "EOF";

  do {
    string st = read(file.back()); //  ZWERG(st);

    switch(st[0]) {
    case '$':
      {
    	string up = clh::upper(st);
        if (up.substr(1,7)=="INCLUDE") {
	  up = path + clh::correctpath( clh::extract(st,"\"") );
    	  FILE *il;
    	  if ((il=FOPEN(up)) == NULL) {cout << "ERROR: file not found: " << up << endl; ERRORABORT;}
    	  file.push_back(il);

	} else if (up.substr(1,6)=="DEFINE") {
    	  string::size_type n2 = up.find_first_of(" ",9);
	  defin[up.substr(8,clh::lenstr(8,n2-1))] = st.substr(n2+1);

        } else {
    	  return checkdefin(st);
      } }
      break;

    case 'E':
      if (st=="EOF" && file.size() > 1) {
    	fclose(file.back());
    	file.pop_back();
      } else {
    	return checkdefin(st);
      }
      break;

    default:
      return checkdefin(st);
      break;
    }

  } while(true);

  return "Oops";  // unreachable
}

string Cocain::comment() {
  return clh::whitetrim(clh::replace(comm, clh::num2str(COCA), ' '));
}

void Cocain::reset(const char coca7, FILE *is7, const int tlen7) {
  fileclear();
  first = NULL;
  COCA  = coca7;
  is    = is7;
  tlen  = tlen7;
  nuthinOpen = true;
}

// /// sometimes useful - but not recommended
// void Cocain::reset(FILE *il, const char coca7, FILE *is7, const int tlen7) {
//   if (doClose==true) {cout << "ERROR: called wrong reset (2)" << endl; ERRORABORT;}
//   first = il;
//   fileclear(1);
//   path = "";
//   is   = is7;
//   COCA = coca7;
//   tlen = tlen7;
//   if (il==NULL) nuthinOpen = true; else nuthinOpen = false;
// }


///// ******************** private functions ********************


void Cocain::fileclear(int keepfirst) { // close and clear all
  if (file.size() > 0) {
    int kf=0;
    for (FILE *fi : file) {++kf; if (kf > keepfirst) { if (fi!=NULL) fclose(fi); }}
    file.clear();
  }
  if (keepfirst && first!=NULL) file.push_back(first);
}


// static inline string replaceAll(string st, const string from, const string with, const bool uppercase=false) {
//   string fr = (uppercase ? clh::upper(from) : from);
//   do {
//     string up = (uppercase ? clh::upper(st) : st); // st will be different in every step
//     string::size_type n1 = up.find(fr);
//     if (n1 == string::npos) break;
//     st.replace(n1, from.size(), with);
//   } while(true);
//   return st;
// }


// if definition is unknown it will be replaced by a blank
string Cocain::checkdefin(string st) {
  opto::optional<int> n;
  if ( (n = clh::isitin(st,"$")) ) {
    do {
      int n1 = (*n) +1;
      string up = clh::upper(st); // st will be different in every step
      string::size_type n2 = st.find_first_of(" ",*n) -1;
      string df = defin[up.substr(n1,clh::lenstr(n1,n2))];
      if (dollarerror > 0 && df == "") {
	cout << "WARNING: no replacement found for " << up.substr(*n,clh::lenstr(*n,n2)) << "\nin line: " << st << endl;
	if (dollarerror > 1) ERRORABORT;   // default
      }
      st.replace(*n,clh::lenstr(*n,n2), df);
    } while ( (n = clh::isitin(st,"$")) );
  }

  if (is!=NULL) fprintf(is, __FILE__" (3): --%s--\n",st.c_str());
  return st;
}


string Cocain::read(FILE *il) {
  string tt, ss = "";
  size_t n;
  comm = "";

  // #if 0
  while ( (tt=clh::fgets(il,tlen)) != "EOF") {
    // #else
    //     while(true) {
    //       tt= "EOF";
    //       if (il != NULL) {
    // #if GNUCOMPILER==1 || INTELCOMPILER==1
    // 	char xx[tlen];  // this is NOT the standard
    // 	if ( fgets(xx,tlen,il)!=NULL ) tt = clh::noeol(string(xx));
    // 	      if (is!=NULL) fprintf(is,__FILE__" (x): --%s-- --%s--\n",tt.c_str(),xx);
    // #else
    // 	char *xx = new char[tlen];
    // 	if ( fgets(xx,tlen,il)!=NULL ) tt = clh::noeol(string(xx));
    //       if (is!=NULL) fprintf(is,__FILE__" (x): --%s-- --%s--\n",tt.c_str(),xx);
    // 	delete [] xx;
    // #endif
    //       }
    //       if (tt== "EOF") break;
    // #endif
    if (is!=NULL) fprintf(is,__FILE__" (1): --%s--\n",tt.c_str());

    if (COCA != 'C') {
      string::size_type  m = tt.find_first_of(COCA);
      if (m != string::npos) {
	comm = tt.substr(m+1); // save the comment part of the actual line (do not add them)
	tt.erase(m);
    } }
    ss += clh::whitetrim( clh::replace(tt,"\t",' ') );

    if ( (n = ss.size()) > 0) {
      n--;
      if (ss[n] == '\\') {   // continuation line
	if (ss[n-1] != ' ') ss[n] = ' '; else ss.erase(n,1);
      } else {
	if (is!=NULL) fprintf(is,__FILE__" (2): --%s--\n",ss.c_str());
	return ss;
  } } }
  return "EOF";
}


// string Cocain::read(FILE *il) { // this function is old and in need of an overhaul
//   int i,n,b,ii,nanz=0;
//   ss[0]='\0';

//   while ( (tt=clh::fgets(il,tlen)) != "EOF") {
//     if (is!=NULL) fprintf(is,"cocain read: %s\n",tt.c_str());

//     if (COCA!='C') {
//       string::size_type m = tt.find_first_of(COCA);
//       if (m != string::npos) tt.erase(m);
//     }
//     tt = WHITETRIM(tt);

//     i=-1; ii=1; n=0; b=5;
//     while (tt[++i]) { // remove comments and leading blanks

//       switch(tt[i]) {
//         case '\t': tt[i]=' ';         // fallthru
//         case ' ' : b++;           ii=1;  break;
//         default  : b=0; nanz+=ii; ii=0;  break;
//         case '\\':
// 	  if (tt.size()==clh::cast(i+1)) { // continuation line
//             if ( (tt=clh::fgets(il,tlen)) == "EOF") goto OutOfInnerWhile;
//             if (is!=NULL) fprintf(is,"cocain Read: %s\n",tt.c_str());
//             i=-1; ii=1; if (!b) ss[n++]=' '; b=5;
// 	  } else {
// 	    b=0; nanz+=ii; ii=0;  // default
// 	  }
//           break;
//       }

//       if (b <2)    ss[n++]=tt[i]; // copy tt to ss
//       if (n==tlen) break;         // field ss is too small
//     }

// OutOfInnerWhile:
//     ss[n]='\0';
//     if (nanz) { // otherwise string is empty
//       n--; while (ss[n]==' ') ss[n--]='\0'; // remove trailing blanks
//     }
//     if (strlen(ss) > 0)  return string(ss);  // *** here function stops *** ///
//   }

//   return "EOF";
// }


