/*
#  EXtract FOX's DEFINitions from FOX's "config.status"
#  --      ---   -----
#  this program reads "config.status" and gets the information necessary
#  to compile user programs with the same flags as the library
#
#    the information is stored in  outputfile

   2 arguments are expected: FOXTOPDIR and outputfile

-------------------------------------------------------------------------

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a kopy of the GNU General Public License
   along with this program; if not, see:  http://www.fsf.org
*/

#include "clemens.h"
#include "cocain.h"

inline bool ISITIN(const string t, const string s) {
  return (t.find(s) != string::npos);
}
template <typename T> inline int ISITIN(const string ss, const string a, T &ipos) {
#if ALLOW_CPP17==1
  opto::optional<int> k = clh::isitin(ss,a);
  if (k) { // extract number that preceeds string a in ss
    int n = (*k);
#else
  int n = clh::IsItIn(ss,a);
  if (n > -1) {
#endif
    ipos = static_cast<T>(n);
    return 1;
  }
  return 0;
}




static void garbage(string &st, string xx) {
  int n=0, s = xx.size();
  while (ISITIN(st,xx,n)) {for (int i=n; i<n+s; i++) st[i]=SPECIALCHAR;}
}

static void cleanit(string &st) {
  string ss="";
  LOOP(i,st.size()) { if ( st[i]!=SPECIALCHAR ) ss+=st[i]; }
  st=ss;
}

static void doublebackslash(string &st) {
  string ss="";
  int m = st.size() - 1;
  LOOP(i,m) {
    if ( !(st[i]=='\\' && st[i+1]=='\\') ) ss+=st[i];
  }
  ss+=st[m];
  st=ss;
}


// static inline string ccolon(string ss) {
// #if MINGW==1
//   for (size_t n=1; n < ss.size()-1; n++) {
//     if (ss.substr(n,2) == ":/") {    /// replace  c:/  with /c/
//       ss[n]   = ss[n-1];
//       ss[n-1] = '/';
//   } }
// #endif
//   return ss;
// }


int main(int argc,char *argv[]) {
  FILE *ou;
  string st, st1="", st2;

  if (argc<3) {
    printf("ERROR in EXFOXDEFIN: 2 arguments FOXTOPDIR and outputfile expected\n");
    exit(1);
  }

  string arg1 = string(argv[1]);    //  ZWErg(arg1);   ZWERG(argv[2]);
  if ( FOPEN(arg1+"/config.status","r") == NULL ) {
    cout << "ERROR in EXFOXDEFIN: cannot find "+arg1+"/config.status" << endl;
    exit(1);
  }

  int n=0;   // we need cocain for continuation lines
  Cocain cocain(arg1+"/config.status", 'C',NULL,10000);
  cocain.ignore_dollar_error();   // here are dollar signs

  while ( (st = cocain.read()) != "EOF" ) { //  ZWErg(n);ZWERG(st);
     /* !!!! */ if (n==2) break;      /* !!!! */

    int mm=0;
    if (st.substr(0, 8)=="s,@DEFS@")         mm= 9;
    if (st.substr(0,10)=="S[\"DEFS\"]=")     mm=10;  // war 12
    if (st.substr(0,12)=="s,@CXXFLAGS@")     mm=13;
    if (st.substr(0,14)=="S[\"CXXFLAGS\"]=") mm=14;  // war 16

    if (mm==0) continue;    // ZWErg(n); ZWERG(st);

    LOOP(i,mm) st[i]=SPECIALCHAR;
    // int m1 = st.size()-1;
    // if (st[mm]=='\"' && st[m1] =='\"') st[mm]=st[m1]=SPECIALCHAR;

    garbage(st,"|#_!!_#|");
    garbage(st,",g");
    garbage(st,",;t t");
    garbage(st,"\\\\ ");
    garbage(st,"\" \"");  // new in fox-1.7.23
    garbage(st,"\"\"");
    if (st[st.size()-1]=='"') st[st.size()-1]=SPECIALCHAR;

    cleanit(st);
    doublebackslash(st);
    if (n==0) st1 = st; else st1 += " " +st;
    n++;
    
//     if (st.substr(0,8) =="s,@DEFS@" || st.substr(0,10)=="S[\"DEFS\"]=") {
//       LOOP(i,9)  st[i]=SPECIALCHAR;
//       garbage(st,"|#_!!_#|"); garbage(st,",g"); garbage(st,",;t t"); garbage(st,"\\\\ ");
//       cleanit(st);
//       doublebackslash(st);
//       st1 = st;
//       n++;
//     }
//     if (st.substr(0,12)=="s,@CXXFLAGS@" || st.substr(0,14)=="S[\"CXXFLAGS\"]=")  {
//       LOOP(i,13) st[i]=SPECIALCHAR;
//       garbage(st,"|#_!!_#|"); garbage(st,",g"); garbage(st,",;t t"); garbage(st,"\\\\ ");
//       cleanit(st);
//       st2 = st;
//       n++;
//     }

  }

  st  = st1;

///------------------------------------------------------

  string focon = arg1 + "/fox-config";

  // FILE *v = FOPEN(focon);
  // if (v==NULL) {  // it is no longer there (since 1.7.30 or so)

  //   v = FOPEN(focon,"w");
  //   fprintf(v,"#! /bin/sh\n");

  //   FILE *w;
  //   string txt; bool ok=true;
  //   for (int ww = 17; ww<202; ww++) {
  //     if ( (w=FOPEN(ar+"/fox"+clh::num2str(ww)+".pc")) != NULL) break;
  //     if (ww > 200) {
  // 	printf("ERROR in EXFOXDEFIN: cannot find %s/fox??.pc\n",ar.c_str());
  // 	exit(1);
  //     }
  //   }

  //   while( (txt = clh::fgets(w)) != "EOF" ) {
  //     if (txt.size() < 2) ok=false;
  //     if (ok) {
  // 	fprintf(v,"%s\n",txt.c_str());
  //     } else {
  // 	if (txt.substr(0,7)=="Version") {
  // 	  txt[0]='v';
  // 	  txt = WHITETRIM( REPLACE(txt,":","="), true );
  //         fprintf(v,"%s\n",txt.c_str());
  //         break;
  //   } } }
  //   fclose(w);

  //   fprintf(v,"usage()\n");
  //   fprintf(v,"{\n");
  //   fprintf(v,"  cat <<EOF\n");
  //   fprintf(v,"Usage: fox-config [OPTIONS] [LIBRARIES]\n");
  //   fprintf(v,"Options:\n");
  //   fprintf(v," [--prefix[=DIR]]\n");
  //   fprintf(v," [--exec-prefix[=DIR]]\n");
  //   fprintf(v," [--version]\n");
  //   fprintf(v," [--libs]\n");
  //   fprintf(v," [--cflags]\n");
  //   fprintf(v,"EOF\n");
  //   fprintf(v,"  exit $1\n");
  //   fprintf(v,"}\n");
  //   fprintf(v,"if test $# -eq 0 ; then\n");
  //   fprintf(v,"  usage 1 1>&2\n");
  //   fprintf(v,"fi\n");
  //   fprintf(v,"while test $# -gt 0 ; do\n");
  //   fprintf(v,"  case \"$1\" in\n");
  //   fprintf(v,"  -*=*) optarg=`echo \"$1\" | sed 's/[-_a-zA-Z0-9]*=//'` ;;\n");
  //   fprintf(v,"  *) optarg= ;;\n");
  //   fprintf(v,"  esac\n");
  //   fprintf(v,"  case $1 in\n");
  //   fprintf(v,"  --prefix=*)\n");
  //   fprintf(v,"    prefix=$optarg\n");
  //   fprintf(v,"    local_prefix=yes\n");
  //   fprintf(v,"    ;;\n");
  //   fprintf(v,"  --prefix)\n");
  //   fprintf(v,"    echo_prefix=yes\n");
  //   fprintf(v,"    ;;\n");
  //   fprintf(v,"  --exec-prefix=*)\n");
  //   fprintf(v,"    exec_prefix=$optarg\n");
  //   fprintf(v,"    exec_prefix_set=yes\n");
  //   fprintf(v,"    local_prefix=yes\n");
  //   fprintf(v,"    ;;\n");
  //   fprintf(v,"  --exec-prefix)\n");
  //   fprintf(v,"   echo_exec_prefix=yes\n");
  //   fprintf(v,"   ;;\n");
  //   fprintf(v,"  --version)\n");
  //   fprintf(v,"    echo $version\n");
  //   fprintf(v,"   exit 0\n");
  //   fprintf(v,"   ;;\n");
  //   fprintf(v," --cflags)\n");
  //   fprintf(v,"   echo_cflags=yes\n");
  //   fprintf(v,"   ;;\n");
  //   fprintf(v," --libs)\n");
  //   fprintf(v,"   echo_libs=yes\n");
  //   fprintf(v,"    ;;\n");
  //   fprintf(v,"  *)\n");
  //   fprintf(v,"    usage 1 1>&2\n");
  //   fprintf(v,"    ;;\n");
  //   fprintf(v,"  esac\n");
  //   fprintf(v,"  shift\n");
  //   fprintf(v,"done\n");
  //   fprintf(v,"if test \"$local_prefix\" = \"yes\" ; then\n");
  //   fprintf(v,"    if test \"$exec_prefix_set\" != \"yes\" ; then\n");
  //   fprintf(v,"      exec_prefix=$prefix\n");
  //   fprintf(v,"    fi\n");
  //   fprintf(v,"fi\n");
  //   fprintf(v,"if test \"$echo_prefix\" = \"yes\" ; then\n");
  //   fprintf(v," echo $prefix\n");
  //   fprintf(v,"fi\n");
  //   fprintf(v,"if test \"$echo_exec_prefix\" = \"yes\" ; then\n");
  //   fprintf(v," echo $exec_prefix\n");
  //   fprintf(v,"fi\n");
  //   fprintf(v,"if test \"$echo_cflags\" = \"yes\" ; then\n");
  //   fprintf(v," cflags=\"-I${includedir}\"\n");
  //   fprintf(v," echo $cflags\n");
  //   fprintf(v,"fi\n");
  //   fprintf(v,"if test \"$echo_libs\" = \"yes\" ; then\n");
  //   fprintf(v," libs=\"${FOX_LIBS} ${X_LIBS} ${X_BASE_LIBS} ${X_EXTRA_LIBS} ${GL_LIBS} ${LIBS}\"\n");
  //   fprintf(v," if test \"${libdir}\" != \"/usr/lib\" ; then\n");
  //   fprintf(v,"  echo -L${libdir} $libs\n");
  //   fprintf(v," else\n");
  //   fprintf(v,"  echo $libs\n");
  //   fprintf(v," fi\n");
  //   fprintf(v,"fi\n");
  // }
  // fclose(v);

  ///------------------------------------------------------

#if LINUX==1
  clh::system("chmod 775 "+ focon);
  //   // directory "ar" might be read only
  //   string syst = MKTMPFILE();
  //   clh::system("cp "+ar+"/fox-config "+syst);
  string syst = focon;
#elif MINGW==1
  string syst = "C:\\msys64\\usr\\bin\\sh.exe"; 
  {
    FILE *v = FOPEN(syst);
    if (v==NULL) {
      syst = "C:\\mingw\\msys\\1.0\\bin\\sh.exe";  
      v = FOPEN(syst);
      if (v==NULL) {
	syst = "C:\\msys\\bin\\sh.exe";
	v = FOPEN(syst);
	if (v==NULL) {cout << "EXFOXDEFIN: no /bin/sh found, abort" << endl; ERRORABORT;}
      }
    }
    FCLOSE(v);
  }
  syst += " " + focon; 
#else
#error unsupported OS
#endif
  
  ///------------------------------------------------------

  // clh::system(syst+" --version > "+string(argv[2]));
  // in = fopen(argv[2],"r");
  // cocain.reset(in);
  // st1 = cocain.read();
  // fclose(in);

  int ver=0;
  if (ver==0 && ISITIN(arg1,"1.4")) ver=14;
  if (ver==0 && ISITIN(arg1,"1.5")) ver=16;
  if (ver==0 && ISITIN(arg1,"1.6")) ver=16;
  if (ver==0 && ISITIN(arg1,"1.7")) ver=18;
  if (ver==0 && ISITIN(arg1,"1.8")) ver=18;
  if (ver==0 && ISITIN(arg1,"1.9")) ver=20;
  if (ver==0 && ISITIN(arg1,"2.0")) ver=20;

  // get rid of double definitions (I hope their sequence does not matter)

  std::vector<string> defin;
#if MINGW==1
  defin.push_back("WIN32");  // has been missing....
#endif
  int nd=0;
  st2=""; n=0;

  LOOP(i,st.size()) {
    char c = char(st[i]);
    if (c==' ') {n=0; continue;}
    switch (n) {
    case  1:          // next option
      if (c=='D') {   // definition
        n=2; defin.push_back(""); nd=int(defin.size());
      } else {        // compiler flag
        n=3; st2+=" -"; st2+=c;
      }
      break;
    case  2: defin[nd-1]+=c;  break;
    case  3:         st2+=c;  break;
    default: if (c=='-') n=1; break;
    }
  }
  sort(defin.begin(),defin.end());

  ou = fopen(argv[2],"w");
  fprintf(ou,"#\n");
  fprintf(ou,"# this data was extracted from\n");
  fprintf(ou,"# \"%s/config.status\" and\n",arg1.c_str());
  fprintf(ou,"# \"%s/fox-config\" (%s)\n",  arg1.c_str(),clh::timecpy(0).c_str());
  fprintf(ou,"#\n");

  ///// avoids some compiler complaints
  //  if (ISITIN(st2,"-Woverloaded-virtual",n)) {st2.erase(n,20); fprintf(ou,"# -Woverloaded-virtual was removed\n");}
#if LINUX==1
  // llvm does not like fast-math
  if (ISITIN(st2,"-ffast-math",         n)) {st2.erase(n,11); fprintf(ou,"# -ffast-math          was removed\n");}
#endif
  if (ISITIN(st2,"-Wextra",             n)) {st2.erase(n, 7); fprintf(ou,"# -Wextra              was removed\n");}
  if (ISITIN(st2,"-Wshadow",            n)) {st2.erase(n, 8); fprintf(ou,"# -Wshadow             was removed\n");}
  /**/                        st2 += " -Wno-format-security"; fprintf(ou,"# -Wno-format-security was added\n");
  //**/                       st2 += " -Wno-unused-parameter"; fprintf(ou,"# -Wno-unused-parameter was added\n");

  string verstr="";
  fprintf(ou,"#\nFOXFLAGS = -DFOX_VERSION_NUMBER=%d",ver);

  defin.erase( unique(defin.begin(), defin.end(), [](string a, string b) {return (a == b);}),
	       defin.end());
  for (auto &d : defin) {
    fprintf(ou," -D%s", d.c_str());
    if (ISITIN(d,"VERSION")) verstr+= " -D"+d;
  }
  
#if MINGW==1
  if (clh::system(clh::doublebackslash(syst) + " --libs > " + string(argv[2]) + ".temp") > 0) {
    ///    ^^^^^^^^^^^  sometimes you need it, sometimes you dont ....
#endif
    if (clh::system(                   syst  + " --libs > " + string(argv[2]) + ".temp") > 0) {
      cout << "EXFOXDEFIN: unable to execute " << syst << " or " << clh::doublebackslash(syst) << endl;
      ERRORABORT;
    }
#if MINGW==1
  }
#endif
  
  FILE   *kp = FOPEN(string(argv[2]) + ".temp", "r");
  string kkp = clh::fgets(kp);
  fclose(kp);
#if LINUX==1
  if (!ISITIN(kkp,"GLU")) kkp += " -lGLU";   // missing since 1.7.57
#endif
#if MINGW==1
  if (!ISITIN(kkp,"glu"))   kkp += " -lglu32";
  if (!ISITIN(kkp,"Msimg")) kkp += " -lMsimg32";
#endif

  fprintf(ou," %s\n\n",st2.c_str());
  fprintf(ou,"FOXIDENT = -DFOX_VERSION_NUMBER=%d %s\n\n",ver,verstr.c_str());
  fprintf(ou,"FOXLIBS = -L%s/lib %s\n", arg1.c_str(), kkp.c_str());
  fclose(ou);

  //--------------------------------------------------------------------

  ou = FOPEN(string(argv[2])+".h","w");
  fprintf(ou,"/*\n    EXPERIMENTAL (a typical \"config.h\")\n\n");
  fprintf(ou," this data was extracted from\n");
  fprintf(ou," \"%s/config.status\"\n and\n",arg1.c_str());
  fprintf(ou," \"%s/fox-config\" (%s)\n\n",  arg1.c_str(),clh::timecpy(0).c_str());
  fprintf(ou,"FOXCXXFLAGS =%s\n\n",st2.c_str());
  fprintf(ou,"*/\n\n");
  fprintf(ou,"#define FOX_VERSION_NUMBER %d // added by ExFoxDefin\n",ver);

  for (auto &d : defin) {
    st1=clh::replace(d,"="); st2="";
    LOOP(j,st1.size()) {if (st1[j]!='\\') st2+=st1[j];}
    fprintf(ou,"#define %s\n",st2.c_str());
  }

  fprintf(ou,"\n");
  fclose(ou);

  return 0;
}


