/*
 *  convenient Routines for the FOX lib
 */

#ifndef FXCLEMENS_H
#define FXCLEMENS_H 1

#include "clemiler.h"

#if MSCOMPILER > 0
#pragma warning ( disable : 4458 ) // declaration of ... hides class member
#pragma warning ( disable : 4146 ) // warning for a fox include file
#pragma warning ( disable : 4244 ) // warning for a fox include file
#endif

#include <fx.h>
#include "clemens.h"
#include "kaefer.h"

/* FOX_VERSION_NUMBER is 14 16 or 18 */

#if FOX_VERSION_NUMBER < 14
#error Fox Version must be at least 1.4
#endif

// timeouts used to be millisec, are nanosec now
#if FOX_VERSION_NUMBER < 18
#define TIMEOUTFAK 1
#else
static const FXTime TIMEOUTFAK = static_cast<FXTime>(1000000);
#endif

#ifndef MAYBE
#define MAYBE maybe
#endif
#ifndef FALSE
#define FALSE false
#endif
#ifndef TRUE
#define TRUE  true
#endif

#if MINGW==1
#undef  ZWERG
#undef  ZWErg
#define ZWERG(a)  /* cannot be used in */
#define ZWErg(a)  /* Windows GUI programs */
#endif

//   make a Matrix column FILL_X (this is typically meant)
//   (is an option for a matrix element, not FXMatrix itself)
// static const FXuint MATRIX_FILL_X = LAYOUT_FILL_COLUMN|LAYOUT_FILL_X;
// static const FXuint MATRIX_FILL_Y = LAYOUT_FILL_ROW|LAYOUT_FILL_Y;
#define  MATRIX_FILL_X   LAYOUT_FILL_COLUMN|LAYOUT_FILL_X
#define  MATRIX_FILL_Y   LAYOUT_FILL_ROW|LAYOUT_FILL_Y

static inline FXString FXSTRING(const string ss) {return FXString(ss.c_str());}
static inline string   STRING(const FXString ss) {return   string(ss.text());}

namespace clh {
  template <typename T, typename U, typename V>
  /**/                              inline FXString fxnum2str(const T n, const U w, const V p, const char f=' ') {
    /**/                                                                             return FXSTRING(num2str(n,w,p,f));}
  template <typename T, typename U> inline FXString fxnum2str(const T n, const U w) {return FXSTRING(num2str(n,w));}
  template <typename T>             inline FXString fxnum2str(const T n)            {return FXSTRING(num2str(n));}

  // you must declare the return type  float a = clh::fxstr2num<float>(ss);
  template <typename T> inline T fxstr2num(const FXString ss) {
    string tt = clh::replace(string(ss.text()), ",", '.');  //  string(ss.text())+"  ";
    T n; std::stringstream(tt + "  ") >> n;
    return n;
  }

  static inline  float fxstr2float (const FXString ss) {return fxstr2num<float>(ss);}
  static inline double fxstr2double(const FXString ss) {return fxstr2num<double>(ss);}
#if FOX_VERSION_NUMBER < 18
  static inline    int fxstr2int   (const FXString ss) {return fxstr2num<int>(ss);}
#else
  static inline    int fxstr2int   (const FXString ss) {return ss.toInt();}
  // static inline  float clh::fxstrfloat (const FXString ss) {return ss.toFloat();}
  // static inline double clh::fxstr2double(const FXString ss) {return ss.toDouble();}
#endif

  static inline int  system(const FXString ss) {return clh::system(string(ss.text()));}
}
static inline FILE *FOPEN(const FXString ss, const string rw="r") {
  FILE *v = fopen(ss.text(),rw.c_str()); return v;
}

// // fox and opengl still require this outdated raw memory with new and delete
// // this function works IF
// // -- dataX is always filled with at least 1 or 2 elements (do it in constructor)
// // -- dataX is deleted [] immediately before this function is called
// template <typename T> inline T *vector2bloodyNew(std::vector<T> &data) {
//   T *dataX = new T[clh::maxof(clh::cast(2),data.size())];  // never leave it empty
//   for (size_t n=0; n < data.size(); n++) dataX[n] = data[n];
//   data.clear();
//   return dataX;
// }
// #define VECTOR2BLOODYNEW(ddavec,ddanew) {delete [] ddanew; ddanew = vector2bloodyNew(ddavec);}


#if FOX_VERSION_NUMBER > 14
static const FXString UTF8_EURO         = "\xe2\x82\xac";  /* EURO */
static const FXString UTF8_CENT         = "\xc2\xa2";      /* CENT SIGN  */
static const FXString UTF8_DEGREE       = "\xc2\xb0";      /* DEGREE SIGN  */
static const FXString UTF8_PLUSMINUS    = "\xc2\xb1";      /* PLUS-MINUS SIGN  */
static const FXString UTF8_DIAMETER     = "\xe2\x8c\x80";  /* diameter sign */
static const FXString UTF8_COPYRIGHT    = "\xc2\xa9";      /* COPYRIGHT SIGN */
static const FXString UTF8_PPI          = "\xcf\x80";      /* GREEK SMALL   LETTER PI  */
static const FXString UTF8_MALTESECROSS = "\xe2\x9c\xa0";  // U+2720  ✠

static const FXString UTF8_A = "\xc3\x84";   /* LATIN CAPITAL LETTER A WITH DIAERESIS */
static const FXString UTF8_E = "\xc3\x8b";   /* LATIN CAPITAL LETTER E WITH DIAERESIS */
static const FXString UTF8_I = "\xc3\x8f";   /* LATIN CAPITAL LETTER I WITH DIAERESIS */
static const FXString UTF8_O = "\xc3\x96";   /* LATIN CAPITAL LETTER O WITH DIAERESIS */
static const FXString UTF8_U = "\xc3\x9c";   /* LATIN CAPITAL LETTER U WITH DIAERESIS */
static const FXString UTF8_a = "\xc3\xa4";   /* LATIN SMALL   LETTER A WITH DIAERESIS */
static const FXString UTF8_e = "\xc3\xab";   /* LATIN SMALL   LETTER E WITH DIAERESIS */
static const FXString UTF8_i = "\xc3\xaf";   /* LATIN SMALL   LETTER I WITH DIAERESIS */
static const FXString UTF8_o = "\xc3\xb6";   /* LATIN SMALL   LETTER O WITH DIAERESIS */
static const FXString UTF8_u = "\xc3\xbc";   /* LATIN SMALL   LETTER U WITH DIAERESIS */
static const FXString UTF8_s = "\xc3\x9f";   /* LATIN SMALL   LETTER SHARP S */
#endif

static inline FXString ascii2UTF8(const char *txt) {
  FXString ss = "";
  if (strlen(txt)<2) return ss;
  char c = txt[0];

  for (short i=1; true; i++) {
    if (txt[i]=='+') {
      switch(c) {
#if FOX_VERSION_NUMBER == 14
      case 'A': ss +=  "Ä";    break;
      case 'O': ss +=  "Ö";    break;
      case 'U': ss +=  "Ü";    break;
      case 'a': ss +=  "ä";    break;
      case 'o': ss +=  "ö";    break;
      case 'u': ss +=  "ü";    break;
      case 's': ss +=  "ß";    break;
      case 'E': ss +=  "Euro"; break;
      case 'c': ss +=  "(c)";  break;
      case 'p': ss +=  "pi";   break;
#else
      case 'A': ss +=  UTF8_A ; break;
      case 'O': ss +=  UTF8_O ; break;
      case 'U': ss +=  UTF8_U ; break;
      case 'a': ss +=  UTF8_a ; break;
      case 'o': ss +=  UTF8_o ; break;
      case 'u': ss +=  UTF8_u ; break;
      case 's': ss +=  UTF8_s ; break;
      case 'E': ss +=  UTF8_EURO     ; break;
      case 'c': ss +=  UTF8_COPYRIGHT; break;
      case 'p': ss +=  UTF8_PPI      ; break;
#endif
      default: ss += FXString("+");
      }
      i++;
    } else {
      const char g[] = {c, '\0'};
      ss += FXString(g);
    }
    c = txt[i];
    if (c=='\0') break;
  }
  return ss;
}

#endif

