
/* helps debugging GUI programs even under Windows */
/* KAEFER is a possible German translation of BUG  */

#ifndef KAEFER_H
#define KAEFER_H 1

#ifndef KAEFER
#define KAEFER 0
#endif

#if KAEFER==0

#define DBGINITFILE(a)  /* a */
#define DBGINIT         /* no KAEFER */
#define DBGENTER        /* a */
#define DBGLEAVE        /* a */
#define DBGINFO(a)      /* a */
#define DBGINUM(a)      /* a */
#define DBGV(a)         /* a */
#define DBGX(...)       /* _VA_ARGS_ */
#define DBGSTAT         /* a */
#define DBG1(a)         /* a */
#define DBG2(a,b)       /* a b */
#define DBG3(a,b,c)     /* a b c */
#define DBG4(a,b,c,d)   /* a b c */
#define DBG5(a,b,c,d,e) /* a b c */

#else

// #if ALLOW_CPP17==0
// template <typename U>                 void DBGauxfun(std::ostringstream &os, U b)          {os << b;}
// template <typename U, typename ... R> void DBGauxfun(std::ostringstream &os, U b, R ... c) {os << b; DBGauxfun(os, c ...);}
// #else
inline string KAEFERfilnam;
inline std::chrono::system_clock::time_point KAEFERchronostart;
// #endif

template <typename U>                 void DBGaux(const int siof, std::vector<string> &ss, U b) {
  ss[siof-2] += ("=" + clh::num2str(b) + " ");
}
template <typename U, typename ... R> void DBGaux(const int siof, std::vector<string> &ss, U b, R ... c) {
  int sjof = sizeof...(c);
  if (siof == sjof+1) {
    string xx, bbb = clh::whitetrim(clh::num2str(b),true);  int block = 0;
    for (auto &z : bbb) {
      if (z == '(')   block++;   // for Carry or functions
      if (z == ',' && block>0) z = '!';
      if (z == ')')   block--;
    }
    std::istringstream ist(clh::replace(bbb, ","));
    for (auto &s : ss) {ist >> xx; s = clh::replace(xx,"!",',');}
  } else {
    DBGaux(siof-sjof, ss, b);   // ss[siof-2-sjof] += ("=" + clh::num2str(b) + " ");
  }
  DBGaux(siof, ss, c ...);
}

template <typename ...T> inline void DBGfunny(const int what, const string file,
					      const int line, const string fun,
					      const T & ...a) {

  static int KAEFERascii = 31;  // so that something always changes on a terminal
  if (++KAEFERascii == 126) KAEFERascii = 32;
  if (what == 20) KAEFERchronostart = std::chrono::system_clock::now();

  string tt;
  std::ostringstream os;
  int siof = sizeof...(a);

  os << "|" <<  static_cast<char>(KAEFERascii) << "|"
     <<  std::right << std::setw( 6) << line << ": "
     <<  std::left  << std::setw(25) << file << " "
     <<  std::left  << std::setw(20) << fun  << " ";

  if (what > 10) {
    if (what != 92) ((os << a), ...);
    tt = os.str();

  } else {
    tt = os.str();
    std::vector<string> ss(siof-1);    // this is not made for efficiency
    DBGaux(siof, ss, a...);
    for (const auto &d : ss) tt += (d + " ");
  }

  auto elapsed = std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::system_clock::now() - KAEFERchronostart).count();
  if (elapsed < 1000000000) tt += "     [" + clh::num2str(elapsed) + "]";  // otherwise DBGINIT was not set

  if (KAEFERfilnam == "") {
    cout << tt << endl;
  } else {
    string        fil = clh::mktmpdir(KAEFERfilnam);
    std::ofstream kout;
    if (what==20) kout.open(fil.c_str(),std::ofstream::out);
    else          kout.open(fil.c_str(),std::ofstream::out|std::ofstream::app);
    kout << tt << endl;
    kout.close();    // enforce writing of file even if program crashes
  }
}

#define DBGINIT          DBGfunny(20,__FILE__,__LINE__,__func__,"DBGINIT: ")
static inline       void DBGINITFILE(const string a) {KAEFERfilnam=a; DBGINIT;}

#define DBGENTER         DBGfunny(12,__FILE__,__LINE__,__func__, "begin of function: ", __func__)
#define DBGLEAVE         DBGfunny(12,__FILE__,__LINE__,__func__, "end   of function: ", __func__)
#define DBGSTAT          DBGfunny(92,__FILE__,__LINE__,__func__, "92 not printed")
#define DBGINFO(a)       DBGfunny(12,__FILE__,__LINE__,__func__, #a)
#define DBGV(a)          DBGfunny(12,__FILE__,__LINE__,__func__, #a,"[]=",a[0]," ",a[1]," ",a[2])
#define DBGX(...)        DBGfunny( 0,__FILE__,__LINE__,__func__, #__VA_ARGS__, __VA_ARGS__)

// those below are deprecated, but still widely in use
#define DBGINUM(a)       DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a)
#define DBG1(a)          DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a)
#define DBG2(a,b)        DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a," ",#b,'=',b)
#define DBG3(a,b,c)      DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a," ",#b,'=',b," ",#c,'=',c)
#define DBG4(a,b,c,d)    DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a," ",#b,'=',b," ",#c,'=',c," ",#d,'=',d)
#define DBG5(a,b,c,d,e)  DBGfunny(12,__FILE__,__LINE__,__func__, #a,'=',a," ",#b,'=',b," ",#c,'=',c," ",#d,'=',d," ",#e,'=',e)

#endif
#endif

