
/*  ModDate - Clemens Schiff 2003

 A superficial program which is called whenever another program is compiled.
 I use it to keep track of the modification date of the youngest of all files
 involved in the project and the project's compilation date that can be
 displayed in the ABOUT box.
 It does so by generating a C funtion where this information is kept. You
 can incorporate this function in your project.
 Additionally the very first creation date of the function written by ModDate
 is kept and a version number counts every modification.

usage:
 moddate about.cpp first.d second.d third.d .....

 where about.cpp would be the file generated by ModDate

----------------------------------------------------------------------------

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a kopy of the GNU General Public License
   along with this program; if not, see:  http://www.fsf.org
*/


#include "clemens.h"
#include "cocain.h"

// ------------------------------------------------------------------------

#include <sys/stat.h>
#if MINGW==1
#include <sys/utime.h>
#endif
#if LINUX==1
#include <utime.h>  
#endif

static void resetTime(const char infile[], const time_t mtime) {  // set times of infile to mtime
  struct utimbuf zeit;
  zeit.modtime = mtime;
  utime(infile,&zeit);
}

// static void resetTime(const string infile, const time_t mtime) {
//   resetTime(infile.c_str(), mtime);
// }

// ------------------------------------------------------------------------

#define FNLEN 200000
#define NC    1000


int main(int argc,char *argv[]) {
  FILE *ou;
  string st;
  char ss[FNLEN], tt[256], uu[NC][256];
  time_t zeit=0, oldzeit=0, first=0;
  long   ze7,    oz7,       fi7, version=0L;
  int nanz=0;
  string s1;

  if (argc<2) {
    printf("ERROR in MODDATE: arguments expected\n");
    exit(1);
  }

  if ( (ou = fopen(argv[1],"r")) != NULL ) {
    s1 = clh::fgets(ou,100);
    // check if the first argument is the correct one
    if (s1 != "/*MOddATE*/") {
      printf("ERROR in MODDATE: first arg seems to be wrong\n");
      exit(1);
    }
    // read stored modification time, creation time and version number
    s1 = clh::fgets(ou,100);
    strcpy(tt,s1.c_str()); // should be done better
    sscanf(&tt[12],"%ld %ld %ld",&oz7,&fi7,&version);
    oldzeit = static_cast<time_t>(oz7);
    first   = static_cast<time_t>(fi7);
    fclose(ou);
  } else {
    // or set creation time
    first=time(NULL);
  }

  // now read all <>.d files to see which files belong to the specific
  // project
  Cocain cocain('C',NULL,FNLEN);
  // KeepFileTime kft;

  for (int arg=2; arg<argc; arg++) {       //           cout << EVA(argv[arg]) << endl;
    if (cocain.open(string(argv[arg])) == NULL) continue;
    st = cocain.read(); // cocain reads continuation lines
    cocain.close();
    strcpy(ss,st.c_str());
    int i=2; while (ss[i-1]!=':') i++;  // .o file

    int j,k,go=1;
    while (go) {
      while (ss[i]==' ') i++;
      j=k=0;
      while (ss[i]!=' ') {
        tt[j]=ss[i]; i++; j++;
        if (ss[i]=='\0') {go=0; break;}
        if (ss[i]=='/')  k=1; // ignore files not in this directory
      }
      tt[j]='\0';
      if (k) continue;
      k=0; LOOP(i,nanz) {if (!strcmp(&uu[i][0],tt)) {k=1; break;}}
      if (k) continue;
      strcpy(&uu[nanz][0],tt); nanz++;
      // (fx)clemens.h, kaefer.h belongs to many projects, not just this one
      // // same with csmainwin(def).h
      string clem = string(tt);
      if (clh::substrcompa(clem,0,"clem"     )) continue;
      if (clh::substrcompa(clem,0,"fxclem"   )) continue;      
      if (clh::substrcompa(clem,0,"csmainwin")) continue;
      if (clh::substrcompa(clem,0,"kaefer.h" )) continue;

      clh::fileAttrib fiat(tt);
      zeit = clh::maxof(fiat.get_Mtime(), zeit);
    }
  }
  if (zeit > oldzeit) version++;

  // write a C function that can be added to the project
#if MINGW==1
  ou = FOPEN(clh::mktmpdir(string(argv[1])),"w");
  if (ou == NULL) {cout << "cannot open " <<  clh::mktmpdir(string(argv[1])) << endl; exit(8);}
#else
  ou = fopen(argv[1],"w");
#endif
  fprintf(ou,"/*MOddATE*/\n");

  ze7 = static_cast<long>(zeit);
  fi7 = static_cast<long>(first);
  fprintf(ou,"/*modtime   %ld %ld %ld 0 0 0   */\n", ze7,fi7,version);
  fprintf(ou,"const char *moddate(const int i) {\n");

  s1=clh::noeol(string(ctime(&zeit)));
  fprintf(ou,"  if (i==1) return \"%s\"; /* modification time */\n",s1.c_str());

  fprintf(ou,"  if (i==2) return \""); clh::timeprt(ou, "\"; /* compile time */\n");

  if (first > 9000) {
    s1=clh::noeol(string(ctime(&first)));
    fprintf(ou,"  if (i==3) return \"%s\"; /* creation time */\n",s1.c_str());
  } else {
    first=1000000000;
    fprintf(ou,"  if (i==3) return \"2002 or earlier\"; /* creation time */\n");
  }
  fprintf(ou,"  if (i==4) return \"%ld\"; /* version number */\n",version);
  fprintf(ou,"  return \"??\";\n}\n");


  fprintf(ou,"\n/* this project consists of the following files:\n\n");
  std::vector<string> fil;  // what a mess....
  LOOP(i,nanz) fil.push_back(string(&uu[i][0]));
  size_t k=0;
  // sort them by name
  std::sort(fil.begin(),fil.end(), [&](string a, string b) {return clh::lower(a) < clh::lower(b);});
  for (auto a : fil) {
    k += a.size() +1;
    fprintf(ou,"%s ",a.c_str());
    if (k>60) {fprintf(ou,"\\\n"); k=0;}
  }
  fprintf(ou,"\n\n");

  // sort them by extension
  std::stable_sort(fil.begin(),fil.end(), [&](string a, string b) {return clh::getfext(a) < clh::getfext(b);});
  for (auto a : fil) fprintf(ou,"#$#TGZ#  %s\n",a.c_str());
  fprintf(ou,"\n*/\n");

  fclose(ou);

#if MINGW==1
  clh::kopie(clh::mktmpdir(string(argv[1])), string(argv[1]), 1);   // get rid of \r\n
#endif

  resetTime(argv[1], first);
  return 0;
}

