/* Pingo.cpp
   Copyright (C) 2002 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pinglob.h"
#include "pinedit.h"


FXDEFMAP(Pinedit) PineditMap[]={
  //________Message_Type_________ID_____________________Message_Handler_______
  FXMAPFUNC(SEL_COMMAND,       Pinedit::ID_LANG1,    Pinedit::onCmdLang),
  FXMAPFUNC(SEL_UPDATE,        Pinedit::ID_LANG1,    Pinedit::onUpdLang),
  FXMAPFUNC(SEL_COMMAND,       Pinedit::ID_LANG2,    Pinedit::onCmdLang),
  FXMAPFUNC(SEL_UPDATE,        Pinedit::ID_LANG2,    Pinedit::onUpdLang),
  FXMAPFUNC(SEL_COMMAND,       Pinedit::ID_CHOOSE,   Pinedit::onCmdChoose),
  FXMAPFUNC(SEL_COMMAND,       Pinedit::ID_NEW,      Pinedit::onCmdNew),
  };

// Macro for the Pinedit class hierarchy implementation
FXIMPLEMENT(Pinedit,FXDialogBox,PineditMap,ARRAYNUMBER(PineditMap))


// Construct a Pinedit
  Pinedit::Pinedit(FXWindow *own, FXSelector sel_cancel,
		   FXSelector sel_save, FXSelector sel_delete):
       FXDialogBox(own,"Charly Settings",DECOR_ALL,00,00,600,250) {

  //  ---------------------------

  localmax=level=-8;
  changedpic=false;
  language=GERMAN;

  labl = new FXLabel(this,"-",NULL,LAYOUT_CENTER_X);

  mat1=new FXMatrix(this,2,
       MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_CENTER_X|LAYOUT_TOP|PACK_UNIFORM_WIDTH);

  lab1 = new FXLabel(mat1,"-",NULL,LAYOUT_FILL_Y|LAYOUT_FILL_X);
  txt1 = new FXTextField(mat1,8,this, ID_VER, LAYOUT_CENTER_X);
  lab2 = new FXLabel(mat1,"-",NULL,LAYOUT_FILL_Y|LAYOUT_FILL_X);
  txt2 = new FXTextField(mat1,8,this, ID_VER, LAYOUT_CENTER_X);
  txt1->setText("0");  txt1->setBackColor(EXITCOL);
  txt2->setText("0"); txt2->setBackColor(EXITCOL);

  but3 = new FXButton(mat1,"-",NULL,this,ID_CHOOSE,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  lab3 = new FXLabel(mat1,"-",NULL,LAYOUT_FILL_Y|LAYOUT_FILL_X);

  lab8 = new FXLabel(mat1,"-",NULL,LAYOUT_FILL_Y|LAYOUT_FILL_X);
  txt8 = new FXTextField(mat1,8,this, ID_VER, LAYOUT_CENTER_X);
  txt8->setText("0"); txt8->setBackColor(EXITCOL);

  hor1 = new FXHorizontalSeparator(this,LAYOUT_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

  fra1 = new FXHorizontalFrame(this,LAYOUT_CENTER_X|LAYOUT_TOP|PACK_UNIFORM_WIDTH);
  lab0 = new FXLabel(fra1,"Sprache / language",NULL,LAYOUT_CENTER_Y);
  but1 = new FXButton(fra1,"Deutsch",NULL,this,ID_LANG1,
    FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y);
  but2 = new FXButton(fra1,"English",NULL,this,ID_LANG2,
    FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y);

  hor2 = new FXHorizontalSeparator(this,LAYOUT_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

  fra2 = new FXHorizontalFrame(this,LAYOUT_CENTER_X|LAYOUT_BOTTOM|PACK_UNIFORM_WIDTH);
  but4 = new FXButton(fra2,"-",NULL, own,sel_save, // this,ID_TAKE_IT,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_BOTTOM);
  but7 = new FXButton(fra2,"-",NULL,this,ID_NEW,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_BOTTOM);
  but5 = new FXButton(fra2,"-",NULL, own,sel_cancel, //this,ID_CANCEL,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_BOTTOM);
  but6 = new FXButton(fra2,"-",NULL, own,sel_delete, // this,ID_DELETE,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_BOTTOM);
}


void Pinedit::initia(int numpin, int spielzeit, int speed,
		     FXString imgfile1, int level1, int maxlevel1, int lan1) {
  txt1->setText(clh::fxnum2str(numpin));
  txt2->setText(clh::fxnum2str(spielzeit));
  txt8->setText(clh::fxnum2str(speed));
  level=level1;
  localmax=maxlevel=maxlevel1;
  imgfile  = imgfile1;
  language = lan1;
}


long Pinedit::onCmdChoose(FXObject*,FXSelector,void*){
  const FXchar patterns[]=
#if LINUX==1
    "Portable Images (*.ppm)\n"
    "Windows Bitmaps (*.bmp)\n"
#elif MINGW==1
    "Windows Bitmaps (*.bmp)\n"
    "Portable Images (*.ppm)\n"
#else
#error unsupported OS
#endif
    ;

  FXFileDialog open(this,"-");
  open.setPatternList(patterns);
  open.setDirectory(last_pic_dir); // same directory as current picture
  if (open.execute()) {changedpic=true; imgfile= open.getFilename();}
  return 1;
}


long Pinedit::onCmdNew(FXObject*, FXSelector, void*){
  txt1->setText("1");
  txt2->setText("3000");
  txt8->setText("50");
  imgfile="??";
  localmax=level=maxlevel+1;
  return 1;
}


long Pinedit::onCmdLang(FXObject *,FXSelector sel, void*){
  language=GERMAN;
  if (FXSELID(sel)==ID_LANG2) language=ENGLISH;
  return 1;
}


long Pinedit::onUpdLang(FXObject *sender,FXSelector sel,void*) {
  static int language_was = -8;
  FXuint msg = ID_UNCHECK;
  if (language==GERMAN  && FXSELID(sel)==ID_LANG1) msg=ID_CHECK;
  if (language==ENGLISH && FXSELID(sel)==ID_LANG2) msg=ID_CHECK;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),NULL);

  lab3->setText(imgfile);
  if (maxlevel<1) but6->disable(); else but6->enable(); // delete button

  if (language==GERMAN)
    labl->setText("\nEinstellungen fuer Level " + clh::fxnum2str(level));

  if (language==ENGLISH)
    labl->setText("\nsettings for level " + clh::fxnum2str(level));

  if (language_was != language) {
    language_was=language;
    if (language==GERMAN) {
      lab1->setText("Anzahl der Charlies (max. " + clh::fxnum2str(MAXPEN) +")");
      lab2->setText("Spielzeit (in Sekunden)");
      but3->setText("Bildauswahl");
      but4->setText("Eintrag speichern\nund beenden");
      but5->setText("\nAbbrechen");
      but6->setText("Eintrag\nloeschen");
      but7->setText("neuer\nEintrag");
      lab8->setText("Spielverzoegerung [in msec]");
    }
    if (language==ENGLISH) {
      lab1->setText("number of Charlies (max. " + clh::fxnum2str(MAXPEN) +")");
      lab2->setText("time to play (in seconds)");
      but3->setText("choose picture");
      but4->setText("save entry\nand exit");
      but5->setText("\ncancel");
      but6->setText("delete\nentry");
      but7->setText("new\nentry");
      lab8->setText("extra delay [in msec]");
    }
  }
  return 1;
}


