/* 
 * Copyright (C) 2002 Clemens Schiff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 *
 * or get it at http://www.fsf.org
 */

#ifndef PINEDIT_H
#define PINEDIT_H 1

// Event Handler Object
class Pinedit : public FXDialogBox {
  FXDECLARE(Pinedit)

private:
  FXLabel     *lab0, *lab1, *lab2, *lab3, *labl, *lab8;
  FXTextField *txt1, *txt2, *txt8;
  FXButton    *but1, *but2, *but3, *but4, *but5, *but6, *but7;
  FXHorizontalFrame *fra1, *fra2;
  FXMatrix    *mat1;
  FXHorizontalSeparator *hor1, *hor2;
  FXString last_pic_dir, imgfile;

  int  level, maxlevel, localmax, language;
  bool changedpic;

  int getIntNum(FXTextField *txt) {
    FXString s = txt->getText();
    if (!s.length()) return 0;
    return clh::fxstr2int(s);
  }

public:

  enum{
    ID_LANG1=FXDialogBox::ID_LAST, ID_LANG2, ID_VER,
    ID_CHOOSE, ID_NEW,
    ID_LAST
    };

  // Message handlers
  long onCmdLang(FXObject*,FXSelector,void*);
  long onUpdLang(FXObject*,FXSelector,void*);
  long onCmdChoose(FXObject*,FXSelector,void*);
  long onCmdNew(FXObject*,FXSelector,void*);

  ~Pinedit() {       // Destructor
    delete lab0; delete lab1; delete lab2; delete lab3; delete labl; delete lab8;
    delete txt1; delete txt2; delete txt8;
    delete but1; delete but2; delete but3; delete but4;
    delete but5; delete but6; delete but7;
    delete fra1; delete fra2;
    delete mat1;
    delete hor1; delete hor2;
  }

  void     setLastDir(FXString ladi) {last_pic_dir=ladi;}
  FXString getLastDir()              {return last_pic_dir;}
  void     setimagefile(FXString im) {imgfile=im; changedpic=false;}
  FXString getimagefile()            {return imgfile;}

  bool anotherpic() {return changedpic;}
  bool anotherlevel() {return maxlevel!=localmax;}
  int  getnumpin()    {return getIntNum(txt1);}
  int  getspielzeit() {return getIntNum(txt2);}
  int  getspeed()     {return getIntNum(txt8);}
  int  getlanguage()  {return language;} 
  void initia(int numpin, int spielzeit, int speed,
	      FXString imgfile1, int level1, int maxlevel1, int lan1);

  Pinedit() { }      // Pinedit constructors
  Pinedit(FXWindow *owner, FXSelector sel_cancel,
	  FXSelector sel_save, FXSelector sel_delete);
};

#endif
