/* 
 * Copyright (C) 2002 Clemens Schiff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 *
 * or get it at http://www.fsf.org
 */
#ifndef PINGLOB_H
#define PINGLOB_H 1

// for those cases where Charly is not a standalone game
#ifndef FXCLEMENS_H

// if set it helps debugging on Windows 
// (KAEFER is one possible German translation for Bug)
// #define KAEFER 1
#include "fxclemens.h"

#endif

// max. number of penguins
#define MAXPEN 20
// color of exit
#define EXRED    20
#define EXGREEN 127
#define EXBLUE  255
#define EXITCOL FXRGB(EXRED,EXGREEN,EXBLUE)
// width + height of exit (must be odd)
#define EXITDIM  41

// language
#define GERMAN  11
#define ENGLISH 22

// beamer color
#define BERED   211
#define BEGREEN 41
#define BEBLUE  41
#define BEAMCOL FXRGB(BERED,BEGREEN,BEBLUE)

#define FOI(ii)  for(int i=0; i<static_cast<int>(ii); i++)
#define FOJ(ii)  for(int j=0; j<static_cast<int>(ii); j++)
#define FOK(ii)  for(int k=0; k<static_cast<int>(ii); k++)
#define FOL(ii)  for(int l=0; l<static_cast<int>(ii); l++)
#define FOM(ii)  for(int m=0; m<static_cast<int>(ii); m++)
#define FON(ii)  for(int n=0; n<static_cast<int>(ii); n++)

#endif
