/* Pingo.cpp
   Copyright (C) 2001 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pinglob.h"
#include "pingo.h"

#include "pingo.fm"
// prototypes
const char *moddate(const int i);

const unsigned char penguin[]={
 0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x12,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
 0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x10,0x10,0x10,0xff,0xff,0xff,0xe0,
 0xa0,0x08,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x12,0x00,0x00,0x03,
 0x53,0x08,0xba,0x21,0x12,0x2b,0xc6,0xe6,0x9e,0x94,0x62,0x64,0x77,0xa3,0x20,0x4e,
 0x21,0x74,0x8b,0x60,0x9c,0x1a,0xa9,0x98,0xa8,0x45,0xb2,0x85,0x38,0x76,0x4f,0x6c,
 0xbb,0x93,0x60,0xdb,0x0d,0xe4,0xd9,0x83,0x1d,0xe7,0x57,0x18,0x04,0x6f,0xb8,0x4c,
 0xec,0x88,0x9c,0x01,0x0c,0x47,0x66,0xac,0xa2,0x38,0x19,0x76,0x36,0x83,0xc3,0xf0,
 0xb4,0x5e,0x77,0x03,0xaf,0xf8,0x7b,0x13,0x77,0xad,0xd3,0xad,0x75,0x61,0xa5,0x54,
 0x02,0x27,0x45,0x02,0x00,0x3b
};


// Construct a Pingo
Pingo::Pingo(FXApp *appli,
         FXComposite *p, FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
         FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
  Charly(appli,p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {

  mawi = static_cast<FXMainWindow *>(p);

  new FXButton(buttonFrame," exit  ",NULL,this,ID_QUIT,
     FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT);

  FXMatrix *matrix=new FXMatrix(buttonFrame,2,
    MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,0,0,0,0,0,0);
  start = new CSButton(matrix,"START",NULL,this,ID_START,
    FRAME_THICK|FRAME_RAISED|MATRIX_FILL_X|MATRIX_FILL_Y);
  edit  = new FXButton(matrix," edit ",NULL,this,ID_EDIT,
    FRAME_THICK|FRAME_RAISED|MATRIX_FILL_X|MATRIX_FILL_Y);
  new FXButton(matrix,"STOP",NULL,this,ID_STOP,
    FRAME_THICK|FRAME_RAISED|MATRIX_FILL_X|MATRIX_FILL_Y);
  new FXButton(matrix," abt. ",NULL,this,ID_ABOUT,
    FRAME_THICK|FRAME_RAISED|MATRIX_FILL_X|MATRIX_FILL_Y);

  setlevel = new FXSpinner(buttonFrame,4,this,ID_LEVEL,
    SPIN_CYCLIC|FRAME_SUNKEN|FRAME_THICK|MATRIX_FILL_Y|LAYOUT_RIGHT);
  setlevel->disable();
  setlevel->setValue(ice->level);

  pinedit = new Pinedit(this, Pingo::ID_EDIT_CANCEL,
			Pingo::ID_EDIT_SAVE, Pingo::ID_EDIT_DELETE);
  pinedit->hide();
  pininfo.clear();
  maxlevel=0;
} // end of constructor


// Create and initialize 
void Pingo::create(){
  Charly::create();  // Create the windows

  FXint x,y,w,h; FXString s;
  w = app->reg().readIntEntry("SETTINGS","width", 850);  // Get size
  h = app->reg().readIntEntry("SETTINGS","height",600);
  x = app->reg().readIntEntry("SETTINGS","XPos",  50);
  y = app->reg().readIntEntry("SETTINGS","YPos",  50);
  mawi->position(x,y,w,h);

  ice->language = app->reg().readIntEntry("SETTINGS","Language",GERMAN);
  s = app->reg().readStringEntry("SETTINGS","lastPicDir", "");
  pinedit->setLastDir(s);

  for (int mm=0; mm<999999; mm++) {
    s = "CharlyLevel" + clh::fxnum2str(mm);
#if FOX_VERSION_NUMBER < 18
    w = app->reg().readIntEntry(s.text(),"numpin", -8);
#else
    w = app->reg().readIntEntry(s,"numpin", -8);
#endif
    if (w<0) break;
    pininfo.push_back(PinInfo());
    pininfo[mm].numpin    = w;
    pininfo[mm].spielzeit = app->reg().readIntEntry(s.text(),"spielzeit", 120);
    pininfo[mm].speed     = app->reg().readIntEntry(s.text(),"speed", 20);
    pininfo[mm].exitx     = app->reg().readIntEntry(s.text(),"exitx", 20);
    pininfo[mm].exity     = app->reg().readIntEntry(s.text(),"exity", 20);
    pininfo[mm].beamcoor[0] = 0;
    pininfo[mm].beamcoor[1] = app->reg().readIntEntry(s.text(),"beamcoor[1]", 0);
    pininfo[mm].beamcoor[2] = app->reg().readIntEntry(s.text(),"beamcoor[2]", 0);
    pininfo[mm].beamcoor[3] = app->reg().readIntEntry(s.text(),"beamcoor[3]", 0);
    pininfo[mm].beamcoor[4] = app->reg().readIntEntry(s.text(),"beamcoor[4]", 0);

    s = app->reg().readStringEntry(s.text(),"imgfile", "");
    strcpy(pininfo[mm].imgfile,s.text());
  }
  maxlevel=static_cast<int>(pininfo.size());

  if (maxlevel==0) {
    numpin=5; spielzeit=300; speed=50; strcpy(imgfile,"??");
    app->addTimeout(this,ID_EDIT,1000*TIMEOUTFAK);
  } else {
    setlevel->enable();
    setlevel->setRange(1,maxlevel);
    pinopen();
  }
}

// Quit
long Pingo::onCmdQuit(FXObject*,FXSelector,void*) {
  app->reg().writeIntEntry("SETTINGS","width", mawi->getWidth());
  app->reg().writeIntEntry("SETTINGS","height",mawi->getHeight());
  app->reg().writeIntEntry("SETTINGS","XPos",  mawi->getX());
  app->reg().writeIntEntry("SETTINGS","YPos",  mawi->getY());
  app->reg().writeIntEntry("SETTINGS","Language", ice->language);
  app->reg().writeStringEntry("SETTINGS","lastPicDir",pinedit->getLastDir().text());

  for (int mm=0; mm<maxlevel; mm++) {
    FXString s = "CharlyLevel" + clh::fxnum2str(mm);
    app->reg().writeIntEntry(s.text(),"numpin",     pininfo[mm].numpin);
    app->reg().writeIntEntry(s.text(),"spielzeit",  pininfo[mm].spielzeit);
    app->reg().writeIntEntry(s.text(),"speed",      pininfo[mm].speed);
    app->reg().writeIntEntry(s.text(),"exitx",      pininfo[mm].exitx);
    app->reg().writeIntEntry(s.text(),"exity",      pininfo[mm].exity);
    app->reg().writeIntEntry(s.text(),"beamcoor[1]",pininfo[mm].beamcoor[1]);
    app->reg().writeIntEntry(s.text(),"beamcoor[2]",pininfo[mm].beamcoor[2]);
    app->reg().writeIntEntry(s.text(),"beamcoor[3]",pininfo[mm].beamcoor[3]);
    app->reg().writeIntEntry(s.text(),"beamcoor[4]",pininfo[mm].beamcoor[4]);
    app->reg().writeStringEntry(s.text(),"imgfile", pininfo[mm].imgfile);
  }
  for (int mm=maxlevel; mm<999999; mm++) {
    FXString s = "CharlyLevel" + clh::fxnum2str(mm);
    if (app->reg().existingSection(s.text())) {
      app->reg().deleteSection(s.text());
    } else {
      break;
  } }

  app->exit(0);
  return 1;
}

// About box
long Pingo::onCmdAbout(FXObject*,FXSelector,void*){

  FXMessageBox about(this,"About Charly",
#if FOX_VERSION_NUMBER==16
    FXStringFormat(
#else
    FXString::value(
#endif
 "CHARLY - Version 1.1.%s - (c) Clemens Schiff\n\nlast modified: %s\nfirst compiled: around 2002\nlast compiled: %s\n\nmany thanks to:\n- FOX GUI Library Version %s (www.fox-toolkit.org)\n- project pingus (pingus.seul.org): animated penguins\n- Simon for testing\n\nThis program is free software; you can redistribute it and/or modify it\nunder the terms of the GNU General Public License (www.fsf.org)",
       moddate(4),moddate(1),moddate(2),VERSION),
  NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
  about.execute();
  return 1;
}


void Pingo::finished() {
  Charly::finished();
  setlevel->enable(); edit->enable();
}


long Pingo::onUpdStart(FXObject *obj, FXSelector sel,void*) {
  FXuint ena=ID_DISABLE;
  switch(FXSELID(sel)) {
  case ID_START: if (totalstop==2) ena=ID_ENABLE; break;
  case ID_STOP:  if (totalstop==0) ena=ID_ENABLE; break;
  default: break;
  }
  obj->handle(this,FXSEL(SEL_COMMAND,ena),NULL);
  return 1;
}

long Pingo::onCmdStop(FXObject *,FXSelector ,void*) {
  stop_the_game();
  return 1;
}


long Pingo::onCmdEdit(FXObject *, FXSelector sel, void*) {

  switch(FXSELID(sel)) {
  case ID_EDIT:
    setlevel->disable();
    pinedit->initia(numpin,spielzeit,speed,
		    FXString(imgfile),ice->level,maxlevel,ice->language);
    pinedit->show(PLACEMENT_SCREEN);
    return 1;
    break;
  case ID_EDIT_SAVE:
    strcpy(imgfile,pinedit->getimagefile().text());
    if (strlen(imgfile)>4) {
      if (pinedit->anotherlevel() || maxlevel==0) {
	pininfo.push_back(PinInfo());
	ice->level = maxlevel = static_cast<int>(pininfo.size());
	setlevel->setRange(1,maxlevel);
	setlevel->setValue(ice->level);
      }
      int lev = ice->level-1;
      pininfo[lev].numpin    = clh::maxof(1,clh::minof(MAXPEN,pinedit->getnumpin()));
      pininfo[lev].spielzeit = clh::maxof(120,pinedit->getspielzeit());
      pininfo[lev].speed     = clh::maxof(  5,pinedit->getspeed());
      strcpy(pininfo[lev].imgfile,imgfile);
      if (pinedit->anotherpic()) {
	pininfo[lev].exitx=pininfo[lev].exity=0;
	FOI(5) pininfo[lev].beamcoor[i]=0;
      }
    }
    pinopen();
    break;
    case ID_EDIT_DELETE:
      {
        vector <PinInfo>::iterator it=pininfo.begin();
        int n=-1, lev = ice->level-1;
        if (maxlevel>0) {
          while (++n<lev) ++it;
          pininfo.erase(it);
	}
        maxlevel = static_cast<int>(pininfo.size());
        if (lev==0) ice->level = maxlevel; else ice->level--;
      }
      setlevel->setRange(1,maxlevel);
      setlevel->setValue(ice->level);
      break;
    default: break;
  }
  setlevel->enable();
  pinedit->hide();
  return 1;
}

long Pingo::onCmdLevel(FXObject *,FXSelector ,void*) {
  ice->level = setlevel->getValue();
  pinopen();
  return 1;
}

void Pingo::pinopen() {
  int lev = ice->level-1;

  numpin     = pininfo[lev].numpin;
  spielzeit  = pininfo[lev].spielzeit;
  speed      = pininfo[lev].speed;
  ice->exitx = pininfo[lev].exitx;
  ice->exity = pininfo[lev].exity;
  FOI(5) beamcoor[i] = pininfo[lev].beamcoor[i];
  strcpy(imgfile,pininfo[lev].imgfile);

  Charly::pinopen();
}

///------------------------------------------------------

// Start new game
long Pingo::onCmdStart(FXObject *,FXSelector,void*){
  FILE *in;

  if ( (in = fopen(imgfile,"r")) == NULL ) {
    if (ice->language==ENGLISH) {
      FXMessageBox err(this,"ERROR :-(",
          "imagefile for level "+clh::fxnum2str(ice->level)+" does not exist",
          NULL,MBOX_OK);
      err.execute();
    }
    if (ice->language==GERMAN) {
      FXMessageBox err(this,"FEHLER :-(",
          "das Bild fuer Level "+clh::fxnum2str(ice->level)+" ist nicht da",
          NULL,MBOX_OK);
      err.execute();
    }
    return 1;
  }
  fclose(in);

  Charly::pinopen();
  if (start->getButton()==RIGHTBUTTON) return 1;

  if (ice->exitx<1 || ice->exity<1) {
    if (ice->language==ENGLISH) {
      FXMessageBox err(this,"ERROR :-(",
          "please set exit first",
                 new FXGIFIcon(app,penguin),MBOX_OK);
      err.execute();
    }
    if (ice->language==GERMAN) {
      FXMessageBox err(this,"FEHLER :-(",
          "der Ausgang fehlt noch",
                 new FXGIFIcon(app,penguin),MBOX_OK);
      err.execute();
    }
    return 1;
  }
  if (beamcoor[0]!=0 && beamcoor[0]!=2) {
    if (ice->language==ENGLISH) {
      FXMessageBox err(this,"ERROR :-(",
          "the 2nd beamer is missing",
                 new FXGIFIcon(app,penguin),MBOX_OK);
      err.execute();
    }
    if (ice->language==GERMAN) {
      FXMessageBox err(this,"FEHLER :-(",
          "der 2. Beamer fehlt noch",
                 new FXGIFIcon(app,penguin),MBOX_OK);
      err.execute();
    }
    return 1;
  }

  int lev = ice->level-1;
  pininfo[lev].exitx = ice->exitx;
  pininfo[lev].exity = ice->exity;
  FOI(5) pininfo[lev].beamcoor[i] = beamcoor[i];

  setlevel->disable();
  edit->disable();
  start_the_game();
  return 1;
}
