/* 
 * Copyright (C) 2002 Clemens Schiff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 *
 * or get it at http://www.fsf.org
 */

#ifndef PINGO_H
#define PINGO_H

#include "charly.h"
#include "csbutton.h"
#include "pinedit.h"

struct PinInfo {
  int numpin; int spielzeit; int speed;
  char imgfile[255];
  int beamcoor[5]; int exitx; int exity;
};


class Pingo : public Charly {

private:
  FXMainWindow *mawi;
  CSButton     *start;
  FXButton     *edit;
  FXSpinner    *setlevel;
  Pinedit      *pinedit;

  vector<PinInfo> pininfo;

public:

#include "pingo.fh"

  virtual void pinopen();
  virtual void finished();
  virtual void create();  // Initialize

  Pingo(FXApp *appli,
         FXComposite *p,FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  virtual ~Pingo() {pininfo.clear(); } // Pingo  destructor

};

#endif

