/* Pingo  pinpaint.cpp
   save Pingus pictures as FOX Images

   Copyright (C) 2001 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     --------------------------------------------------------------

These pictures were made for PINGUS (pingus.seul.org)

data/images/pingus
==================

Filename:      | Author:
---------------+--------------------------------------
walker.pcx     | Joel Fauche <joel.fauche@wanadoo.fr>
faller.pcx     | Joel Fauche <joel.fauche@wanadoo.fr>
stopper.pcx    | Stefan Stiasny <sc@swi.priv.at>
bridger.pcx    | Stefan Stiasny <sc@swi.priv.at>
miner.pcx      | Stefan Stiasny <sc@swi.priv.at>
basher.pcx     | Joel Fauche <joel.fauche@wanadoo.fr>
digger.pcx     | Craig Timpany <timpany@es.co.nz>
exit.png       / ????? (sorry)
bomber.png     |  Joel Fauche <joel.fauche@wanadoo.fr>
floater.png    | Joel Fauche <joel.fauche@wanadoo.fr>

from xpenguins:
# superpenguin.xpm Rob Gietema <tycoon@planetdescent.com>,
                   Robin Hogan <R.J.Hogan@reading.ac.uk>,
                   Brian Chu <chub@stuy.yi.org>

not used for Charly:
blocker.pcx    | Stefan Stiasny <sc@swi.priv.at>
climber.pcx    | Joel Fauche <joel.fauche@wanadoo.fr>
tumble.pcx     | Craig Timpany <timpany@es.co.nz>
*/

#if LINUX
// #define DOKU 1
#endif

#include "pinglob.h"
#include "charly.h"

// the strings in xpm files must be declared const !!
#include "walker.xpm"
#include "faller.xpm"
#include "stopper.xpm"
#include "bridger.xpm"
#include "miner.xpm"
#include "digger.xpm"
#include "exit.xpm"
#include "superpenguin.xpm"
#include "bomber.xpm"
#include "basher.xpm"
#include "floater.xpm"

/*
  max. number of pictures in a xpm-file per direction
 */ 
#define NUM_WALKER   8
#define NUM_FALLER   8
#define NUM_STOPPER  6
#define NUM_BRIDGER 15
#define NUM_MINER   12
#define NUM_DIGGER  14 
#define NUM_EXIT     9
#define NUM_SUPER    8
#define NUM_BOMBER  16
#define NUM_BASHER  12
#define NUM_FLOATER  8

/*
   number of direction(s)
 */
#define DIR_WALKER  2
#define DIR_FALLER  1
#define DIR_STOPPER 1
#define DIR_BRIDGER 2
#define DIR_MINER   2
#define DIR_DIGGER  1
#define DIR_EXIT    2
#define DIR_SUPER   2
#define DIR_BOMBER  1
#define DIR_BASHER  2
#define DIR_FLOATER 1


static void get_wh(const char *xpm[], const int NUM, const int DIr7, int &fw, int &fh) {
  int ww,hh;
  sscanf(xpm[0],"%d %d",&ww,&hh);
  ww /= NUM; hh /= DIr7;
  fw=clh::maxof(ww,fw); fh=clh::maxof(hh,fh);
}

void Charly::setpin(const int ID, const int NUM, const int DIr7, int tot) {
  /*
     pin[  ][0] connects actual ID of this charly to totnum 
     pin[  ][1] is number of pictures of this charly
  */
  pin[ID-ID_WALKER  ][0]=tot-DIr7; pin[ID-ID_WALKER  ][1]=NUM;
  pin[ID-ID_WALKER+1][0]=tot-1;   pin[ID-ID_WALKER+1][1]=NUM;
}


int Charly::beamerout(int tot, const int NUM, const int DIr7) {  // reverse exit

  FOJ(DIr7) {
    face[tot] = new Face* [NUM];
    FOI(NUM) {
      int z=NUM-i-1;
      int n=0;
      int p=pin[ID_BEAMER_IN-ID_WALKER+j][0];
      while ( face[p][z][n].x > -1 ) n++;

      face[tot][i] = new Face[n+1];
      FOK(n) {
        face[tot][i][k].x = face[p][z][k].x;
        face[tot][i][k].y = face[p][z][k].y;
        face[tot][i][k].c = face[p][z][k].c;
      }
      face[tot][i][n].x = -8888;
    }
    tot++;
  }
  return tot;
}


void Charly::pinpaint() {
  int totpic=DIR_BOMBER;  // it is so because we also need BEAMER_OUT
  face_wid=face_hei=0;

  get_wh(walker, NUM_WALKER, DIR_WALKER,face_wid,face_hei);       totpic+=DIR_WALKER;   
  get_wh(faller, NUM_FALLER, DIR_FALLER,face_wid,face_hei);	  totpic+=DIR_FALLER;   
  get_wh(stopper,NUM_STOPPER,DIR_STOPPER,face_wid,face_hei);	  totpic+=DIR_STOPPER;  
  get_wh(bridger,NUM_BRIDGER,DIR_BRIDGER,face_wid,face_hei);	  totpic+=DIR_BRIDGER;  
  get_wh(miner,  NUM_MINER,  DIR_MINER,face_wid,face_hei);	  totpic+=DIR_MINER;    
  get_wh(digger, NUM_DIGGER, DIR_DIGGER,face_wid,face_hei);	  totpic+=DIR_DIGGER;   
  get_wh(EXiT,   NUM_EXIT,   DIR_EXIT,face_wid,face_hei);	  totpic+=DIR_EXIT;     
  get_wh(superpenguin_xpm,NUM_SUPER,DIR_SUPER,face_wid,face_hei); totpic+=DIR_SUPER;    
/*get_wh(bomber, NUM_BOMBER, DIR_BOMBER,face_wid,face_hei);*/     totpic+=DIR_BOMBER;    
  get_wh(basher, NUM_BASHER, DIR_BASHER,face_wid,face_hei);       totpic+=DIR_BASHER;    
  get_wh(floater,NUM_FLOATER,DIR_FLOATER,face_wid,face_hei);      totpic+=DIR_FLOATER;    

  face = new Face** [totpic];
  totpic=0;

  totpic=createpenguins(walker,           NUM_WALKER,  DIR_WALKER,  totpic);
  setpin(ID_WALKER, NUM_WALKER, DIR_WALKER, totpic);

  totpic=createpenguins(faller,           NUM_FALLER,  DIR_FALLER,  totpic);
  setpin(ID_FALLER, NUM_FALLER, DIR_FALLER, totpic);

  totpic=createpenguins(stopper,          NUM_STOPPER, DIR_STOPPER, totpic);
  setpin(ID_STOPPER, NUM_STOPPER, DIR_STOPPER, totpic);

  totpic=createpenguins(bridger,          NUM_BRIDGER, DIR_BRIDGER, totpic);
  setpin(ID_U_BRIDGER, NUM_BRIDGER, DIR_BRIDGER, totpic);
  setpin(ID_H_BRIDGER, NUM_BRIDGER, DIR_BRIDGER, totpic);
  setpin(ID_D_BRIDGER, NUM_BRIDGER, DIR_BRIDGER, totpic);

  totpic=createpenguins(miner,            NUM_MINER,   DIR_MINER,   totpic);
  setpin(ID_U_MINER, NUM_MINER, DIR_MINER, totpic);
  setpin(ID_D_MINER, NUM_MINER, DIR_MINER, totpic);

  totpic=createpenguins(basher,           NUM_BASHER,  DIR_BASHER,  totpic);
  setpin(ID_BASHER, NUM_BASHER, DIR_BASHER, totpic);

  totpic=createpenguins(digger,           NUM_DIGGER,  DIR_DIGGER,  totpic);
  setpin(ID_DIGGER, NUM_DIGGER, DIR_DIGGER, totpic);

  totpic=createpenguins(bomber,           NUM_BOMBER,  DIR_BOMBER,  totpic);
  setpin(ID_BEAMER_IN,  NUM_BOMBER, DIR_BOMBER, totpic);
  totpic=beamerout(totpic,NUM_BOMBER,DIR_BOMBER);  // ID_BEAMER_IN must exist before !
  setpin(ID_BEAMER_OUT, NUM_BOMBER, DIR_BOMBER, totpic);

  totpic=createpenguins(EXiT,             NUM_EXIT,    DIR_EXIT,    totpic);
  setpin(ID_EXIT,      NUM_EXIT, DIR_EXIT, totpic);

  totpic=createpenguins(superpenguin_xpm, NUM_SUPER,   DIR_SUPER,   totpic);
  setpin(ID_SUPER, NUM_SUPER, DIR_SUPER, totpic);

  totpic=createpenguins(floater, NUM_FLOATER,   DIR_FLOATER,   totpic);
  setpin(ID_FLOATER, NUM_FLOATER, DIR_FLOATER, totpic);

  wi2=face_wid/2; hi2=face_hei/2;
#if DOKU==1
  drawthem();
#endif
}


int Charly::createpenguins(const char *xpm[],
       const int NUM, const int DIr7, int tot) {

  int ww,hh;
  FXXPMIcon *icon;
  sscanf(xpm[0],"%d %d",&ww,&hh);
  icon = new FXXPMIcon(app,xpm,0,IMAGE_KEEP,ww,hh);
  icon->create();
  FXColor *p = icon->getData();

  int u,v,x,y;
  int w = ww/NUM;
  int h = hh/DIr7;
  FXColor *co = new FXColor[w*h];
  int *xx = new int[w*h];  int *yy = new int[w*h];

  FOJ(DIr7) {
    face[tot] = new Face* [NUM];
    FOI(NUM) {
      int n=0;
      for (y=j*h,v=0; v<h; y++,v++) {
        for (x=i*w,u=0; u<w; x++,u++) {
	  if (p[x+ww*y]!=p[0]) {
	    co[n] = p[x+ww*y];
            xx[n] = (face_wid-w)/2 + u;
            yy[n] = (face_hei-h)/2 + v;
	    n++;
      } } }

      face[tot][i] = new Face[n+1];
      FOK(n) {
        face[tot][i][k].x = xx[k];
        face[tot][i][k].y = yy[k];
        face[tot][i][k].c = co[k];
      }
      face[tot][i][n].x = -888 ;
    }
    tot++;
  }
  delete icon;
  delete [] co; delete [] xx; delete [] yy;
  return tot;
}


#define DRAW col[x+w*y]=FXRGB(200,0,0)

// draws icons for buttons (with arrows for miner and bridger)
FXIcon *Charly::painticon(const int ID, int wi, int di) {

  FXuint opti=IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP|IMAGE_ALPHACOLOR;
  int jd=pin[ID-ID_WALKER+di][0];
  int x,y,n=face_wid*face_hei;
  FXColor *col = new FXColor[n];
  FOI(n) col[i]=FXRGB(255,255,255);

  n=0;
  while ( face[jd][wi][n].x > -1 ) {
    x = face[jd][wi][n].x + face_wid*face[jd][wi][n].y;
    col[x] = face[jd][wi][n].c;
    n++;
  } 

  if (ID==ID_U_BRIDGER || ID==ID_U_MINER) {
    int j,w=face_wid; int h=face_hei;
    x=w-5; for (y=3; y<h/2; y++)   DRAW;
    y=4;   for (x=w-6; x<w-3; x++) DRAW;
    y=5;   for (x=w-7; x<w-2; x++) DRAW;
    y=6;   for (x=w-8,j=0; x<w-1; x++,j++) {if (j!=2&&j!=4) DRAW;}
    x=w-8; for (y=7;y<=8;y++)      DRAW;
    x=w-2; for (y=7;y<=8;y++)      DRAW;
  }

  if (ID==ID_D_BRIDGER || ID==ID_D_MINER) {
    int j,w=face_wid; int h=face_hei;
    x=w-5; for (y=h/2; y<h-4; y++) DRAW;
    y=h-5; for (x=w-6; x<w-3; x++) DRAW;
    y=h-6; for (x=w-7; x<w-2; x++) DRAW;
    y=h-7; for (x=w-8,j=0; x<w-1; x++,j++) {if (j!=2&&j!=4) DRAW;}
    x=w-8; for (y=h-8;y>h-10;y--)  DRAW;
    x=w-2; for (y=h-8;y>h-10;y--)  DRAW;
  }

  FXIcon *icon = new FXIcon(app,col,FXRGB(255,255,255),opti,face_wid,face_hei);
  icon->create();
  return icon;
}

#if DOKU==1
#include <FXJPGImage.h>
/*
  to use this the following line must be added to FXImage.h
  void setData(FXColor *da) { data=da; }
 */

void Charly::dokument(const int ID, const int NUM, const int DIr7) {
  FXIcon *ico;
  FXJPGImage *img;

  FOI(DIr7) {
    FOJ(NUM) {
      ico = painticon(ID,j,i);
      img = new FXJPGImage(getApp(),NULL,IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP,
          face_wid,face_hei);
      img->create();
      FXColor *p = ico->getData();

//       FXColor *q = img->getData();
//       memcpy(q,p,sizeof(FXColor)*face_wid*face_hei);
//       q=p;
      img->setData(p);

      FXFileStream stream;
      FXString file;
      file="/tmp/img_"+FXStringVal(ID)+"_"+FXStringVal(i)+"_"+FXStringVal(j)+".jpg";

      if(stream.open(file,FXStreamSave)) {
        img->savePixels(stream);
        stream.close();
      }
      delete img;
      delete ico;
  } }
}

void Charly::drawthem() {
  dokument(ID_WALKER, NUM_WALKER, DIR_WALKER);
  dokument(ID_FALLER, NUM_FALLER, DIR_FALLER);
  dokument(ID_STOPPER, NUM_STOPPER, DIR_STOPPER);
  dokument(ID_U_BRIDGER, NUM_BRIDGER, DIR_BRIDGER);
  dokument(ID_H_BRIDGER, NUM_BRIDGER, DIR_BRIDGER);
  dokument(ID_D_BRIDGER, NUM_BRIDGER, DIR_BRIDGER);
  dokument(ID_U_MINER, NUM_MINER, DIR_MINER);
  dokument(ID_D_MINER, NUM_MINER, DIR_MINER);
  dokument(ID_BASHER, NUM_BASHER, DIR_BASHER);
  dokument(ID_DIGGER, NUM_DIGGER, DIR_DIGGER);
  dokument(ID_BEAMER_IN,  NUM_BOMBER, DIR_BOMBER);
  dokument(ID_BEAMER_OUT, NUM_BOMBER, DIR_BOMBER);
  dokument(ID_EXIT,      NUM_EXIT, DIR_EXIT);
  dokument(ID_SUPER, NUM_SUPER, DIR_SUPER);
  dokument(ID_FLOATER, NUM_FLOATER, DIR_FLOATER);
}
#endif
