
/* PinPlay.cpp
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pinglob.h"
#include "charly.h"

#define SPEED_IT_UP 0 // not ok yet
#define LEFT  0
#define RIGHT 1
#define T 4
#define STAIR 15

int qua;
#if SPEED_IT_UP==1

struct Quad {int x0; int y0; int x1; int y1;};
Quad quad[MAXPEN+2];

static void QUAD(int xx0, int yy0) {

  //          why 2* ? I do not know ...
  int xx1 = xx0 + 2*face_wid;
  int yy1 = yy0 + 2*face_hei;

  FOI(qua) {
    // does a new quad touches an old one ?
    if (xx0 >=quad[i].x0 && xx0 <=quad[i].x1 &&
	yy0 >=quad[i].y0 && yy0 <=quad[i].y1) {
      quad[i].x1=clh::maxof(xx1,quad[i].x1);
      quad[i].y1=clh::maxof(yy1,quad[i].y1); return;
    }
    if (xx1 >=quad[i].x0 && xx1 <=quad[i].x1 &&
	yy0 >=quad[i].y0 && yy0 <=quad[i].y1) {
      quad[i].x0=clh::minof(xx0,quad[i].x0);
      quad[i].y1=clh::maxof(yy1,quad[i].y1); return;
    }
    if (xx0 >=quad[i].x0 && xx0 <=quad[i].x1 &&
	yy1 >=quad[i].y0 && yy1 <=quad[i].y1) {
      quad[i].x1=clh::maxof(xx1,quad[i].x1);
      quad[i].y0=clh::minof(yy0,quad[i].y0); return;
    }
    if (xx1 >=quad[i].x0 && xx1 <=quad[i].x1 &&
	yy1 >=quad[i].y0 && yy1 <=quad[i].y1) {
      quad[i].x0=clh::minof(xx0,quad[i].x0);
      quad[i].y0=clh::minof(yy0,quad[i].y0); return;
    }
  }

  quad[qua].x0=xx0;
  quad[qua].y0=yy0;
  quad[qua].x1=xx1;
  quad[qua].y1=yy1;
  qua++;
}
#endif


void Charly::turnCharlyAndWalk(int n) {
  karl[n].dir==LEFT ? karl[n].dir=RIGHT : karl[n].dir=LEFT;
  karl[n].typ=ID_WALKER;
  karl[n].pic=-1;
}

int Charly::whichbeamer(int x, int y) {
  if (x>beamcoor[1] && x<(beamcoor[1]+EXITDIM) &&
      y>beamcoor[2] && y<(beamcoor[2]+EXITDIM)) return 1;
  return 3;
}

int Charly::charlyinexit(int x, int y) {
  if (x>=ice->exitx && x<=(ice->exitx+EXITDIM) && 
      y>=ice->exity && y<=(ice->exity+EXITDIM)) return 1;
  return 0;
}

void Charly::drawstopper(int n, FXColor col) { // changes image
  int x,y,z;                         // so that BLOCKER stops other charlies
  FXColor co;

  col==back ? co=block : co=back;
  for (x=karl[n].px+T; x<=karl[n].px+face_wid-T; x++)  {
    for (y=karl[n].py+T; y<karl[n].py+face_hei; y++) {
      z = x + imgwid*y;
      if (icecopy[z]==co) icecopy[z]=col;
  } }
}

int Charly::erase(int xx, int yy, int w, int h) {
  int x,y,z,a=1,n=0;

  for (x=xx; x<xx+w; x++)  {
    if (x<0 || x==imgwid) continue;
    for (y=yy; y<yy+h; y++) {
      if (y<0 || y==imghei) continue;
      z = x + imgwid*y;
      if (!isbackcol(x,y)) n++;
      if (icecopy[z]==block)              {a=0; continue;} // we hit a stopper
      if (icecopy[z]==iron && iron!=back) {a=0; continue;} // we hit iron
      if (icecopy[z]==BEAMCOL)            {a=0; continue;} // we hit a beamer
      if (charlyinexit(x,y)) icecopy[z]=EXITCOL; else icecopy[z]=back;
  } }
  if (a) return n; // n>0 something was erased
  return -1;
}

int Charly::drawminer(int n, int xx, int yy, int f) { // erase
  int i=0;                          // picture where miner is working
  if (yy+1<imghei && isbackcol(xx,yy+1)) return 0;
  yy+=f;
  if (karl[n].dir==LEFT) {
    i=erase(xx-12 ,yy-face_hei+10  , 12 , face_hei-10);
  } else {
    i=erase(xx , yy-face_hei+10 , 12, face_hei-10 );
  }
  return i;
}

int Charly::stair(int n, int x, int y, int f) {  // draws a step of
  int i,j,x1,z,m=0;                       //  a stair for bridgers
  if (karl[n].dir==LEFT) { x1=x-STAIR;
    for (i=x1; i<x; i++) {
      for (j=y+f; j>y+f-T; j--) {
	z = i + imgwid*j;
        if (i==(x-STAIR) && !isbackcol(i,j)) m++;
        icecopy[z]=FXRGB(250,0,0);
    } }

  } else { x1=x;
    for (i=x; i<=x+STAIR; i++) {
      for (j=y+f; j>y+f-T; j--) {
	z = i + imgwid*j;
        if (i==(x+STAIR) && !isbackcol(i,j)) m++;
        icecopy[z]=FXRGB(0,0,250);
    } }
  }
  // ToDo: step should be extended to border or obstacle
  if (m > T-2) return 1;
  return 0;
}



/*
 ******************  HERE IT STARTS  **********************
 */
long Charly::onPlayTime(FXObject*,FXSelector,void*) {
  int i,j,f=0,w, x,y;
  qua=0;

  // let them enter the game (one every 2 seconds)
  if (numpin - ice->running) {
    int ssec = int(time(NULL)-startzeit);
    if (ssec > 2*ice->running) {
      karl[ice->running].saved = 0;
      karl[ice->running].dir   = RIGHT;
      karl[ice->running].typ   = ID_FALLER;
      karl[ice->running].px    = 10;
      karl[ice->running].py    = 10;
      karl[ice->running].pic   = 0;
      karl[ice->running].nt    = 0;
      karl[ice->running].first = 0;
      ice->running++;
  } }
  ice->checkforcharly();

// see, if a charly was clicked (and only change one)
  w=i=j=0;
  for (int num=0; num<ice->running; num++) {
    if (karl[num].nt==0) continue;
    j++;
    if (karl[num].typ==karl[num].nt) continue; 
    if (karl[num].typ==ID_BEAMER_IN)   continue; // cannot be changed
    if (karl[num].typ==ID_BEAMER_OUT)  continue; 
    if (karl[num].typ==ID_EXIT)        continue; 
    if (karl[num].typ==ID_SUPER)       continue; 
    if (karl[num].typ==ID_FALLER)      continue; 
    if (karl[num].typ==ID_FLOATER)     continue; 

    if (++i==1) { // ok, we have one
      w=num;
    } else {    // ok, we have more than one, now set the priority
      if (karl[w  ].typ==ID_DIGGER)  continue; // high
      if (karl[num].typ==ID_DIGGER) {w=num; continue;}
      if (karl[w  ].typ==ID_D_MINER)  continue;
      if (karl[num].typ==ID_D_MINER) {w=num; continue;}
      if (karl[w  ].typ==ID_U_MINER)  continue; // medium
      if (karl[num].typ==ID_U_MINER) {w=num; continue;}
      if (karl[w  ].typ==ID_BASHER)   continue;
      if (karl[num].typ==ID_BASHER)  {w=num; continue;}
      if (karl[w  ].typ==ID_U_BRIDGER)  continue; // lower
      if (karl[num].typ==ID_U_BRIDGER) {w=num; continue;}
      if (karl[w  ].typ==ID_D_BRIDGER)  continue;
      if (karl[num].typ==ID_D_BRIDGER) {w=num; continue;}
      if (karl[w  ].typ==ID_H_BRIDGER)  continue;
      if (karl[num].typ==ID_H_BRIDGER) {w=num; continue;}
      if (karl[w  ].typ==ID_STOPPER)  continue;
      if (karl[num].typ==ID_STOPPER) {w=num; continue;}
    }
  }
  if (i>0) {  // do the type switch
    if (karl[w].typ==ID_STOPPER) drawstopper(w,back);
    if (karl[w].typ==ID_DIGGER)  karl[w].py--;

    switch(karl[w].nt) {
      case ID_D_MINER:
      case ID_U_MINER:
      case ID_BASHER : karl[w].pic = 5; break;
      case ID_STOPPER: drawstopper(w,block); /* fallthru */
      default:         karl[w].pic = 0; break;
    }
    karl[w].first=-1;
    karl[w].typ  = karl[w].nt;
  }
  if (j) FOM(ice->running) karl[m].nt=0;

  ///---------------------------------------------------------------

  for (int num=0; num<ice->running; num++) {
    if (karl[num].saved) continue;

/*   xfr  xce  xba         <-- walking direction (xba not used)
     xba  xce  xfr         --> walking direction
 yto  *----*----*
      |         |
      |         |
 yce  *         *
      |         |
      |         |
 ybo  *----*----*

*/
    int dir=1;
    if (karl[num].dir==LEFT) dir=-1;
    int xce, xxce, yce, xfr, yto, ybo, yybo;
    xce = xxce = karl[num].px + wi2;
    yce        = karl[num].py + hi2;
    xfr        = karl[num].px;
    //  int xba = karl[num].px + face_wid;
    //  if (karl[num].dir==RIGHT) {x=xfr; xfr=xba; xba=x;} 
    if (karl[num].dir==RIGHT) xfr=karl[num].px + face_wid;
    yto        = karl[num].py + 2;
    ybo = yybo = karl[num].py + face_hei-2;

#if SPEED_IT_UP==1
    // store old position
    QUAD(karl[num].px,karl[num].py);
#endif

    // did charly reached the exit ?
    if (karl[num].px>ice->exitx && karl[num].px+face_wid<ice->exitx+EXITDIM) {
      if (karl[num].py>ice->exity && karl[num].py+face_hei<ice->exity+EXITDIM) {
        if (karl[num].typ!=ID_EXIT) {  // yes
          karl[num].typ=ID_EXIT;
          karl[num].pic=0; 
        } else {
          if (piccount(ID_EXIT,num)==0) {
    	    karl[num].saved=1; 
    	    saved_pen++;
          }
        }
    } }

    // did we enter a beamer ?
    if (icecopy[xce+imgwid*yce]==BEAMCOL) {
      if (karl[num].typ==ID_BEAMER_OUT) {
        if (piccount(ID_BEAMER_OUT,num)==0) { // through
          karl[num].typ=ID_WALKER;
          karl[num].pic=0;
          karl[num].px+=((EXITDIM-3)*dir/2);
        }
      } else if (karl[num].typ==ID_BEAMER_IN)  {
        if (piccount(ID_BEAMER_IN,num)==0) {  // resurface on other beamer
          karl[num].typ=ID_BEAMER_OUT;
          karl[num].pic=0;
          whichbeamer(xce,yce)==1 ? i=3 : i=1;
          karl[num].px=beamcoor[ i ]+(EXITDIM-1)/2-wi2;
          karl[num].py=beamcoor[i+1]+(EXITDIM-1)/2-hi2;
        }
      } else {  // enter the beamer
        f = whichbeamer(xce,yce);
        karl[num].typ=ID_BEAMER_IN;
        karl[num].pic=0;
        karl[num].px=beamcoor[ f ]+(EXITDIM-1)/2-wi2;
        karl[num].py=beamcoor[f+1]+(EXITDIM-1)/2-hi2;
      }
    }

    ///--------------------------------------------------------------------
#define NULLPIC(ID)  karl[num].typ=ID; karl[num].pic=-1
#define XDIR(nn) karl[num].px+=nn; xfr+=nn; xce+=nn
#define YDIR(nn) karl[num].py+=nn; yto+=nn; yce+=nn; ybo+=nn

    int special=1;

    switch (karl[num].typ) {

    default: special=0; break;

    case ID_WALKER:
      f=-3*T;
      x=karl[num].px;
      y=karl[num].py;
      for (i=0; i<T; i++) {
	XDIR(dir); w=0;
	if (xfr<T || xfr>imgwid-T) break; // do not leave image in x
	YDIR(f); f=0;
        for (j=0; j<6*T; j++) {
	  YDIR(1); f--;
          if (yto<T)     continue;  // too high ?
          if (ybo>imghei-1) break;  // on bottom
          if (isbackcol(xce,ybo)) { // there is a position to move to
            yybo=ybo; xxce=xce; w=1;
	    y=karl[num].py;
	    x=karl[num].px;
          } else {
            if (w || yybo==ybo) break;
          }
        }
	if (w==0) break; // do not penetrate thin vertical lines
      }
      karl[num].px=x;
      karl[num].py=y;

      if (isbackcol(xxce,yybo+1)) {
        NULLPIC(ID_FALLER); // no ground under the feet
      } else {
        if (w==0) turnCharlyAndWalk(num); // there is a wall
      }
      break;

    case ID_FALLER:
      for (j=0;j<T;j++) {
        karl[num].py++; ybo++;
        if (!isbackcol(xce,ybo) || ybo==imghei) { // we hit ground
          NULLPIC(ID_WALKER);
          karl[num].py--;
	  break;
      } }
      break;

    case ID_SUPER:
      for (i=0; i<T; i++) {
        XDIR(dir);
        karl[num].py--; yto--;
        if ( !isbackcol(xce,yto) ||    // something is in the way
             yto<T ||                  // too high
             xfr<T || xfr>imgwid-T) {  // outside image border
          NULLPIC(ID_FALLER);
	  break;
        }
      }
      break;

    case ID_FLOATER:
      if (karl[num].first == -1)  karl[num].first = -yto;
      if (karl[num].first < 0) {  // move up/down
        for (i=0; i<T; i++) {
          karl[num].py--; yto--;
          if ( !isbackcol(xce,yto) ||    // something is in the way
               yto<T ) {                 // too high
            NULLPIC(ID_FALLER);
	    break;
	} }
        if (-karl[num].first-yto > 3*face_hei) karl[num].first = xce; 
      } else {    // move left/right
        karl[num].px+=T*dir; xce+=T*dir;
        if ( !isbackcol(xce,yto) ||    // something is in the way
	 //  !isbackcol(xce,yce) ||    // something is in the way
             !isbackcol(xce,ybo) ||    // something is in the way
             xfr<T || xfr>imgwid-T ||  // outside image border
             ABS(karl[num].first-xce) > 2*face_wid) { // finished
               NULLPIC(ID_FALLER);
	       break;
	}
      }
      break;

    case ID_STOPPER:
      if (isbackcol(xce,ybo)) { // no ground under the feet
        drawstopper(num,back);
        NULLPIC(ID_FALLER); 
      }
      break;

    case ID_DIGGER:
      i = erase(karl[num].px+2,ybo-2,face_wid-4,T+1);
      switch(i) {
        default: YDIR(T/2);              break; // go on digging
        case  0: NULLPIC(ID_FALLER);     break; // we are through
        case -1: turnCharlyAndWalk(num); break; // we hit stopper, iron, ...
      }

      if (ybo>=imghei) {  // too low ?
	i = ybo-imghei; karl[num].py-=i;
	NULLPIC(ID_WALKER);
      }
      break;

    case ID_D_MINER:
    case ID_U_MINER:
    case ID_BASHER:
      XDIR(dir);  // move one pixel in x
      if ( xfr<T || xfr>imgwid-T ) { // outside image border
        turnCharlyAndWalk(num);
	break;
      }
      if (karl[num].pic==5) {
        f = T;
        if (karl[num].typ==ID_U_MINER) f = -T;
        if (karl[num].typ==ID_BASHER)  f =  0;
	i = drawminer(num,xce,ybo,f);
        switch(i) {
	  default: break;                  // go on mining (see below)
          case  0: NULLPIC(ID_FALLER);     break; // we are through
          case -1: turnCharlyAndWalk(num); break; // we hit stopper, iron, ...
        }
	break;
      }
      if (karl[num].pic==6)  {  // move up/downwards
	switch(karl[num].typ) {
	default: break;
	case ID_D_MINER:
 	  YDIR(T);
          if (ybo>=imghei) {  
  	    i = ybo-imghei; karl[num].py-=i;
	    turnCharlyAndWalk(num);
          }
	break;
        case ID_U_MINER:
 	  YDIR(-T);
          if (yto<T) turnCharlyAndWalk(num);
	  break;
	}
      }
      break;

    case ID_D_BRIDGER:
    case ID_U_BRIDGER:
    case ID_H_BRIDGER:
      f=0;
      if (karl[num].typ==ID_U_BRIDGER) f=-T;
      if (karl[num].typ==ID_D_BRIDGER) f= T;

      if (karl[num].first < 0) {
        karl[num].first=0;
        x=xce+5*dir;
        for ( i=ybo-T; i<imghei; i++) {
	  if (isbackcol(x,i+f)) {karl[num].py++; ybo++;} else break;
        }
	// move up a bit if we are on a plane
	if (!isbackcol(xce+STAIR,ybo)) karl[num].py-=T;
      }

      if (karl[num].pic==7 && karl[num].typ!=ID_H_BRIDGER) {
        YDIR(f);
        if (karl[num].typ==ID_U_BRIDGER) {
          if (yto<2*T) {  // too high
            karl[num].py-=T; // seems necessary
            turnCharlyAndWalk(num); // NULLPIC(ID_WALKER);
            break;
          }
	  if (!isbackcol(xce,yto)) {turnCharlyAndWalk(num); break;}
        }
        if (karl[num].typ==ID_D_BRIDGER) {
          if (ybo>imghei-1) {  // on bottom
	    i = ybo-imghei; karl[num].py-=i;
            NULLPIC(ID_WALKER);
            break;
      } } }

      if (karl[num].pic==8) {
        if (stair(num,xce,ybo-f,f)) {
          turnCharlyAndWalk(num);
	  break;
      } }

      if (karl[num].pic%3) {
        XDIR(dir);
	if (xfr<T || xfr>imgwid-T) { // do not leave image in x
          turnCharlyAndWalk(num);
          break;
      } }
      break;

    } // end of switch(typ)

    if (special) piccount(karl[num].typ,num);

#if SPEED_IT_UP==1
    // store new position
    QUAD(karl[num].px,karl[num].py);
#endif

  }  // end of for (int num=0; num<ice->running; num++)

  ///------------------------------------------

  FXColor *p = ice->getImage()->getData();
  memcpy(p,icecopy,sizeof(FXColor)*icen);  //  FOI(icen) p[i]=icecopy[i]; 

  ///------------------------------------------

  for (int num=0; num<ice->running; num++) {
    if (karl[num].saved) continue;
    int ID=pin[karl[num].typ-ID_WALKER+karl[num].dir][0];
    int wi=karl[num].pic;

    int n=0;
    while ( face[ID][wi][n].x > -1 ) {
      x = karl[num].px + face[ID][wi][n].x;
      y = karl[num].py + face[ID][wi][n].y;
      if (y<imghei) p[x+imgwid*y] = face[ID][wi][n].c;
      n++;
    } 
  }
  ice->getImage()->render();

  ///----------------------------------------------------------------

#if SPEED_IT_UP==1

//   FOI(ice->running) {
//     if (charly[i].saved) continue;
//     ice->update(charly[i].px,charly[i].py,3*face_wid,3*face_hei);
//   }
  FOI(qua) {
    x = quad[i].x1 - quad[i].x0 + 1;
    y = quad[i].y1 - quad[i].y0 + 1;

//  ZWErg(i);ZWErg(quad[i].x0);ZWErg(quad[i].x1);
//  ZWErg(quad[i].y0);ZWErg(quad[i].y1); // ZWErg(x);ZWERG(y);
//  ZWErg(charly[i].px);    ZWErg(charly[i].py); ZWErg(face_wid); ZWERG(face_hei);

    ice->update(quad[i].x0, quad[i].y0, x,y);
  }
#else
  ice->update();  // I think this one is too slow
#endif

   //  game is running
  if (!totalstop) app->addTimeout(this,ID_PLAYTIME,(50+speed)*TIMEOUTFAK);
    else          lost_pen = numpin - saved_pen;
  return 1;
}
