/*
   Copyright (C) 2002 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pinglob.h"
#include "pinscroll.h"


FXDEFMAP(Pinscroll) PinscrollMap[]={
  //____Message_Type______________ID_______________Message_Handler___
  FXMAPFUNC(SEL_PAINT,              0,  Pinscroll::centerimage),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,    0,  Pinscroll::onLMousePress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,  0,  Pinscroll::onLMouseRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,   0,  Pinscroll::onRMousePress),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE, 0,  Pinscroll::onRMouseRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,  0,  Pinscroll::onMMousePress),
  FXMAPFUNC(SEL_MOTION,             0,  Pinscroll::onMouseMove),
};
FXIMPLEMENT(Pinscroll,FXImageView,PinscrollMap,ARRAYNUMBER(PinscrollMap))

template <class T> inline void BETWEEN(const T min1, T &num, const T max1) {
  if (num<min1) num=min1;
  if (num>max1) num=max1;
}

Pinscroll::Pinscroll(FXComposite *p,FXImage *img,FXObject *tgt,
      FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h) :
     FXImageView(p,img,tgt,sel,opts,x,y,w,h) {

  image = img;
  xoff=yoff=buttonpressed=0;
  language=GERMAN;
  exitx=exity=0;
  gameover=1;
  level=1;

  int n=EXITDIM*EXITDIM;
       oldpic1 = new FXColor[n];
       oldpic2 = new FXColor[n];
  FXColor *pix = new FXColor[n];
  for (int i=0;i<n;i++) pix[i]=FXRGB(240,240,240);
  FXIcon *ic = new FXIcon(getApp(),pix,0,
         IMAGE_OWNED|IMAGE_OPAQUE|IMAGE_KEEP,EXITDIM,EXITDIM);
  ic->create();

  beamer = new FXLabel(this,"",ic,FRAME_NONE|LAYOUT_EXPLICIT,0,0,EXITDIM,EXITDIM);
  beamer->setDefaultCursor(getApp()->getDefaultCursor(DEF_DNDSTOP_CURSOR));
  beamer->hide();
}


void Pinscroll::windowpos(int &x, int &y) { // position rel. to image
  x = xxx - xoff-pos_x;
  y = yyy - yoff-pos_y;
}


void Pinscroll::windowpos(void) {  // position rel. to imageviewer
  int xx,yy,n=1+xoff; FXuint button;
  if (buttonpressed==1) n=70+xoff; // no exit below entry !!
  int wid=image->getWidth()  - EXITDIM + xoff;
  int hei=image->getHeight() - EXITDIM + yoff;
  getCursorPosition(xx,yy,button);
  xxx=xx-EXITDIM; BETWEEN( n,     xxx, wid);
  yyy=yy-EXITDIM; BETWEEN(yoff+1, yyy, hei);
  beamer->move(xxx,yyy);
}


void Pinscroll::checkforcharly(int cur_b) {
  if (gameover) return;

  FXuint buttons;
  int cur_x, cur_y;  // cursor position in image
  getCursorPosition(cur_x, cur_y, buttons);
  cur_x = cur_x - xoff-pos_x; // position rel. to image
  cur_y = cur_y - yoff-pos_y;
  // image->setPixel(cur_x,cur_y,FXRGB(0,0,0));image->render();update();

  int io=0;
  FOI(running) {
    if (karl[i].saved) continue;
    if (cur_x > karl[i].px && cur_x < karl[i].px+face_wid) {
      if (cur_y > karl[i].py && cur_y < karl[i].py+face_hei) {
        io=1;
	if (cur_b==LEFTBUTTON)   karl[i].nt=pressed;
	if (cur_b==MIDDLEBUTTON) karl[i].nt=id_middle;
	if (cur_b==RIGHTBUTTON)  karl[i].nt=id_right;
    } }
  }

  if (io) setDefaultCursor(getApp()->getDefaultCursor(DEF_CROSSHAIR_CURSOR));
    else  setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
}

long Pinscroll::onMouseMove(FXObject*,FXSelector,void*) {
  if (buttonpressed) windowpos();
  return 1;
}


long Pinscroll::onLMousePress(FXObject*,FXSelector,void*) {
 if (gameover && level) {
    buttonpressed=1;
    paintexit(0);  // remove old exit
    painticon();
    beamer->show();
    windowpos(); 
  } else {
    checkforcharly(LEFTBUTTON);  // defined in fx.h
  }
  return 1;
}


long Pinscroll::onLMouseRelease(FXObject*,FXSelector,void*) {
  if (buttonpressed==1) {
//  setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
    windowpos(exitx,exity);
    beamer->hide();
    paintexit();     // draw
    buttonpressed=0;   
  }   
  return 1;
}

long Pinscroll::onMMousePress(FXObject*,FXSelector,void*) {
  checkforcharly(MIDDLEBUTTON);  // defined in fx.h
  return 1;
}


long Pinscroll::onRMousePress(FXObject*,FXSelector,void*) {
  if (gameover && level) {
    if (beamcoor[0]<2) {
      buttonpressed=3;
      painticon();
      beamer->show();
      windowpos();
    } else {
      int i,j,m=0;
      for (i=beamcoor[1]; i<beamcoor[1]+EXITDIM; i++) {
        for (j=beamcoor[2]; j<beamcoor[2]+EXITDIM; j++) {
          image->setPixel(i,j,oldpic1[m++]);
      } } m=0;
      for (i=beamcoor[3]; i<beamcoor[3]+EXITDIM; i++) {
        for (j=beamcoor[4]; j<beamcoor[4]+EXITDIM; j++) {
          image->setPixel(i,j,oldpic2[m++]);
      } }
      for (i=0; i<5; i++) beamcoor[i]=0;
      image->render(); update();
    }
  } else {
    checkforcharly(RIGHTBUTTON);  // defined in fx.h
  }
  return 1;
}

long Pinscroll::onRMouseRelease(FXObject*,FXSelector,void*) {
  if (buttonpressed==3) {
    beamcoor[0]++;
    if (beamcoor[0]==1) {
      windowpos(beamcoor[1],beamcoor[2]);
      paintbeamer(1);
    } else if (beamcoor[0]==2) {
      windowpos(beamcoor[3],beamcoor[4]);
      paintbeamer(2);
    }
    beamer->hide();
    buttonpressed=0;
  }
  return 1;
}


void Pinscroll::paintexit(int dowhat) {
  int i,j;

  if (image!=NULL) {
    int wid=image->getWidth();
    int hei=image->getHeight();
    FXColor back = image->getPixel(0,0);

    if (dowhat==0) {
      for (i=0; i<wid; i++) {  // remove old exit
        for (j=0; j<hei; j++) {
          if (image->getPixel(i,j)==EXITCOL) {
             image->setPixel(i,j,back);
          }
      } }
    }
    if (dowhat==1) {
      for (i=exitx; i<(exitx+EXITDIM); i++) {  // draw new exit
        for (j=exity; j<(exity+EXITDIM); j++) {
          if (image->getPixel(i,j)==back) {
             image->setPixel(i,j,EXITCOL);
          }
      } }
    }
    image->render(); update();
  }
}

#define N 9
void Pinscroll::painticon() {
  int i,k,m, n=EXITDIM*EXITDIM;
  FXColor *pix = beamer->getIcon()->getData();

  if (buttonpressed==1) {
    for (i=0;i<n;i++) pix[i]=EXITCOL;
  }
  if (buttonpressed==3) {
    FXColor back = image->getPixel(0,0);
    for (m=0; m<N; m++) {
      for (k=0; k<EXITDIM; k++) { n=(k+m*EXITDIM);
        if (k<m || k>EXITDIM-m-1) {
          pix[n]=back;
      } else {
          pix[n]=FXRGB(1,1,1);
    } } }
    for (m=N; m<EXITDIM-N; m++) {
      for (k=0; k<EXITDIM; k++) { n=(k+m*EXITDIM);
        if (k<N || k>EXITDIM-N-1) {
          pix[n]=back;
	} else {
          pix[n]=BEAMCOL;
    } } }
    for (m=EXITDIM-1,i=0; i<N; m--,i++) {
      for (k=0; k<EXITDIM; k++) { n=(k+m*EXITDIM);
        if (k<i || k>EXITDIM-i-1) {
          pix[n]=back;
      } else {
          pix[n]=FXRGB(1,1,1);
    } } }
  }
  beamer->getIcon()->render();
#ifdef WIN32
  beamer->update();
#endif
}


static int control(int x, int y, int i, int j) {
  if (x==i && y==j) return 1;
  if (x         > i && x         < i+EXITDIM && y         > j && y         < j+EXITDIM) return 1;
  if (x+EXITDIM > i && x+EXITDIM < i+EXITDIM && y         > j && y         < j+EXITDIM) return 1;
  if (x         > i && x         < i+EXITDIM && y+EXITDIM > j && y+EXITDIM < j+EXITDIM) return 1;
  if (x+EXITDIM > i && x+EXITDIM < i+EXITDIM && y+EXITDIM > j && y+EXITDIM < j+EXITDIM) return 1;
  return 0;
}

void Pinscroll::paintbeamer(int wh) {
  int i,j,k,n,m, ir=0,ig=2,ib=1, br,bg,bb, ierr;
  if (image!=NULL) {
    if (wh==2) wh=3;
    FXColor *pix = image->getData();
    int wid = image->getWidth();
    FXColor iron = image->getPixel(wid-1,0);
    FXColor back = image->getPixel(0,0);
    br = FXREDVAL(back);
    bg = FXGREENVAL(back);
    bb = FXBLUEVAL(back);
/*
 *  check
 */
    ierr = control(beamcoor[wh],beamcoor[wh+1] , exitx,exity);
    if (!ierr && wh==3) { // 2nd beamer must not be on 1st
      ierr = control(beamcoor[wh],beamcoor[wh+1] , beamcoor[1],beamcoor[2]);
    }
    if (ierr) {
      if (language==ENGLISH) {
        FXMessageBox err(this,"ERROR :-(",
          "beamers must not be over exit\nor other beamer",NULL,MBOX_OK);
        err.execute();
      }
      if (language==GERMAN) {
        FXMessageBox err(this,"FEHLER :-(",
          "Beamer duerfen nicht ueber dem Ausgang\noder dem anderen Beamer stehen",NULL,MBOX_OK);
        err.execute();
      }
      beamcoor[0]--; return;
    }
/*
 *  ok, passed
 */
    if (iron==back) { // no iron color 
      n=(wid-1);
      pix[n]=FXRGB(ir,ig,ib);
    } else {
      ir = FXREDVAL(iron);
      ig = FXGREENVAL(iron);
      ib = FXBLUEVAL(iron);
    }

// save picture below beamer
    m=0;
    for (i=beamcoor[wh]; i<beamcoor[wh]+EXITDIM; i++) {
      for (j=beamcoor[wh+1]; j<beamcoor[wh+1]+EXITDIM; j++) { n=(i+j*wid);
        if (wh==1) {
          oldpic1[m++]=pix[n];
	} else {
          oldpic2[m++]=pix[n];
    } } }

// paint new beamer
    for (j=beamcoor[wh+1],m=0; m<N; j++,m++) {
      for (i=beamcoor[wh],k=0;i<beamcoor[wh]+EXITDIM;i++,k++) { n=(i+j*wid);
        if (k<m || k>EXITDIM-m-1) {
          pix[n]=FXRGB(br,bg,bb);
      } else {
          pix[n]=FXRGB(ir,ig,ib);
    } } }
    for (j=beamcoor[wh+1]+N,m=0; m<EXITDIM-2*N; j++,m++) {
      for (i=beamcoor[wh],k=0;i<beamcoor[wh]+EXITDIM;i++,k++) { n=(i+j*wid);
        if (k<N || k>EXITDIM-N-1) {
          pix[n]=FXRGB(br,bg,bb);
	} else {
          pix[n]=BEAMCOL;
    } } }
    for (j=beamcoor[wh+1]+EXITDIM-1,m=0; m<N; j--,m++) {
      for (i=beamcoor[wh],k=0;i<beamcoor[wh]+EXITDIM;i++,k++) { n=(i+j*wid);
        if (k<m || k>EXITDIM-m-1) {
          pix[n]=FXRGB(br,bg,bb);
      } else {
          pix[n]=FXRGB(ir,ig,ib);
    } } }
    image->render(); update();
  }
}


//   FXint           viewport_w;
//   FXint           viewport_h;
//   FXint           content_w;
//   FXint           content_h;
//   FXint           pos_x;
//   FXint           pos_y;


// Draw visible part of image
long Pinscroll::centerimage(FXObject *obj, FXSelector sel, void* ptr){

  if (image) {
    FXEvent* event=(FXEvent*)ptr;
    FXDCWindow dc(this,event);
#if FOX_VERSION_NUMBER==16
#else
    int viewport_w = getVisibleWidth();
    int viewport_h = getVisibleHeight();
#endif
    int wid = image->getWidth();
    int hei = image->getHeight();
    if (wid<viewport_w) xoff=(viewport_w-wid)/2; else xoff=0;
    if (hei<viewport_h) yoff=(viewport_h-hei)/2; else yoff=0;
    if (xoff>0 && yoff>0) {
      dc.setForeground(backColor);
      dc.fillRectangle(0,        0, xoff,                  viewport_h);
      dc.fillRectangle(xoff+wid, 0, viewport_w-(xoff+wid), viewport_h);
      dc.fillRectangle(0, 0,         viewport_w, yoff);
      dc.fillRectangle(0, yoff+hei , viewport_w, viewport_h-(yoff+hei));
      dc.drawImage(image,xoff,yoff);
    } else if (xoff>0) {
      dc.setForeground(backColor);
      dc.fillRectangle(0,        0, xoff,                  viewport_h);
      dc.fillRectangle(xoff+wid, 0, viewport_w-(xoff+wid), viewport_h);
      dc.drawImage(image,xoff,pos_y);
    } else if (yoff>0) {
      dc.setForeground(backColor);
      dc.fillRectangle(0, 0,         viewport_w, yoff);
      dc.fillRectangle(0, yoff+hei , viewport_w, viewport_h-(yoff+hei));
      dc.drawImage(image,pos_x,yoff);
    } else {
      dc.drawImage(image,pos_x,pos_y);
    }
  } else {
    FXImageView::onPaint(obj,sel,ptr);
  }
  return 1;
}

