/* 
 * Copyright (C) 2002 Clemens Schiff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 *
 * or get it at http://www.fsf.org
 */

#ifndef PINSCROLL_H
#define PINSCROLL_H

struct Karl {
  int saved; int dir; int typ; int px; int py; int pic; int nt;
  int first;
};


class Pinscroll : public FXImageView {
  FXDECLARE(Pinscroll)

protected:
  Pinscroll() { }

private:
  FXint xoff, yoff, xxx, yyy, buttonpressed;
  FXLabel *beamer;
  FXColor *oldpic1, *oldpic2;
  FXImage *image;         // Image to view

  Karl *karl;  // same as in Charly (used to be global)
  int  *beamcoor, id_middle, id_right;
  int face_wid, face_hei;  // width and height of an animated charly

public:   // still better than global
  // nevertheless, most of the variables should be in charly.h 
  int language,
    exitx, exity, // position of exit
    running,      // number of penguins in game
    gameover,     // misleading name (used only to see if an image is loaded)
                  // means, an image is loaded and the game is not started yet
    pressed,      // ID of type of charly when clicked with left mouse
    level;        // choosen level 1<=level<=maxlevel

public:
  /// Construct a scroll window
  Pinscroll(FXComposite *p,FXImage *img=NULL, FXObject *tgt=NULL,
	    FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  ~Pinscroll() {
    delete [] oldpic1; delete [] oldpic2;
  }

  void setFormerGlobals(Karl *ka, int *beco,
		        const int id_middle1, const int id_right1,
			const int face_wid1, const int face_hei1) {
    karl     = ka;
    beamcoor = beco;
    id_middle  = id_middle1;
    id_right   = id_right1;
    face_wid   = face_wid1;
    face_hei   = face_hei1; 
  }

  // cut and paste from FXImageView ....
  FXImage *getImage() const { return image; }  /// Return image
  void setImage(FXImage *img) {// Change image
    image=img;
    recalc();
    update();
  }
  FXint getContentWidth(){// Determine content width of scroll area
    return image ? image->getWidth() : 1;
  }
  FXint getContentHeight(){// Determine content height of scroll area
    return image ? image->getHeight() : 1;
  }

  void windowpos(int &x, int &y);
  void windowpos(void);
  void checkforcharly(int cur_b=-88);

  long onLMousePress(FXObject*,FXSelector,void*);
  long onLMouseRelease(FXObject*,FXSelector,void*);
  long onMMousePress(FXObject*,FXSelector,void*);
  long onRMousePress(FXObject*,FXSelector,void*);
  long onRMouseRelease(FXObject*,FXSelector,void*);
  long onMouseMove(FXObject*,FXSelector,void*);
  long centerimage(FXObject*,FXSelector,void*);
  void getOffset(FXint &x, FXint &y) {x=xoff; y=yoff;}
  void paintexit(int dowhat=1);
  void paintbeamer(int wh);
  void painticon(void);

  enum {
    ID_PINSCROLL=FXImageView::ID_LAST,
    ID_LAST
  };

};
#endif
