/* cardface.cc
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <fx.h>

#define CARDFACE_CC 1
#include "cardface.h"
static bool already = false;

// create the cards from the old spider bitmaps
void cardface(FXApp *app) {
  if (already) return;
  already = true;

  int n,color;
  FXColor pix[CARD_HEIGHT*CARD_WIDTH];
  char bit[CARD_WIDTH][CARD_HEIGHT];

  for (int i=0; i<C_NU; i++) {
    bima2pix(bit,i);
    /* add color and convert bitmap to pixmap */
    n=0;
    if (i <= C_SK) color=1; else color=200;
    for (int j=0; j<CARD_HEIGHT; j++) {
      for (int k=0; k<CARD_WIDTH; k++) {
        if (bit[k][j]) {
          if (bit[k][j]==1) pix[n++]=FXRGB(color,0,0); else pix[n++]=FXRGB(1,0,0);
        } else {
	  pix[n++]=FXRGB(254,254,254);
    } } }
    face[i] = new FXIcon(app,pix,0,IMAGE_DITHER,CARD_WIDTH,CARD_HEIGHT);
    face[i]->create();
  }
}

FXString cardname(int suit, int rank) {
  FXString ss;
  switch(rank) {
  default: ss="Ace"; break;
  case  2: ss="2"; break;
  case  3: ss="3"; break;
  case  4: ss="4"; break;
  case  5: ss="5"; break;
  case  6: ss="6"; break;
  case  7: ss="7"; break;
  case  8: ss="8"; break;
  case  9: ss="9"; break;
  case 10: ss="10"; break;
  case 11: ss="Jack";  break;
  case 12: ss="Queen"; break;
  case 13: ss="King";  break;
  }
  ss += " of ";
  switch(suit) {
    case CLUB:    ss+="Club"; break;
    case SPADE:   ss+="Spade"; break;
    case DIAMOND: ss+="Diamond"; break;
    default:      ss+="Heart"; break;
  }
  return ss;
}

/*
 *  Card drawing routines, C.Schiff, 2001
 *  The bitmaps face.bm, rank.bm and suit.bm are taken from hearts resp. spider
 */

#define char unsigned char

#include "face.bm"  /* from 1992 !!! */
#include "suit.bm"
#include "rank.bm"  /* needed modification */

#undef char

/*  ----- taken from gfx.h ------- */
#define	FACECARD_WIDTH	47
#define	FACECARD_HEIGHT	92
#define	RANK_LOC_X	4
#define	RANK_LOC_Y	7
#define	SMALL_LOC_X	4
#define	SMALL_LOC_Y	(rank_height + RANK_LOC_Y + 3)
#define	CARD_COL1_X	(3 * CARD_WIDTH/10)
#define	CARD_COL2_X	(CARD_WIDTH/2)
#define	CARD_COL3_X	(7 * CARD_WIDTH/10)
/* 5 diff rows for the two main columns */
/* 1 and 5 are top and bottom, 3 is the middle */
/* 2 & 4 are for the 10 & 9 */
#define	CARD_ROW1_Y	(CARD_HEIGHT/5)
#define	CARD_ROW2_Y	(2 * CARD_HEIGHT/5)
#define	CARD_ROW3_Y	(CARD_HEIGHT/2)
#define	CARD_ROW4_Y	(CARD_HEIGHT - 2 * CARD_HEIGHT/5)
#define	CARD_ROW5_Y	(CARD_HEIGHT - CARD_HEIGHT/5)
/* between 1 & 3, 3 & 5 */
#define	CARD_SEVEN_Y	(7 * CARD_HEIGHT/20)
#define	CARD_EIGHT_Y	(CARD_HEIGHT - 7 * CARD_HEIGHT/20)
/* between rows 1 & 2, 4 & 5 */
#define	CARD_TEN_Y1	(3 * CARD_HEIGHT/10)
#define	CARD_TEN_Y2	(CARD_HEIGHT - 3 * CARD_HEIGHT/10)
/*  ----- end of gfx.h ------- */

static void byte2bit(int byte, int bit[]) {
  int j,k,n;
  if (byte<0) byte+=256;
  for (k=8; k>0; k--) {
    n=1; for (j=1; j<k; j++) n*=2;
    if (byte>=n) {bit[k-1]=1; byte-=n;} else {bit[k-1]=0;}
  }
}

/* draw the rank */
static void getrank(int rank, char sbit[FACECARD_WIDTH][FACECARD_HEIGHT]) {
  int i,k,w=0,h=0,bit[8];

  for (i=0;i<28;i++) {
    byte2bit( (int)rank_bits[rank][i] ,bit);
    for (k=0; k<8; k++) {
      sbit[w][h]=bit[k];
      if (++w==rank_width) {h++; w=0; break;}
    }
  }
  /*  for (h=0; h<rank_height; h++) {printf("\n");
      for (w=0; w<rank_width; w++) { printf("%d",sbit[w][h]);}}*/
}

/* draw the small/large colors */
static void getcolor(int io, int color, int wid, int hei,
            char sbit[FACECARD_WIDTH][FACECARD_HEIGHT]) {
  int i=-1,k,w=0,h=0,bit[8];

  while (1) { i++;
    if (io) {  /* large */
      switch (color) {
      case DIAMOND: k=(int)diamond_bits[i]; break;
      case HEART:   k=(int)heart_bits[i];   break;
      case SPADE:   k=(int)spade_bits[i];   break;
      default:      k=(int)club_bits[i];    break;
      }
    } else {  /* small */
      switch (color) {
      case DIAMOND: k=(int)diamond_sm_bits[i]; break;
      case HEART:   k=(int)heart_sm_bits[i];   break;
      case SPADE:   k=(int)spade_sm_bits[i];   break;
      default:      k=(int)club_sm_bits[i];    break;
      }
    }
    byte2bit(k,bit);
    for (k=0; k<8; k++) {
      sbit[w][h]=bit[k];
      if (++w==wid) {h++; w=0; break;}
    }
    if (h==hei) break;
  }
}
/* draw jack, queen, king */
static int getjqk(int cc, char sbit[CARD_WIDTH][CARD_HEIGHT]) {
  int x,y,i=-1,k,w=0,h=0,bit[8];

  x = (CARD_WIDTH-FACECARD_WIDTH)/2;
  y = (CARD_HEIGHT-FACECARD_HEIGHT)/2;

  while (1) { i++;
    switch (cc) {
    case C_CJ: k=(int) jack_c_bits[i]; break;
    case C_CQ: k=(int)queen_c_bits[i]; break;
    case C_CK: k=(int) king_c_bits[i]; break;
    case C_SJ: k=(int) jack_s_bits[i]; break;
    case C_SQ: k=(int)queen_s_bits[i]; break;
    case C_SK: k=(int) king_s_bits[i]; break;
    case C_HJ: k=(int) jack_h_bits[i]; break;
    case C_HQ: k=(int)queen_h_bits[i]; break;
    case C_HK: k=(int) king_h_bits[i]; break;
    case C_DJ: k=(int) jack_d_bits[i]; break;
    case C_DQ: k=(int)queen_d_bits[i]; break;
    case C_DK: k=(int) king_d_bits[i]; break;
    default: return 1;
    }
    byte2bit(k,bit);
    for (k=0; k<8; k++) {
      sbit[x+w][y+h]=bit[k];
      if (++w==FACECARD_WIDTH) {h++; w=0; break;}
    }
    if (h==FACECARD_HEIGHT) break;
  }

  for(h=y;h<=y+FACECARD_HEIGHT;h++) {sbit[x][h]=sbit[x+FACECARD_WIDTH][h]=1;}
  for(w=x;w<=x+FACECARD_WIDTH; w++) {sbit[w][y]=sbit[w][y+FACECARD_HEIGHT]=1;}
  return 0;
}

/* draw the cards (for this routine FXColor is defined above) */
void bima2pix(char bit[CARD_WIDTH][CARD_HEIGHT], int cc) {
  int i,j,w,h,x,y,rank,color,smw,smh,lgw,lgh;
  char sbit[FACECARD_WIDTH][FACECARD_HEIGHT];
  spade_lg_bits[0]=0x00; /* to suppress a compiler warning */

  for (i=0;i<CARD_HEIGHT;i++) { for (j=0;j<CARD_WIDTH;j++) bit[j][i]=0; }

  rank=cc; while (rank>12) rank-=13;
                color=DIAMOND;
  if (cc<=C_HK) color=HEART;
  if (cc<=C_SK) color=SPADE;
  if (cc<=C_CK) color=CLUB;

  switch (color) {
  case DIAMOND:
    smw=diamond_sm_width; smh=diamond_sm_height;
    lgw=diamond_width; lgh=diamond_height;
    break;
  case HEART:
    smw=heart_sm_width; smh=heart_sm_height;
    lgw=heart_width; lgh=heart_height;
    break;
  case SPADE:
    smw=spade_sm_width; smh=spade_sm_height;
    lgw=spade_width; lgh=spade_height;
    break;
  default:
    smw=club_sm_width; smh=club_sm_height;
    lgw=club_width; lgh=club_height;
    break;
  }
  /*
   *  fill in the rank
   */
  getrank(rank,sbit);
  for (h=0; h<rank_height; h++) {
    for (w=0; w<rank_width; w++) {
      bit[w+RANK_LOC_X][h+RANK_LOC_Y]=sbit[w][h];
      bit[w+CARD_WIDTH-rank_width-RANK_LOC_X][h+RANK_LOC_Y]=sbit[w][h];
      bit[RANK_LOC_X+rank_width-w][CARD_HEIGHT-RANK_LOC_Y-h]=sbit[w][h];
      bit[CARD_WIDTH-RANK_LOC_X-w][CARD_HEIGHT-RANK_LOC_Y-h]=sbit[w][h];
  } }
  /*
   *  fill in the small colors below the rank
   */
  getcolor(0,color,smw,smh,sbit);
  for (h=0; h<smh; h++) {
    for (w=0; w<smw; w++) {
      bit[w+SMALL_LOC_X][h+SMALL_LOC_Y]=sbit[w][h];
      bit[w+CARD_WIDTH-rank_width-SMALL_LOC_X][h+SMALL_LOC_Y]=sbit[w][h];
      bit[SMALL_LOC_X+rank_width-w][CARD_HEIGHT-SMALL_LOC_Y-h]=sbit[w][h];
      bit[CARD_WIDTH-SMALL_LOC_X-w][CARD_HEIGHT-SMALL_LOC_Y-h]=sbit[w][h];
  } }
  /*
   *  fill in the big colors in cards center
   */
  if (getjqk(cc,bit)) {
    getcolor(1,color,lgw,lgh,sbit); rank++;
    x = lgw/2; y = lgh/2;
    if (rank==1 || rank==3 || rank==5 || rank==9) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL2_X-x+w][CARD_ROW3_Y-y+h]=sbit[w][h];
      } }
    }
    if (rank==2 || rank==3) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL2_X-x+w][CARD_ROW1_Y-y+h]=sbit[w][h];
          bit[CARD_COL2_X+x-w][CARD_ROW5_Y+y-h]=sbit[w][h];
      } }
    }
    if (rank>3) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL1_X-x+w][CARD_ROW1_Y-y+h]=sbit[w][h];
          bit[CARD_COL3_X-x+w][CARD_ROW1_Y-y+h]=sbit[w][h];
          bit[CARD_COL1_X+x-w][CARD_ROW5_Y+y-h]=sbit[w][h];
          bit[CARD_COL3_X+x-w][CARD_ROW5_Y+y-h]=sbit[w][h];
      } }
    }
    if (rank==6 || rank==7 || rank==8) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL1_X-x+w][CARD_ROW3_Y-y+h]=sbit[w][h];
          bit[CARD_COL3_X-x+w][CARD_ROW3_Y-y+h]=sbit[w][h];
      } }
    }
    if (rank==7 || rank==8) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL2_X-x+w][CARD_SEVEN_Y-y+h]=sbit[w][h];
          if (rank==8)
          bit[CARD_COL2_X+x-w][CARD_EIGHT_Y+y-h]=sbit[w][h];
      } }
    }
    if (rank==9 || rank==10) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL1_X-x+w][CARD_ROW2_Y-y+h]=sbit[w][h];
          bit[CARD_COL3_X-x+w][CARD_ROW2_Y-y+h]=sbit[w][h];
          bit[CARD_COL1_X+x-w][CARD_ROW4_Y+y-h]=sbit[w][h];
          bit[CARD_COL3_X+x-w][CARD_ROW4_Y+y-h]=sbit[w][h];
      } }
    }
    if (rank==10) {
      for (h=0; h<lgh; h++) {
        for (w=0; w<lgw; w++) {
          bit[CARD_COL2_X-x+w][CARD_TEN_Y1-y+h]=sbit[w][h];
          bit[CARD_COL2_X+x-w][CARD_TEN_Y2+y-h]=sbit[w][h];
      } }
    }
  }

  /* frame around card */
  for(h=0;h<CARD_HEIGHT;h++) {bit[0][h]=bit[CARD_WIDTH-1][h] =2;}
  for(w=0;w<CARD_WIDTH; w++) {bit[w][0]=bit[w][CARD_HEIGHT-1]=2;}
}
