/* cardface.cc
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef CARDFACE_H
#define CARDFACE_H 1

void cardface(FXApp *app);
FXString cardname(int suit, int rank);

#define	CARD_HEIGHT	123
#define	CARD_WIDTH	79
#include "carddefinitions.h"

/* Kreuz   Club        rank = wert   suit = farbe (z.B. Kreuz)
   Pik     Spade
   Herz    Heart
   Karo    Diamond */

enum {C_CA,C_C2,C_C3,C_C4,C_C5,C_C6,C_C7,C_C8,C_C9,C_CT,C_CJ,C_CQ,C_CK,
      C_SA,C_S2,C_S3,C_S4,C_S5,C_S6,C_S7,C_S8,C_S9,C_ST,C_SJ,C_SQ,C_SK,
      C_HA,C_H2,C_H3,C_H4,C_H5,C_H6,C_H7,C_H8,C_H9,C_HT,C_HJ,C_HQ,C_HK,
      C_DA,C_D2,C_D3,C_D4,C_D5,C_D6,C_D7,C_D8,C_D9,C_DT,C_DJ,C_DQ,C_DK,
      C_NU};

/* get the correct value for the enum above
   rank = 1 for ace, 2 for two, ...., 13 for King
   suit is 0, 1, 2 or 3
 */
static inline int WHICHFACE(int suit, int rank) {return suit*13 + rank-1;}
static inline int WHICHSUIT(int suit)           {return suit/13;}
static inline int WHICHRANK(int face)           {return face - (face/13) * 13 + 1;}

#ifndef CARDFACE_CC
extern
#endif
FXIcon *face[C_NU];  // global

void bima2pix(char bit[CARD_WIDTH][CARD_HEIGHT], int cc);
#endif
