/* -------------------------------------------------------------------
 *  This started as a collection of useful macros and some functions
 *  I use in many programs as I think it is easier to have
 *  them in a file than setting up a library that must be kept
 *  up to date on several computers
 *
 *  Now it is C++ only with very few #define left
 * ------------------------------------------------------------------- */
#ifndef __cplusplus
#error  C++ only
#endif

#ifndef CLEMENS_H
#define CLEMENS_H 1
#ifndef CLEMILER_H
#include "clemiler.h"
#endif

#if ALLOW_CPP17==0
#error To use clemens.h we need C++17
#endif

#include <iostream>
#include <sstream>
#include <fstream>
#include <iomanip>
#include <vector>
#include <array>
#include <list>
#include <map>
#include <cstring>
#include <tuple>
#include <algorithm>
#include <limits>
#include <thread>
#include <chrono>
#include <cmath>
#include <numeric>
#include <complex>
#if MSCOMPILER==0 && __clang_major__ < 2  // termux
#define  LATESTRANDOMMM 1
#include <experimental/random>
#else
#define  LATESTRANDOMMM 0
#include <random>
#endif

#if MINGW==1
#include <windows.h>
#undef max  // otherwise this bloody include ruins Nil, clh::minof, etc
#undef min
#if MSCOMPILER==1
#define __BASE_FILE__  __FILE__   // better than nothing
#endif
#endif

#if ALLOW_CPP20==1
#include <optional>
#include <any>
#include <filesystem>
namespace opto  = std;
namespace anyo  = std;
namespace fisys = std::filesystem;
#else
#include <experimental/optional>
#include <experimental/any>
#include <experimental/filesystem>
namespace opto  = std::experimental;
namespace anyo  = std::experimental;
namespace fisys = std::experimental::filesystem;
#endif

/* ------------------------------------------------------------------------- */

using std::string;
using std::cout;
using std::endl;
using TU_InInIn = std::tuple<int,int,int>;
using TU_StStSt = std::tuple<string,string,string>;
using TU_DoDoDo = std::tuple<double,double,double>;
using TU_AnAn   = std::tuple<anyo::any,anyo::any>;
using TU_AnAnAn = std::tuple<anyo::any,anyo::any,anyo::any>;
static constexpr opto::nullopt_t optiofalse = opto::nullopt;
using  namespace std::literals::string_literals;  // "bar"s (with the suffix s) is a std::string
using  std::string_view;                          // OR string_view and its associated suffix sv.

#define SPECIALCHAR '`' // this is plain old c, left as a reminder to modify certain functions
#ifndef LINELENGTH      // for fgets etc
#define LINELENGTH 1000
#endif
#ifndef ERRORABORT     // cannot use LOCATION yet (needs equal, which needs constpower, which needs ERRORABRORT :)
#define ERRORABORT {cout << "## ERROR ## in: " << __FILE__ << (strcmp(__BASE_FILE__,__FILE__) ? " (" __BASE_FILE__ ") " : " ") << __func__ << " @line: " << __LINE__ << endl; exit(7);}
#endif
static constexpr double EULER   =  2.71828182845904523536;
static constexpr double PPI     =  3.1415926535897932384626433832795;
static constexpr double TWOPPI  =  2.0  *  PPI;
static constexpr double HALFPPI =  0.5  *  PPI;
static constexpr double PPIH80  =  PPI  / 180.0;
static constexpr double H80PPI  = 180.0 /  PPI;
static constexpr double GRAV    =  9.81;
#if LINUX==1
static const string DIRSEP  = "/";
static const string DEVNULL = "/dev/null";
#elif MINGW==1
static const string DIRSEP  = "\\";     // char ds = DIRSEP.front();
static const string DEVNULL = "nul";
#else
#error unsupported OS
#endif

template <typename T> constexpr T ABS(const T a) {return (a < static_cast<T>(0) ? -a : a);}
template <typename T> constexpr T Nil(  )  {return std::numeric_limits<T>::max();}  // e.g. u = Nil<float>();
template <typename T> constexpr T Nil(T &) {return std::numeric_limits<T>::max();}  // special number

/* random numbers between 1 and high (i.e. 1<=ZUFALL(high)<=high) */
template <typename T> inline typename std::enable_if<std::is_integral<T>::value,T>::type ZUFALL(const T high) {
#if LATESTRANDOMMM == 1
  // void reseed();
  return std::experimental::randint(static_cast<T>(1), high);
#else
  static T oldhigh = static_cast<T>(0);
  static std::random_device seed;
  thread_local std::mt19937 gen(seed());  // seeds the random generator (once?)
  static std::uniform_int_distribution<T> dis;
  if (high != oldhigh) {
    oldhigh = high;
    typename std::uniform_int_distribution<T>::param_type party(static_cast<T>(1),high);
    dis.param(party);
  }
  return dis(gen);
#endif
}

namespace clh {  // some very basic stuff
  template <typename T, typename U> constexpr T power(const T a, const U n) {
    if constexpr (std::is_floating_point<U>::value)
		  return std::pow(a,n);
    else {
      if (n  > 1) return a * power(a,n-1);
      if (n == 1) return a;
      if (n == 0) return static_cast<T>(1);
      return static_cast<T>(1)/power(a,-static_cast<int>(n));
    }
  }
#if ALLOW_CPP20 == 1 && __GNUC__ > 9
  template <typename T, typename U> consteval T constpower(const T a, const U n)
#else
  template <typename T, typename U> constexpr T constpower(const T a, const U n)
#endif
  { if (n  > 1) return a * constpower(a,n-1);
    if (n == 1) return a;
    if (n == 0) return static_cast<T>(1);
    ERRORABORT;
  }
  
  inline string upper(string ss) {for_each(ss.begin(),ss.end(), [](char &v) {v=toupper(v);}); return ss;}
  inline string lower(string ss) {for (auto &v : ss)      {v = tolower(v);}    return ss;}
  inline string alt_c(string ss) {ss = clh::lower(ss); ss[0] = toupper(ss[0]); return ss;}

  inline bool onlyonce(const size_t counter) {
    static std::vector<bool> first(16, true);
    if (counter > 15) ERRORABORT;  // 16 ought to be enough
    if (first[counter]) {first[counter] = false; return true;}
    return false;
  }

  template <size_t N=6, typename T> constexpr bool equal(const T a, const T b) {
    if constexpr (std::is_floating_point<T>::value)
		   return (ABS(a-b) <= constpower<T,size_t>(static_cast<T>(0.1),N));
    else           return (a == b);    // useful for strings
  }

  // calculate len for str2num (ia first col to read, ie last)
  template <typename T, typename U> inline auto lenstr(T ia, U ie) -> decltype(ia+ie) {return ie-ia+1;}

  template <typename T> inline string fillstr(string ss, T n7, const bool cut=false, const char fill=' ') {
    size_t n = static_cast<size_t>(n7);
    if (n <= ss.size()) {
      if (cut) {ss.resize(n-1); return " "+ss;} else return ss;
    }
    string tt = "";
    for (auto i = ss.size(); i < n; i++) tt += fill;
    return tt + ss;
  }

  template <typename T> inline string num2str(const T n)      {return std::to_string(n);}
  template <>           inline string num2str(const string n) {return n;}
  template <>           inline string num2str(const char *n)  {return string(n);}
  template <>           inline string num2str(char *n)        {return string(n);}  /* seems to be different */
  template <>           inline string num2str(const char  n)  {char q[] = {n, '\0'}; return string(q);}
  template <typename T> inline string num2str(const std::complex<T> n) {return "("+ num2str(n.real()) +"+"+ num2str(n.imag()) +"i)";}

  template <typename T, typename U, typename V> inline string num2str(const T n, const U w, const V p, const char fill=' ') {
    if (w==0 && p==0) return num2str(n);
    std::ostringstream out;
    if (w > 0) out << std::setw(w);
    if constexpr (std::is_floating_point<T>::value) {
	const int q = static_cast<int>(p);   // does it help if V is unsigned ?
	out << ((q < 0) ? std::scientific : std::fixed) << std::setprecision(ABS(q));
      }
    /**/   out << std::setfill(fill) << n;
    return out.str();
  }
  template <typename U, typename V> inline string num2str(const string n, const U w, const V p, const char fill=' ') {return fillstr(n,w,false,fill);}
  template <typename U, typename V> inline string num2str(const char  *n, const U w, const V p, const char fill=' ') {return fillstr(string(n),w,false,fill);}
  template <typename T, typename U> inline string num2str(const T n,      const U w) {return num2str<T,U,int>(n,w,0);}
  template <typename U>             inline string num2str(const string n, const U w) {return fillstr(n,w);}
  template <typename U>             inline string num2str(const char *n,  const U w) {return fillstr(string(n),w);}

  template <typename T, typename U, typename V> inline T str2num(string ss, const U pos, const V len) {
    T n;
    if (pos > 0) { if (len>0) ss = ss.substr(pos,len); else ss = ss.substr(pos); }
    std::stringstream(ss + " ") >> n;
    return n;
  }
  template <typename T, typename U> inline T str2num(string ss, const U p) {return str2num<T,U,  int>(ss,p,0);}
  template <typename T>             inline T str2num(string ss)            {return str2num<T,int,int>(ss,0,0);}

  template <typename U, typename V> inline int    str2int(string ss, const U pos, const V len) {
    if (len>0) return std::stoi(ss.substr(pos,len)); else return std::stoi(ss.substr(pos));
  }
  template <typename U, typename V> inline double str2double(string ss, const U pos, const V len) {
    if (len>0) return std::stod(ss.substr(pos,len)); else return std::stod(ss.substr(pos));
  }

  template <typename U> inline int    str2int(string ss, const U pos)    {return std::stoi(ss.substr(pos));}
  static                inline int    str2int(string ss)                 {return std::stoi(ss);}
  template <typename U> inline double str2double(string ss, const U pos) {return std::stod(ss.substr(pos));}
  static                inline double str2double(string ss)              {return std::stod(ss);}

  inline string noeol(string ss) {  // get rid of \n and \r
    string::size_type loc = ss.find("\n"); if (loc!=string::npos) ss.erase(loc,1);
    loc = ss.find("\r");
    while (loc != string::npos) {
      ss.erase(loc,1);
      loc = ss.find("\r");
    }
    return ss;
  }
  
  inline string fgets(FILE *v, const int len = LINELENGTH) {
    string tt= "EOF";
    if (v != NULL) {
#if GNUCOMPILER==1 || INTELCOMPILER==1
      char ss[len];  // this is NOT the standard
      if ( fgets(ss,len,v)!=NULL ) tt = noeol(string(ss));
#else
      char *ss = new char[len];
      if ( fgets(ss,len,v)!=NULL ) tt = noeol(string(ss));
      delete [] ss;
#endif
    }
    return tt;
  }
}

#define LOCATION (string(" || " __FILE__) + (clh::equal(__BASE_FILE__,__FILE__) ? " " : " (" __BASE_FILE__ ") ") + __func__ + "@" + std::to_string(__LINE__))
#define ONLYONCE clh::onlyonce(__COUNTER__)
#define LOCP(var,mmx) for(int var=0;var<static_cast<int>(mmx);var++)  // mmx e.g. an enum
#define LOOP(var,mmx) for(decltype(mmx) var=0; var < mmx; var++)      // mmx not constant
#define TRANS(typ,from)                  (dynamic_cast<typ *> (from)) // was static_cast
#define TRANSFORM(typ,from,to)  typ *to = dynamic_cast<typ *> (from)
#define TRANSTATIC(typ,from,to) typ *to = static_cast <typ *> (from)
#ifdef  NOEVA
#define EVA(a)    /* a */
#define EVELIN(a) /* a */
#define ZWERG(a)  /* a */
#define ZWErg(a)  /* a */
#else
#define EVA(a)    (string(" [") + string(#a) + " = " + clh::num2str(a) + "]")
#define EVELIN(a) EVA(a) + LOCATION
#define ZWERG(a)  cout << EVELIN(a) << endl
#define ZWErg(a)  cout << EVA(a) << std::flush
#endif

// // probably a good example for how not to do it (varia could also be public)
// // This macro defines a variable and provides public get.. and set.. functions
// // to read or alter varia (use with care, e.g. DEF_GET_SET_VARIA(int,i) )
// #define DEF_GET_SET_VARIA(type, varia) protected: type varia; public: type get_##varia() {return varia;} void set_##varia(type i) {varia=i;}
// #define DEF_GET_VARIA(type, varia)     protected: type varia; public: type get_##varia() {return varia;}

// WARNING: getenv returns NULL if variable is undefined ==> seg. fault
inline string USER(const bool upp=false) {
#if LINUX==1
  char *sS = getenv("USER");
#elif MINGW==1
  char *sS = getenv("USERNAME");
#else
#error unknown OS
#endif
  if (sS==NULL) return "USER_with_no_name";
  return (upp ? clh::alt_c(string(sS)) : string(sS));
}

inline string HOST() {
#if LINUX==1
  FILE *h = fopen("/etc/hostname","r"); // $HOST undefined when called via ssh
  if (h != NULL) {
    string p = clh::fgets(h); fclose(h); return p;
  }
  char *sS = getenv("HOST");
#else
  char *sS = getenv("COMPUTERNAME");
#endif
  if (sS==NULL) return "HOST_with_no_name";
  return string(sS);
}

inline string HOME() {
  string dir=".";
#if LINUX==1
  char *t1 = getenv("HOME");
  if (t1!=NULL) dir = string(t1);
#elif MINGW==1
  char *t1 = getenv("USERPROFILE");
  if (t1==NULL) {
    /**/  t1 = getenv("HOMEDRIVE");
    char *t2 = getenv("HOMEPATH");
    if (t1!=NULL) {
      dir = string(t1); if (t2!=NULL) dir += string(t2);
    }
  } else {
    dir = string(t1);
  }
#else
#error unknown OS
#endif
  return dir + DIRSEP;
}

// C (like) ARRaY with unlimited dimensions  e.g. Carry<double> ref(0.0, 12,300,n);
template <typename T> class Carry { // only 1 bound check, no warnings, ...
private:
  std::vector<T>      sto;
  std::vector<size_t> dim;
  size_t num, off;
  template <typename U>                 void locre(U b)          {dim[num]    = b;}
  template <typename U, typename ... R> void locre(U b, R ... c) {dim[num++]  = b; locre(c ...);}
  template <typename U>                 void looff(U b)          {num++; off *= dim[num]; off += b;}
  template <typename U, typename ... R> void looff(U b, R ... c) {looff(b); looff(c ...);}
  
public:
  template <typename ... R> void create(const T a, R ... c) {
    clear(); num=off=0;
    dim.resize( sizeof...(c) , 0);
    locre(c ...);
    sto.resize( std::accumulate(dim.begin(),dim.end(),static_cast<size_t>(1),std::multiplies<size_t>()), a);
  }
  // http://www.parashift.com/c++-faq-lite/operator-overloading.html
  template <typename U>                 T& operator() (U a) {
    if (static_cast<size_t>(a) < sto.size()) return sto[a];
    cout << string("Carry"+ EVA(a)+" >"+EVA(sto.size())+EVA(dim.size())) << endl; ERRORABORT;
  }
  template <typename U, typename ... R> T& operator() (U a, R ... b) {
    off = static_cast<size_t>(a); num=0; looff(b ...);
    if (off < sto.size())  return sto[off];   //    avoids seg.fault or worse
    cout << string("Carry"+EVA(off)+" >"+EVA(sto.size())+EVA(dim.size())) << endl; ERRORABORT;
  }
  void copy(const Carry &c) {dim =           c.dim ; sto =           c.sto ;}
  void move(      Carry &c) {dim = std::move(c.dim); sto = std::move(c.sto);}
  /**/                  size_t size()    {return sto.size();}
  template <typename V> size_t size(V i) {if (static_cast<size_t>(i) < dim.size()) return dim[i]; return 0;}
  void   assign(const T a) {for (auto &s : sto) s = a;}
  void   clear()           {sto.clear(); dim.clear();}
  std::vector<T>      storage()   {return sto;}
  std::vector<size_t> dimension() {return dim;}
  
  Carry()  { }                                // constructor
  template <typename ... R> Carry(const T a, R ... c) {create(a, c ...);}
  /**/      Carry(const Carry &c) {copy(c);}  // copy constructor
  void operator= (const Carry &c) {copy(c);}
  /**/      Carry(     Carry &&c) {move(c);}  // move constructor
  void operator= (     Carry &&c) {move(c);}
  ~Carry() {clear();}

  // private:  // FORTRAN addendum
  //   void fortcoun(size_t i, std::vector<size_t> &cou) {
  //     if (i < dim.size()) {
  //       if (++cou[i] == dim[i]) {
  // 	for (size_t j=0; j <= i; j++) cou[j]=0;
  // 	fortcoun(i+1,cou);
  //   } } }
  // public:
  //   int *dimen() {
  //     int *p = new int[dim.size()];
  //     for (size_t j=0; j<dim.size(); j++) p[j] = static_cast<int>(dim[j]);
  //     return p;
  //   }
  //   T *fortran() {  // return sto as an array that can be passed to a fortran subroutine
  //     T *p = new T[sto.size()]; size_t ds = dim.size();      // row/column are different
  //     std::vector<size_t> cou(ds, 0);                        // tested with GCC
  //     for (size_t i=0; i < sto.size(); i++) {
  //       if (ds == 1) off = i; else {
  //         num=0;     off = cou[0];
  // 	for (size_t j=1; j < ds; j++) looff(cou[j]);
  // 	fortcoun(0,cou);
  //       }
  //       p[i] = sto[off];
  //     }
  //     return p;    //                FOR_give me TRAN_sistors
  //   } 
};


namespace clh {
  inline string compilerstr() {
    std::ostringstream os;
#if INTELCOMPILER  == 1  // no longer up-to-date, was used only between 2012 and 14
    const int mar = __INTEL_COMPILER/100;
    const int mir = __INTEL_COMPILER/10 - mar*10;
    const int pat = __INTEL_COMPILER%10;
    os  << "Intel C++ " << mar << "." <<  mir << "." << pat << " (software.intel.com)";
#elif MSCOMPILER == 1
    const int mar = _MSC_FULL_VER/10000000;
    const int mir = _MSC_FULL_VER/100000 - mar*100;
    const int pat = _MSC_FULL_VER - mar*10000000 - mir*100000;
    os  << "VC++ " << mar << "." <<  mir << "." << pat << " (docs.microsoft.com)";
#else
#ifdef __clang__
    os  << "Clang " << __clang_major__ << "." << __clang_minor__ << "." << __clang_patchlevel__ << " (clang.llvm.org)";
#else
    os  << "GCC g++ " << __GNUC__ << "." << __GNUC_MINOR__ << "." << __GNUC_PATCHLEVEL__ << " (gcc.gnu.org)";
#endif
#endif
    return os.str();
  }

  template <typename U> inline size_t cast(const U a) {return static_cast<size_t>(a);}
  template <typename U> inline int    casi(const U a) {return static_cast<int>(a);}
  template <typename U> inline double casd(const U a) {return static_cast<double>(a);}
  template <typename U> inline float  casf(const U a) {return static_cast<float>(a);}

  template <typename... Args> bool alltrue(Args... a) {return ( ... && a);}
  template <typename... Args> bool anytrue(Args... a) {return ( ... || a);}

  // int z = MINLIM(z); // largest or smallest <T>
  template <typename T> constexpr T minlim(T &) {return std::numeric_limits<T>::lowest();}
  template <typename T> constexpr T maxlim(T &) {return std::numeric_limits<T>::max();}

  inline opto::optional<int> isitin(const string txt, const string ss) {
    string::size_type loc = txt.find(ss);
    if (loc == string::npos) return optiofalse;
    return static_cast<int>(loc);
  }

  inline string replace(string ss, const string fr, const char to) {
    for (auto &s : ss) {  // replace every token found in fr with to
      for (const auto &k : fr) {if (s==k) {s = to; break;}}
    }
    return ss;
  }
  inline bool popback(string &ss, const string cond = "") {
    if (cond.empty()) {
      if (ss.size() > 0)      ss.erase(ss.size()-1); else return false;
    } else {
      if (ss.back()==cond[0]) ss.erase(ss.size()-1); else return false;
    }
    return true;
  }
  inline bool popfront(string &ss, const string cond = "") {
    if (cond.empty()) {
      if (ss.size() > 0)       ss.erase(0,1); else return false;
    } else {
      if (ss.front()==cond[0]) ss.erase(0,1); else return false;
    }
    return true;
  }

  inline string totalreplace(string ss, const string fr, const string to) {
    opto::optional<int> k;   /// replace all fr with to
    // while ( (k=isitin(ss,fr)) ) ss.replace(*k,fr.size(),to);  // fails if fr is a backslash
    // return ss;
    string tt = "";
    while ( (k=isitin(ss,fr)) ) {
      tt += ss.substr(0,(*k)) + to;
      ss.erase(0, k.value() + static_cast<int>(fr.size()));
    }
    return tt + ss;
  }

  template <typename T> inline string totalreplace(string ss, const string fr, const string to,
						   const T ia, const T ie=0) {
    string vv, uu;
    if (ie > ia) {vv = ss.substr(ie+1); ss.erase(ie+1);} else vv = "";  // this first
    if (ia >  0) {uu = ss.substr(0,ia); ss.erase(0,ia);} else uu = "";
    return uu + totalreplace(ss,fr,to) + vv;
  }

  template <typename T, typename U> inline void set_mapdata(std::map<U,T> &data, const U first, const T second) {
    data[first] = second;
  }
  template <typename T, typename U> inline opto::optional<T> get_mapdata(std::map<U,T> &data, const U first) {
#if ALLOW_CPP20==1
    if (data.contains(first)) return data[first];
    return optiofalse;
#else
    auto ee  = data.find(first);
    if  (ee == data.end()) return optiofalse;
    return ee->second;
#endif
  }
  template <typename T> opto::optional<T> inline get_mapdata(std::map<string,T> &data, const char *first) {
    return get_mapdata(data, string(first));
  }

  template <typename T> inline std::vector<T> list2vector(std::list<T> lis) {
    std::vector<T> vec(lis.size());
    std::move(lis.begin(), lis.end(), vec.begin());
    return vec;
  }
  static inline std::vector<char> str2charvector(const string ss, const bool low=false) {
    std::vector<char> css;
    css.reserve(ss.size() +2);
    for (const char &c : ss) css.push_back( low ? tolower(c) : c );
    return css;
  }

  inline string correctpath(string tt) {
#if LINUX==1
    return replace(tt,"\\",'/');
#elif MINGW==1
    return replace(tt,"/",'\\');
#else
#error unknown OS
#endif
  }
  // always needed when pathnames are listed (e.g. in a gnupl-file)
  inline string doublebackslash(string ss) {
#if MINGW==1
    ss = totalreplace(ss, "\\\\", "\\");
    ss = totalreplace(ss, "\\",   "\\\\");
#endif
    return ss;
  }


  inline int system(const string ss) {
#if MINGW == 1
    if ( !(clh::isitin(ss,"<") || clh::isitin(ss,">")) ) {  // redirection is IMpossible
      PROCESS_INFORMATION p_info;  memset(&p_info, 0, sizeof(p_info));
      STARTUPINFO         s_info;  memset(&s_info, 0, sizeof(s_info));
      string tt = clh::doublebackslash(clh::correctpath(ss));
      bool   success = false;
      LPSTR  cmdline = new char[tt.size() +1];
      strcpy(cmdline, tt.c_str());
      if (CreateProcess(NULL, cmdline, NULL, NULL, FALSE, CREATE_NO_WINDOW, NULL, NULL, &s_info, &p_info) != 0) {
	WaitForSingleObject(p_info.hProcess, INFINITE);
	CloseHandle(p_info.hProcess);
	CloseHandle(p_info.hThread);
	success = true;
      }   // kind of a fallthru here, in case CreateProcess fails
      if (cmdline != NULL) delete [] cmdline;
      if (success) return 0;
    }
#endif
    return std::system(ss.c_str());  // on WIN: opens an annoying extra window, on LINUX: no problem :)
  }

  template <typename T> constexpr bool isNil(const T a) {
    if      constexpr (std::numeric_limits<T>::is_exact) return (a == Nil(a));
    else if constexpr (std::is_floating_point<T>::value) return (a > 0.999999 * std::numeric_limits<T>::max());
    else                                                 return false;  // e.g. strings
  }

  // #else    //// OLDER than C++17
  // template <typename T, typename U> constexpr typename std::enable_if<std::is_integral<U>::value,T>::type POWER(const T a, const U n) {
  //   if (n  > 1) return a * POWER(a,n-1);
  //   if (n == 1) return a;
  //   if (n == 0) return static_cast<T>(1);
  //   return static_cast<T>(1)/POWER(a,-static_cast<int>(n));
  // }
  // template <typename T> inline typename std::enable_if<!std::is_floating_point<T>::value,bool>::type isNil(const T a) {
  //   return (a == Nil(a));
  // }
  // template <typename T> inline typename std::enable_if< std::is_floating_point<T>::value,bool>::type isNil(const T a) {
  //   return (a > 0.999999 * std::numeric_limits<T>::max());
  // }
  // #if ALLOW_CPP14==1
  // template <size_t N=6, typename T> inline typename std::enable_if<!std::is_floating_point<T>::value,bool>::type clh::equal(const T a, const T b) {
  //   return (a == b);
  // }
  // template <size_t N=6, typename T> inline typename std::enable_if< std::is_floating_point<T>::value,bool>::type clh::equal(const T a, const T b) {
  //   return (ABS(a-b) <= POWER<T>(static_cast<T>(0.1),N));
  // }
  // #else
  // //  for gcc4.x - use with care
  // template <size_t N,   typename T> class  PowEr      {public: static T eval(T a) {return a * PowEr<N-1,T>::eval(a);}};
  // template <            typename T> class  PowEr<1,T> {public: static T eval(T a) {return a;}                        };
  // template <size_t N,   typename T> inline T    POWER(const T a) {return PowEr<N,T>::eval(a);} // POWER<16>(2.0); 2^16
  // template <size_t N=6, typename T> inline bool clh::equal(const T a, const T b) {return (ABS(a-b) <= POWER<N,T>(static_cast<T>(0.1)));}
  // #endif
  // #endif

  template <size_t N=6, typename T> inline bool  isZero(const T a) {return  clh::equal<N,T>(a,static_cast<T>(0));}
  template <size_t N=6, typename T> inline bool notZero(const T a) {return !clh::equal<N,T>(a,static_cast<T>(0));}
  template <size_t N=6, typename T> inline bool  isOne(const  T a) {return  clh::equal<N,T>(a,static_cast<T>(1));}
  template <size_t N=6, typename T> inline bool notOne(const  T a) {return !clh::equal<N,T>(a,static_cast<T>(1));}
  template <size_t N=6>             inline bool  isPPI(const double a) {return  clh::equal<N,double>(a,PPI);}
  template <size_t N=6>             inline bool notPPI(const double a) {return !clh::equal<N,double>(a,PPI);}
  template <typename T>             inline bool notNil(const  T a) {return !isNil(a);}

  template <typename T> constexpr T sign(const T a) {
    if (clh::equal(a,  static_cast<T>(0)))  return static_cast<T>(0);
    return   (a < static_cast<T>(0)) ? -static_cast<T>(1) : static_cast<T>(1);
  }

  
#if ALLOW_CPP20==1 && MSCOMPILER==0
  template <size_t N=6, typename T> inline bool equal(const std::vector<T> aa, const std::vector<T> bb) {
    if (aa.size() != bb.size()) return false;
    for (size_t j = 0; T a : aa) {if (!equal<N,T>(a,bb[j++])) return false;}
    return true;
  }
  template <size_t J, size_t N=6, typename T> inline bool equal(const std::array<T,J> aa, const std::array<T,J> bb) {
    for (size_t j = 0; T a : aa) {if (!equal<N,T>(a,bb[j++])) return false;}
    return true;
  }
#else
  template <size_t N=6, typename T> inline bool equal(const std::vector<T> aa, const std::vector<T> bb) {
    if (aa.size() != bb.size()) return false;
    size_t j = 0;
    for (T a : aa) {if (!equal<N,T>(a,bb[j++])) return false;}
    return true;
  }
  template <size_t J, size_t N=6, typename T> inline bool equal(const std::array<T,J> aa, const std::array<T,J> bb) {
    size_t j = 0;
    for (T a : aa) {if (!equal<N,T>(a,bb[j++])) return false;}
    return true;
  }
#endif

  template <typename T, typename U> constexpr opto::optional<T> divide(const T a, const U n) {
    if (isZero(n)) return optiofalse;
    return a/static_cast<T>(n);
  }
  template <typename T, typename U, typename V> constexpr T divide(const T a, const U n, const V dbg) {
    if (dbg > 0) {
      if (opto::optional<T> div = divide(a,n); div) {
	return (*div);
      } else {
	cout << __func__ << ": division by 0 " << EVA(a) << EVA(n) << endl;
  	if (dbg==1) return maxlim(a);
	ERRORABORT;
    } }
    return a/static_cast<T>(n);
  }

  template <size_t N=6, typename T> inline void unique(std::vector<T> &v, const bool reverse=false) {
    if (reverse) std::sort(v.begin(),v.end(), [](T a, T b) {return (a > b);});  // from large to small
    else         std::sort(v.begin(),v.end(), [](T a, T b) {return (a < b);});  // from small to large (default)
    v.erase(   std::unique(v.begin(),v.end(), [](T a, T b) {return equal<N,T>(a,b);}), v.end());
  }
  inline void unique(std::vector<string> &v, const bool casesense, const bool reverse) {  // typical unique(...,false,false);
    if (!casesense) {
      if (reverse) std::sort(v.begin(),v.end(), [](string a, string b) {return (lower(a)  > lower(b));}); // from large to small
      else         std::sort(v.begin(),v.end(), [](string a, string b) {return (lower(a) <  lower(b));}); // from small to large (default)
      v.erase(   std::unique(v.begin(),v.end(), [](string a, string b) {return (lower(a) == lower(b));}), v.end());
    } else {
      unique<0,string>(v,reverse);
  } }

  template <typename T, typename U> inline U intpol4(T xx, T x1, T x2, U a, U b) {
    // d cannot be cast to U if U is integer
    double d = divide(static_cast<double>(xx-x1), static_cast<double>(x2-x1), 2);
    // (1.0-d)*a + d*b is more precise than (a + n*(b-a)) for n=1 and a much < b
    return static_cast<U>((1.0-d)*a + d*b);   // careful if U is integer
  }

  // #if INTELCOMPILER==1  /* very strange */
  // template <typename T> inline int  NINT(const T a) {return static_cast<int>(a + SIGN(a)/2);}
  // template <typename T> inline T INTPART(const T a) {return static_cast<T>(static_cast<long long>(a) );}
  // template <typename T> inline T NEAREST(const T a) {return static_cast<T>(static_cast<long long>(a+SIGN(a)/2));}
  // #else
  template <typename T, typename U> inline T nearest(const U a) {return static_cast< T >(std::round(a));}
  template             <typename U> inline int  nint(const U a) {return nearest<int>(a);}
  template <typename T> inline T intpart(const   T a) {return std::trunc(a);}
  template <typename T> inline T floatpart(const T a) {return a - intpart(a);}

  template <typename T> inline T  minof(T a, T b) {return std::min<T>(a,b);}
  template <typename T> inline T  maxof(T a, T b) {return std::max<T>(a,b);}
  template <typename T> inline T absmin(T a, T b) {return (ABS(a) < ABS(b)) ? a : b;}
  template <typename T> inline T absmax(T a, T b) {return (ABS(a) > ABS(b)) ? a : b;}
  template <typename T, typename ... R> inline T  minof(T a, R ... b) {return  minof(a, minof(b ...));}
  template <typename T, typename ... R> inline T  maxof(T a, R ... b) {return  maxof(a, maxof(b ...));}
  template <typename T, typename ... R> inline T absmin(T a, R ... b) {return absmin(a,absmin(b ...));}
  template <typename T, typename ... R> inline T absmax(T a, R ... b) {return absmax(a,absmax(b ...));}

  inline string hourcpy(int noblank=0) {
    time_t tT=time(NULL);
    struct tm *date = localtime(&tT);
    std::stringstream os;
    os << ((date->tm_hour<10)?"0":"") << date->tm_hour << (noblank?".":":")
       << ((date->tm_min <10)?"0":"") << date->tm_min  << (noblank?".":":")
       << ((date->tm_sec <10)?"0":"") << date->tm_sec;
    return os.str();
  }

  inline int getdate(int &da, int &mo, int &ye) {
    time_t tT=time(NULL); struct tm *date = localtime(&tT);
    da = date->tm_mday;
    mo = date->tm_mon  + 1;
    ye = date->tm_year + 1900;
    return date->tm_wday;
  }
  
  inline int gethour(int &ho, int &mi, int &se) {
#if ALLOW_CPP20 == 999
    using namespace std::chrono;
    auto tp = zoned_time{current_zone(), system_clock::now()}.get_local_time();
    auto dp = floor<days>(tp);
    year_month_day ymd{dp};
    hh_mm_ss time{floor<milliseconds>(tp-dp)};
    auto y = ymd.year();
    auto m = ymd.month();
    auto d = ymd.day();
    auto h = time.hours();
    auto M = time.minutes();
    auto s = time.seconds();

    ho = static_cast<int>(h);
    mi = static_cast<int>(M);
    se = static_cast<int>(s);
    return 3;
#else
    time_t tT=time(NULL); struct tm *date = localtime(&tT);
    ho = date->tm_hour;
    mi = date->tm_min;
    se = date->tm_sec;
    return date->tm_wday;
#endif
  }

  inline string timecpy(int noblank=0, time_t tT = 0) {  // english
    char s[30];  if (tT < 2) tT = time(NULL);
    strcpy(s,ctime(&tT)); string ss = string(s);
    if (noblank!=0) ss = replace(replace(ss,":",'+')," ",'_');  // for use in filenames
    return noeol(ss);
  }
  inline void timeprt(FILE *v=stdout, const char *s = "") {fprintf(v,"%s%s",timecpy().c_str(),s);}

  /* ---------- technical formulas ---------- */

  template <typename T> inline T mile2km(const T mi) {return static_cast<T>(static_cast<double>(mi)*1.609    );}
  template <typename T> inline T km2mile(const T km) {return static_cast<T>(static_cast<double>(km)*0.6215   );}
  template <typename T> inline T ms2knot(const T ms) {return static_cast<T>(static_cast<double>(ms)*1.9438445);}
  template <typename T> inline T knot2ms(const T kn) {return static_cast<T>(static_cast<double>(kn)*0.5144444);}
  template <typename T> inline T feet2m(const T feet, const T inch=static_cast<T>(0)) {
    return static_cast<double>(feet)*0.3048 + static_cast<double>(inch)*0.0254;
  }  // the temperatures below might also work with T as integer
  template <typename T> inline T fahrenheit2celsius(const T fah) {
    return static_cast<T>( (static_cast<double>(fah) - 32.0) / 1.8 );
  }
  template <typename T> inline T celsius2fahrenheit(const T cel) {
    return static_cast<T>(static_cast<double>(cel) * 1.8 + 32.0);
  }

  ////// ---- string funs ----

  inline string extract(string &ss, string a, string e="", bool erase=false) {
    if (e=="") e = a;     //// a and e must have size() of 1
    size_t a1 = ss.find(a);    if (a1==string::npos) return ""; else a1++;
    size_t a2 = ss.find(e,a1); if (a2==string::npos) return ""; else a2--;
    string tt = ss.substr(a1, a2-a1+1);   // extract substring
    if (erase)  ss.erase(a1-1,a2-a1+1+2); // remove substring from string
    return tt;
  }

  inline string whitetrim(string in, const bool all=false) {
    if (in.empty()) return "";
    string ss = replace(in,"\t\n\r",' ') + " ";
    bool   n;
    size_t i=0, j=0, m=ss.size()-1;
    while (ss[i]==' ') {if (++i==m) return "";} // remove leading blanks
    in[j++]=ss[i];
    while (++i < m) {
      if (all) n=(ss[i]!=' '); else n=(!(ss[i]==' ' && ss[i+1]==' '));
      if (n)   in[j++]=ss[i];
    }
    return in.erase(j);
  }

  inline string entscram(string ss) {
    std::reverse(ss.begin(),ss.end());
    for (auto &s : ss) {int i = static_cast<int>(s)-42; if (i < 0) i+=256; s = static_cast<char>(i);}
    return ss;}
  inline string verscram(string ss) {
    for (auto &s : ss) {int i = static_cast<int>(s)+42; if (i>255) i-=256; s = static_cast<char>(i);}
    std::reverse(ss.begin(),ss.end());
    return ss;
  }
  
  inline string::size_type get_last_dirsepstr(const string &tt) {
    string::size_type n = tt.find_last_of(DIRSEP);
#if MINGW==1
    //  in MSYS DIRSEPSTR might be a /
    if (n==string::npos) n = tt.find_last_of("/");
#endif
    return n;
  }

  inline string getfdir(string tt) {
    return fisys::path(tt).parent_path().string();    // buggy on gnu in windows, ms is ok
    // string::size_type n = get_last_dirsepstr(tt);
    // if (n==string::npos) return "";
    // return tt.erase(n); // erase also last /
  }

  inline string getfname(string tt, const int skip) {
    string::size_type n = get_last_dirsepstr(tt);
    if (n==string::npos) n=0;
    string::size_type m = tt.find_last_of(".");
    if (m > n   && m!=string::npos) tt.erase(m);     // get rid of extension
    if (skip!=0 && n!=0)            tt.erase(0,n+1); // skip directory part
    return tt;
  }
  inline string getfname(string name, const bool skip=false) {return getfname(name, skip ? 1:0);}

  inline string getfext(string tt) {  // get extension without .
    tt = fisys::path(tt).extension().string();
    return tt.erase(0,1);
    // string::size_type n = get_last_dirsepstr(tt);
    // if (n==string::npos) n=0;
    // string::size_type m = tt.find_last_of(".");
    // if (m > n && m!=string::npos) return tt.erase(0,m+1);
    // return "";
  }

  // compare "in" to ss.substr(a)
  template <typename T> inline bool substrcompa(string ss, const T a, string in, bool casesense=false) {
    size_t ii = in.size();
    if (ii+static_cast<size_t>(a) > ss.size()) return false;
    if (casesense) {
      for (size_t i=static_cast<size_t>(a), j=0; j<ii; i++,j++) {if (ss[i] != in[j]) return false;}
    } else {
      for (size_t i=static_cast<size_t>(a), j=0; j<ii; i++,j++) {if (tolower(ss[i]) != tolower(in[j])) return false;}
    }
    return true;
  }

  /* --------- FILE handler ---------- */
  
  class fileAttrib {
  private:
    template <typename TP> std::time_t any_to_time_t(TP tp) {                            ///       was probably the same in C++17
      auto sctp = std::chrono::time_point_cast<std::chrono::system_clock::duration>(tp - TP::clock::now() + std::chrono::system_clock::now());
      return      std::chrono::system_clock::to_time_t(sctp);
    }
    
  protected:
    bool   ok;
    fisys::file_time_type lawrti;
    string fname, absdir, purnam;
    std::array<int,3> perm;
    std::error_code ec;
    void  permissions() {
      perm = {0,0,0};
      if (ok) {
	fisys::perms p = fisys::status(fname,ec).permissions();
	if ((p & fisys::perms::owner_read)  != fisys::perms::none) perm[0]  = 4;
	if ((p & fisys::perms::owner_write) != fisys::perms::none) perm[0] += 2;
	if ((p & fisys::perms::owner_exec)  != fisys::perms::none) perm[0] += 1;
	if ((p & fisys::perms::group_read)  != fisys::perms::none)     perm[1] = 4;
	if ((p & fisys::perms::group_write) != fisys::perms::none) ++++perm[1]; // yes :)
	if ((p & fisys::perms::group_exec)  != fisys::perms::none)   ++perm[1];
	if ((p & fisys::perms::others_read) != fisys::perms::none)     perm[2] = 4;
	if ((p & fisys::perms::others_write)!= fisys::perms::none) ++++perm[2]; // adds 2
	if ((p & fisys::perms::others_exec) != fisys::perms::none)   ++perm[2]; // adds 1
    } }
  public:
    fileAttrib() {ok = false; perm = {0,0,0}; fname = absdir = purnam = "";}
    fileAttrib(const char  *file)          {set(string(file));}
    fileAttrib(const string file)          {set(file);}
    fileAttrib(const fileAttrib  &fa)      {set(fa.fname);}
    void operator= (const fileAttrib  &fa) {set(fa.fname);}
    fileAttrib(      fileAttrib &&fa)      {
      ok = fa.ok; perm = fa.perm;  lawrti = fa.lawrti;
      fname = std::move(fa.fname); absdir = std::move(fa.absdir); purnam = std::move(fa.purnam);
    }
    void operator= (      fileAttrib &&fa) {
      ok = fa.ok; perm = fa.perm;  lawrti = fa.lawrti;
      fname = std::move(fa.fname); absdir = std::move(fa.absdir); purnam = std::move(fa.purnam);
    }
    void set(const fileAttrib &fa) {set(fa.get_fname());}
    void set(const char  *file)    {set(string(file));}
    void set(const string file)    { // file might not exist yet
      fname  = file; popback(fname, DIRSEP);
      ok     = fisys::exists(fname,ec);
      lawrti = fisys::last_write_time(fname,ec);
#if ALLOW_CPP20==1
      absdir = fisys::absolute(fname,ec).parent_path().string();
#else
      absdir = fisys::absolute(fname).parent_path().string();
#endif
      purnam = clh::getfname(fname,true);
      permissions();
    }
    string getadir()  const {return absdir;}    // no DIRSEP at the end
    string getfdir()  const {return fisys::path(fname).parent_path().string();}
    string getfname() const {return purnam;}    // name without path and without ext
    string getfext()  const {                   // extension without .
      string tt = fisys::path(fname).extension().string();
      return tt.erase(0,1);
    }
    string getnamext() const {return purnam + fisys::path(fname).extension().string();}
    string get_fname() const {return fname;}
    string get_aname() const {return absdir + DIRSEP + purnam + fisys::path(fname).extension().string();}
    int               num_perm() const {return 100*perm[0] + 10*perm[1] + perm[2];}
    std::vector<int>  vec_perm() const {return {   perm[0],     perm[1],  perm[2]};}
    std::array<int,3> arr_perm() const {return     perm;}
    bool   isDir()     {return (ok && fisys::is_directory(fname,ec));}
    bool   isFile()    {return (ok && fisys::is_regular_file(fname,ec));}
    bool   isLink()    {return (ok && fisys::is_symlink(fname,ec));}
    bool   empty()     {if (isFile() || isLink()) return (fisys::file_size(fname,ec) < 1); else return true;}
    unsigned long long get_size() {
      if (isFile()) return static_cast<unsigned long long>(fisys::file_size(fname,ec));
      return 0;
    }
    fisys::file_time_type get_moditime() {return lawrti;}
    
    template <typename T> void modifyTime(const fisys::file_time_type tim, const T s) {  // set to tim, add time difference s
      std::chrono::seconds sec(s);
      if (ok) fisys::last_write_time(fisys::path(fname), tim + sec);
    }
    template <typename T> void modifyTime(const T tim) {   // add time difference tim (might be negative)
      // auto t = std::chrono::time_point_cast<fisys::file_time_type::duration>(std::chrono::system_clock::from_time_t(tim) -
      // 									     std::chrono::system_clock::now() +
      // 									     fisys::file_time_type::clock::now());
      std::chrono::seconds sec(tim);
      if (ok) fisys::last_write_time(fisys::path(fname), lawrti + sec);
    }
    void modifyTime() {
      if (ok) fisys::last_write_time(fisys::path(fname), fisys::file_time_type::clock::now());
    }

    time_t get_Mtime() {
      if (!ok) return 0;
      return any_to_time_t(lawrti);
    }
    void modifyOtherTime(string otherfile) {   // set mod.time of otherfile to this time
      if (fisys::exists(otherfile,ec)) fisys::last_write_time(fisys::path(otherfile), lawrti);
    }
  };

  inline bool filexists(const string fn) {
    fileAttrib fiat(fn);
    return     fiat.empty() ? false : true; // it exists and is not empty and is not a directory...
  }
}
 

inline FILE *FOPEN(const string ss, const string rw="r") {
  if (rw == "r" && !clh::filexists(ss)) return NULL;
  return fopen(ss.c_str(),rw.c_str());
}
#define FCLOSE(v) {if (v!=NULL) fclose(v); v=NULL;}
#define TOTOP(v)  fseek(v,0L,SEEK_SET)


namespace clh {
  inline bool kopie(FILE *in, FILE *out, int io=0) {
    if (in ==NULL) return false;
    if (out==NULL) return false;
    int i;

    if (io==1) {        // dos -> unix
      while( (i=fgetc(in))!=EOF ) if (i!='\r') fputc(i,out);
    } else if (io==2) { // unix -> dos
      int li='a';
      while( (i=fgetc(in))!=EOF ) {
	if (i=='\n' && li!='\r') fputc('\r',out);
	fputc(i,out);
	li=i;
      }
    } else if (io== 4) {
      while( (i=fgetc(in))!=EOF ) {i+=42; if (i>255) i-=256; fputc(i,out);}
    } else if (io==-4) {
      while( (i=fgetc(in))!=EOF ) {i-=42; if (i<  0) i+=256; fputc(i,out);}
    } else {
      while( (i=fgetc(in))!=EOF ) fputc(i,out);
    }
    return true;
  }
  inline bool kopie(FILE *in, const string ooo, int io=0) {
    FILE *ou = fopen(ooo.c_str(),"wb");
    if (ou==NULL) return false;
    bool b = kopie(in,ou,io); /* b==false ==> in==NULL ==> remove ooo */
    if (b) fclose(ou); else {fprintf(ou,"x"); fclose(ou); fisys::remove(ooo);}
    return b;
  }
  inline bool kopie(const string inn, FILE *ou, int io=0) {
    FILE *in = fopen(inn.c_str(),"rb"); bool b=kopie(in,ou,io); FCLOSE(in);
    return b;
  }
  inline bool kopie(const string inn, const string ooo, int io=0) {
    FILE *in = fopen(inn.c_str(),"rb"); bool b=kopie(in,ooo,io); FCLOSE(in);
    return b;
  }

  inline string private_mkdir(string dir) {    // buggy on gnu in windows, ms is ok
#if MINGW==1
    if (dir.front() == '/')
      dir = replace(dir,"\\",'/');  // MSys
    else
#endif
      dir = correctpath(dir);

    // fisys::create_directories(dir);
    std::error_code ec;
    if (!fisys::create_directories(dir,ec)) {  // problems creating it (might exist already)
      if (!fisys::is_directory(dir,ec)) return "";  // could not be created
    }
    return dir;
  }

  inline string mkdir_rel2home(const string direc, int doit=1) {
    string dir = HOME() + direc;
    if (doit != 0) dir = private_mkdir(dir);
    return dir;
  }

  inline string mktmpdir(string file="") {
    static string dir = "";
    if (dir.size()>2) return dir + file;
#if LINUX==1
    dir = "/tmp"; // should always work on UNIX systems
#elif MINGW==1
    char *t = getenv("TMP");
    if (t==NULL) t   = getenv("TEMP");
    if (t==NULL) dir = "c:\\temp"; // unlikely failure
    else         dir = string(t);
#endif
    dir += DIRSEP + "delete+forget-" + USER() + DIRSEP;
    dir  = private_mkdir(dir);
    return (dir.empty() ? dir : dir + file);
  }

  inline string tMpFN(string ident) {
    string filnam = mktmpdir();
#if GNUCOMPILER==1 || INTELCOMPILER==1
    filnam += __BASE_FILE__;
#else
    filnam += "tmp-con";
#endif
    return filnam + "-" + ident + "-";  // ident should be string(argv[1])
  }

  inline string mktmpfile(string ident="") {
    FILE *v;
    string tt = tMpFN(ident) + timecpy(1); // UNIQUESTRING(time(NULL));
    for (int i=11; i<1000; i++) {
      if ( (v=FOPEN(tt)) == NULL ) return tt; else fclose(v);
      tt += num2str(-i);
    }
    return "*_is_an_error_*";
  }

  // controlled temporary file
  // NOTE: 2 programs running simultaneaously will create exactly the same files
  inline string mkcontmpfile(string ident,  // e.g. loop variables
			     int i1=0, int i2=0, int i3=0, int i4=0, int i5=0) {
    return tMpFN(ident) +
      num2str(i1)+"x"+num2str(i2)+"x"+num2str(i3)+"x"+num2str(i4)+"x"+num2str(i5);
  }

  inline FILE *comfile(const string comand, int nn=8) {
    string file = mkcontmpfile("comFile",nn,nn); // execute a command and write output to file
    fisys::remove(file);
    clh::system(comand + " >> " + file + " 2>> " + file);
    if (filexists(file)) return FOPEN(file);
    return NULL;
  }
  
  //  does not work correctly for umlauts on Win10 with GCC (MSC++ is ok)
  inline std::list<string> get_files_in_dir(string folder, bool subdir=false) {
    fileAttrib fiat(folder);
    if (!fiat.isDir()) {cout << fiat.get_fname() << " is not a directory" << endl; return {""};}
    if (folder.back() != DIRSEP.front()) folder += DIRSEP;
    std::list<string> names;
    //  for( auto &p : fisys::recursive_directory_iterator(folder) ) names.push_back(p);
    for (auto &p : fisys::directory_iterator(folder) ) {
      string na  = fisys::path(p).filename().string();
      if (subdir) {
	fiat.set(folder + na);      //    ZWERG(folder+na);
	if (fiat.isDir()) {
	  std::list<string> nam2 = get_files_in_dir(folder + na, true);
	  for (auto &n : nam2) names.push_back(na + DIRSEP + n);
	} else {
	  names.push_back(na);
	}
      } else {
	names.push_back(na);
      }
    }
    return names;
  }
  inline std::vector<string> get_sorted_files_in_dir(string folder, bool subdir=false) {
    std::list<string>   filesxxxxx = get_files_in_dir(folder, subdir);
    std::vector<string> filesindir(filesxxxxx.size());  // dimensioning before move is a must!
    std::move(filesxxxxx.begin(), filesxxxxx.end(), filesindir.begin());
    std::sort(filesindir.begin(), filesindir.end(), [&](string a, string b) {return (clh::lower(a) < clh::lower(b));});
    return filesindir;
  }

  class Doublint {
  public:
    enum isA {Int=41, Double, Unknown, String};
  private:
    string  sdi;
    double  adi;
    isA     isa;
  public:
    Doublint(const string ar, const isA itisa = Doublint::Unknown) {
      if (itisa == Doublint::String) { // dont check, force it to be a string
	sdi = whitetrim(ar); adi = 0.0; isa = Doublint::String; 
      } else
	set(ar); // almost always
    }
    isA    get_isa()   {return  isa;}
    bool   isAint()    {return (isa==Doublint::Int);}
    bool   isAdouble() {return (isa==Doublint::Double);}
    bool   isAnumber() {return (isa==Doublint::Int || isa==Doublint::Double);}
    string get_sdi()   {return  sdi;}
    double get_adi()   {return  adi;}
    int    get_idi()   {return nearest<int>   (adi);}  // best fit: 1.0e3 => 1000, but 3.14 => 3
    size_t get_tdi()   {return nearest<size_t>(adi);}  // neg. numbers?

    void set(const string ar) {
      sdi = whitetrim(ar);
      adi = 0.0;
      isa = Doublint::String;
      string ss = lower(sdi);
      opto::optional<int> op = isitin(ss,"e+");  // REMEMBER: exponent might also
      opto::optional<int> om = isitin(ss,"e-");  // be d+ or d- (fortran output)
      if (op && !om)                ss.erase(*op+1,1); // exponent e+ is ok
      if (om && !op)                ss.erase(*om+1,1); // exponent e- is ok
      if (ss[0]=='+' || ss[0]=='-') ss.erase(0,1);     // leading  +- is ok

      int ce=0, cp=0, nbr=0,    i=-1;
      for (const char c : ss) { i++;
	switch (c) {
	case '0':
	case '1': // stod would read "11number" as 11, which I dont want
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':     ++nbr;  break;
	case 'e': if (++ce==2 || i==0) return; break; // one (but no leading) e is ok
	case '.': if (++cp==2)         return; break;
	default:                       return; break;
      } }
      if (nbr == 0) return;
      isa = (((ce+cp) == 0) ? Doublint::Int : Doublint::Double);
      adi = std::stod(sdi);
    }
  };
  
  class ScanAstring {
  private:
    std::vector<Doublint> vikki;
    string seperator; // seperator for CSV files (default is ' ' i.e. no csv)
  public:
    void next(string xx, const int nn=0) {
      vikki.clear();
      xx  = whitetrim(xx) + seperator;
      if (backwardblank(xx)) return;   /// see below, we still need it :(
      int n = (nn==0 ? maxlim(nn) : nn);
      for (int i=0; i<n; i++) {
	opto::optional<int> opi = isitin(xx, seperator);
	if (opi) {
	  if (*opi > 0) vikki.emplace_back( Doublint(xx.substr(0,*opi)) );
	  xx.erase(0, *opi +1);
	} else
	  break;
    } }
    void next(const char txt[], const int n=0) {next(string(txt), n);}

    ScanAstring(const char sep = ' ') {char jj[] = {sep, '\0'}; seperator = string(jj);}
    ScanAstring(const string xx, const char sep = ' ', const int n=0) : ScanAstring(sep) { next(xx, n); }
    ScanAstring(const char tx[], const char sep = ' ', const int n=0) : ScanAstring(sep) { next(tx, n); }

    int  numtokens() {return casi(vikki.size());}
    size_t  size()   {return      vikki.size(); }
    template <typename T> bool   is_sdi(const T i)  {return true;}   // by definition
    template <typename T> bool   is_idi(const T i)  {return (cast(i) < vikki.size() ? vikki[i].isAint()    : false);}
    template <typename T> bool   is_adi(const T i)  {return (cast(i) < vikki.size() ? vikki[i].isAdouble() : false);}
    template <typename T> bool   is_num(const T i)  {return (cast(i) < vikki.size() ? vikki[i].isAnumber() : false);}
    template <typename T> string get_sdi(const T i) {return (cast(i) < vikki.size() ? vikki[i].get_sdi()   : "");}
    template <typename T> double get_adi(const T i) {return (cast(i) < vikki.size() ? vikki[i].get_adi()   : 0.0);}
    template <typename T> int    get_idi(const T i) {return (cast(i) < vikki.size() ? vikki[i].get_idi()   : 0);}
    template <typename T> size_t get_tdi(const T i) {return (cast(i) < vikki.size() ? vikki[i].get_tdi()   : 0);}

  private:   /* an unfortunate design decision made years ago */
    bool backwardblank(string xx) {
      static const string sc = num2str(SPECIALCHAR);
      if (seperator == " " && isitin(xx,sc)) {
	int    i=-1;
	string tt="";
	while (xx[++i]) {
	  switch(xx[i]) {
	  case '\n':
	  case '\r': break;
	  case SPECIALCHAR:  // long string (CAREFUL must be between ` `)
	    tt="";           // i.e. with possible blanks
	    while (xx[++i]) {
	      if (xx[i]==SPECIALCHAR) {
		vikki.emplace_back(Doublint(tt,Doublint::String)); tt="";
		break;
	      } else
		tt += xx[i];
	    }
	    break;
	  case '\t':
	  case ' ' :   /* end of token */
	    if (tt.size() > 0) {vikki.emplace_back(Doublint(tt)); tt="";}
	    break;
	  default:
	    tt += xx[i];
	    break;
	} }
	return true;
      }
      return false;
    }
  };

  template <size_t N=6, typename T> inline bool lesseq(const   T a, const T b) {return (equal<N,T>(a,b) ? true :  a < b);}
  template <size_t N=6, typename T> inline bool greteq(const   T a, const T b) {return (equal<N,T>(a,b) ? true :  a > b);}
  template <size_t N=6, typename T> inline bool lessthan(const T a, const T b) {return (equal<N,T>(a,b) ? false : a < b);}
  template <size_t N=6, typename T> inline bool gretthan(const T a, const T b) {return (equal<N,T>(a,b) ? false : a > b);}

  template <typename T> inline T      flip(T      a) {return -a;}
  template <>           inline bool   flip(bool   a) {return (a ? false : true);}
  template <>           inline string flip(string a) {std::reverse(a.begin(),a.end()); return a;}

  template <typename T, typename U, typename V> inline T putbetween(const T num, const U min1, const V max1) {
    T mi1 = std::min<T>(static_cast<T>(min1),static_cast<T>(max1)); if (num < mi1) return mi1;
    T ma1 = std::max<T>(static_cast<T>(min1),static_cast<T>(max1)); if (num > ma1) return ma1;
    return num;
  }

 template <size_t N=6, typename T, typename U, typename V> inline bool inclBetween(const T num, const U min1, const V max1) {
    return (greteq<N>(num,static_cast<T>(min1)) && lesseq<N>(num,static_cast<T>(max1)));
  }
  template <size_t N=6, typename T, typename U, typename V> inline bool exclBetween(const T num, const U min1, const V max1) {
    return (gretthan<N>(num,static_cast<T>(min1)) && lessthan<N>(num,static_cast<T>(max1)));
  }
  template <size_t N=6, typename T, typename U, typename V> inline bool inexBetween(const T num, const U min1, const V max1) {
    return (greteq<N>(num,static_cast<T>(min1)) && lessthan<N>(num,static_cast<T>(max1)));
  }
  template <size_t N=6, typename T, typename U, typename V> inline bool exinBetween(const T num, const U min1, const V max1) {
    return (gretthan<N>(num,static_cast<T>(min1)) && lesseq<N>(num,static_cast<T>(max1)));
  }
  
  template <typename T> inline void sleep_min(const T ti) {std::this_thread::sleep_for(std::chrono::minutes(ti));}
  template <typename T> inline void sleep_sec(const T ti) {std::this_thread::sleep_for(std::chrono::seconds(ti));}
  template <typename T> inline void sleep_msc(const T ti) {std::this_thread::sleep_for(std::chrono::milliseconds(ti));}

  template <typename T, typename U> inline size_t get_index(std::vector<T> &vv, const U a, const bool grow=true) {
    size_t index = 0;
    for (T i : vv) {if (equal(i,static_cast<T>(a))) return index; else ++index;}
    if (grow) {
      vv.push_back(static_cast<T>(a));
      return vv.size()-1;
    }
    return Nil(index);
  }

  template <typename T, typename U> U get_generic(T i, std::vector<U> &vv) {
    size_t j = cast(i);
    if (j < vv.size()) return vv[j];  // if i is element of vector then return it
    return Nil<U>();                  // else return Nil (but do not crash)
  }

  inline string erasebefore(string ss, const string a, const bool keep=false) {
    opto::optional<int> k = isitin(ss,a);
    if (k) {
      if (keep) ss.erase(0,(*k));                              // a is left
      else	ss.erase(0,(*k) + static_cast<int>(a.size())); // a will be removed, too
    }
    return ss;
  }

  inline string eraseafter(string ss, const string a, const bool keep=false) {
    opto::optional<int> k = isitin(ss,a);
    if (k) {
      if (keep) ss.erase((*k) + static_cast<int>(a.size())); // a is left
      else      ss.erase((*k));                              // a will be removed, too
    }
    return ss;
  }

  inline string replace(string ss, const string fr, const string to=" ") {
    return replace(ss,fr,to.front());
  }

  inline string replacewithin(string ss, const char bd, const char fr, const char to) {
    bool found = false;    // WarningString = "Illegal; set to 'OD'" replacewithin(ss,'"','\'',' ')
    for (auto &c : ss) {   // replace single char fr with to, but only within bd
      if (c==bd)   found    = flip(found);
      if (c==fr && found) c = to;
    }
    return ss;
  }

  inline int numtokens(const char ss[]) { // get number of tokens in a string
    int i=-1, ii=1, nanz=0;
    while (ss[++i]) {
      switch(ss[i]) {
      case '\n' :
      case '\r' : break;
      case '\t' :
      case ' '  : ii=1;           break;
      default   : nanz+=ii; ii=0; break;
    } }
    return nanz;
  }
  inline int numtokens(const string ss) {return numtokens(ss.c_str());}
  inline int numtokens(const string ss, const string a) {
    string tt = eraseafter(ss,a);  // find tokens between 0 and character a (e.g "#")
    return numtokens(tt.c_str());
  }

  inline int suboccurence(const string str, const string o) {
    int    n = 0;
    size_t a = 0;   // count occurences of substr o
    while (n < 99999999) {
      a = str.find(o,a);
      if (a == string::npos) break; else {n++; a += o.size();}
    }
    return n;
  }

  inline TU_InInIn get_date() {
    int da, mo, ye; getdate(da,mo,ye);
    return  std::make_tuple(da,mo,ye);
  }
  inline TU_InInIn get_time(bool seconds=true) {
    int ho, mi, se; gethour(ho,mi,se);
    if (!seconds) {  // round minutes and hours
      if (se > 29) {mi++; if (mi == 60) {ho++; mi=0; if (ho == 24) ho=0;}}
      se=0;
    }
    return std::make_tuple(ho,mi,se);
  }

  [[deprecated("USE opto::optional<int> isitin")]]
  inline int IsItIn(const string txt, const string ss) {  // deprecated
    string::size_type loc = txt.find(ss);
    if (loc == string::npos) return -77;  // always check for > -1
    return static_cast<int>(loc);         // because loc may be 0
  }

}  // end of clh
#endif
