/*
   Copyright (C) 2002 Clemens Schiff

   CSButton is an FXButton that knows which MouseButton is pressed

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "fxclemens.h"
#include "csbutton.h"

FXDEFMAP(CSButton) CSButtonMap[]={
  //____Message_Type______________ID_______________Message_Handler___
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,    0,  CSButton::onLBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,  0,  CSButton::onLBRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,  0,  CSButton::onMBtnPress),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE,0,  FXButton::onLeftBtnRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,   0,  CSButton::onRBtnPress),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE, 0,  FXButton::onLeftBtnRelease),
};

FXIMPLEMENT(CSButton,FXButton,CSButtonMap,ARRAYNUMBER(CSButtonMap))

bool CSButton::rightbuttonlongpress = true; // for systems with only 1 button (e.g. tablets)


long CSButton::onLBtnPress(FXObject *o, FXSelector s, void *p) {
  whichbutton=LEFTBUTTON;
  return FXButton::onLeftBtnPress(o,s,p);
}

long CSButton::onLBRelease(FXObject *o, FXSelector s, void *p) {
  if (rightbuttonlongpress) {
    TRANSTATIC(FXEvent,p,event);          // if pressed for > 1 sec
    if (event->time - event->click_time > 1010) whichbutton=RIGHTBUTTON;
  }
  return FXButton::onLeftBtnRelease(o,s,p);
}

long CSButton::onMBtnPress(FXObject *o, FXSelector s, void *p) {
  whichbutton=MIDDLEBUTTON;
  return FXButton::onLeftBtnPress(o,s,p);
}

long CSButton::onRBtnPress(FXObject *o, FXSelector s, void *p) {
  whichbutton=RIGHTBUTTON;
  return FXButton::onLeftBtnPress(o,s,p);
}

