/*
   Copyright (C) 2002 Clemens Schiff

   CSButton is an FXButton that knows which MouseButton is pressed

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef CSBUTTON_H
#define CSBUTTON_H

class CSButton : public FXButton {
  FXDECLARE(CSButton)

protected:
  FXint whichbutton;
  CSButton() { }

public:
  /// Construct a CSButton
  CSButton(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXObject* tgt=NULL,FXSelector sel=0,
	   FXuint opts=BUTTON_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,
	   FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD) :
    FXButton(p,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb) {
    whichbutton=LEFTBUTTON;
  }

  FXint getButton() {return whichbutton;}
  long  onLBRelease(FXObject*,FXSelector,void*);
  long  onLBtnPress(FXObject*,FXSelector,void*);
  long  onMBtnPress(FXObject*,FXSelector,void*);
  long  onRBtnPress(FXObject*,FXSelector,void*);

  static bool rightbuttonlongpress;
  enum {ID_CSBUTTON=FXButton::ID_LAST, ID_LAST};
};
#endif

