
/// ------- just a MainWindow around class CLASS ---------

#ifndef CSMAINWIN_H
#define CSMAINWIN_H 1

class CSLabel : public FXLabel {
public:
  CSLabel(FXComposite* p,const FXString& text,FXIcon* ic=0,FXuint opts=LABEL_NORMAL,
	  FXint x=0,FXint y=0,FXint w=0,FXint h=0,
	  FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD) :
    FXLabel(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb) { }
  void setOptions(FXuint opt, bool rc=false) {options = opt; if (rc) recalc();}
};


class CSMainWin : public FXMainWindow {
  FXDECLARE(CSMainWin)

private:
  FXApp     *app;
  FXWindow  *klass;  // whatever CLASS is, it is a child of FXWindow
  FXIcon    *penguin, *appicon;
  CSLabel   *label;
  std::vector <FXButton *> placeholder;
  CSMainWin(){ }

public:
  CSMainWin(FXApp *a);
  virtual ~CSMainWin() { }
  enum{ ID_FIRST=FXMainWindow::ID_LAST, ID_QUIT, ID_ABOUT, ID_LAST};
  void create();
  long onCmdAbout(FXObject*, FXSelector, void*);
  long onCmdQuit (FXObject*, FXSelector, void*);
  void setLabelText(FXString s) {label->setText(s);}
  CSLabel   *getLabel()       {return label;}
  FXIcon    *getmwicon()      {return appicon;}
  FXIcon    *getpenguinicon() {return penguin;}
  FXWindow  *getklass()       {return klass;}
  FXButton  *getButton(int i);
  int       activatePlaHol(FXObject *obj, FXSelector sel, FXString txt);
};

#endif

