
/// ------- just a MainWindow around class CLASS ---------

/*  and, no doubt, there better ways to do it

necessary:
#define CLASSNAME    xxx
static const FXString CLASSSTRING "xXx";
#define CLASS  CLASSNAME(app,this,LAYOUT_SIDE_TOP|LAYOUT_FILL)
static       FXString LICENSETEXT = "gpl";
static const FXString EXTRAHELP   = "";

optional:
#ifdef EXTRASETTINGS
  when defined the functions
  readEntry() and writeEntry() must be set in CLASS
#ifdef PROCESS_ARGV
  when defined the function
    process_argv(int n, FXString(argv[n])) is called by constructor
#ifdef HAVE_MY_OWN_MAIN
  int main has to be written below #include "csmainwin.h"
#ifdef NUMPLACEHOLDER
  this should be avoided (allows for add. Buttons on statusbar)
  if defined CLASS will become a standalone MainWindow again
  mawi = static_cast<CSMainWin *>(p);
#ifdef APPLICATIONICON
  provide icon data as #define APPLICATIONICON new FXGIFIcon(app,XXX)
*/

#if MSCOMPILER > 0 || INTELCOMPILER > 0
#ifndef NOCRTMAIN
#define NOCRTMAIN 0
#endif
#if NOCRTMAIN==1
// // /// suppresses console window
#pragma comment(linker, "/ENTRY:mainCRTStartup /SUBSYSTEM:windows")
#endif
#endif

#include "csmainwin.h"

const char *moddate(const int i);

FXDEFMAP(CSMainWin) CSMainWinMap[]={
  FXMAPFUNC(SEL_CLOSE,   0,                   CSMainWin::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND, CSMainWin::ID_QUIT,  CSMainWin::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND, CSMainWin::ID_ABOUT, CSMainWin::onCmdAbout),
};
FXIMPLEMENT(CSMainWin,FXMainWindow,CSMainWinMap,ARRAYNUMBER(CSMainWinMap))


#ifndef APPLICATIONICON
const unsigned char csmily[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x20,0x00,0x20,0x00,0xf7,0x00,0x00,0x0c,0x04,0x00,
  0x01,0x0c,0x00,0x0d,0x0c,0x00,0x06,0x01,0x00,0x14,0x00,0x00,0x1a,0x01,0x00,0x1d,
  0x0a,0x00,0x1c,0x02,0x0b,0x03,0x16,0x04,0x19,0x15,0x00,0x11,0x03,0x1d,0x27,0x1a,
  0x00,0x0b,0x21,0x0c,0x3d,0x32,0x00,0x22,0x25,0x00,0x07,0x0c,0x22,0x2a,0x04,0x30,
  0x36,0x41,0x00,0x3e,0x63,0x00,0x46,0x4c,0x00,0x53,0x54,0x00,0x5a,0x6d,0x00,0x7b,
  0x7f,0x00,0x71,0x4f,0x10,0x9b,0x0c,0x00,0x9b,0x17,0x00,0xab,0x0e,0x00,0xa6,0x01,
  0x00,0xbf,0x0d,0x00,0xb4,0x09,0x00,0xa3,0x14,0x00,0xaa,0x13,0x00,0xa3,0x1b,0x00,
  0xa9,0x18,0x00,0xbb,0x14,0x00,0xbc,0x1b,0x02,0xb3,0x17,0x00,0x9d,0x28,0x00,0xaa,
  0x24,0x00,0xac,0x2e,0x00,0xb3,0x22,0x00,0xbb,0x2d,0x00,0xa9,0x36,0x00,0xb6,0x38,
  0x01,0xb3,0x34,0x14,0xc3,0x0e,0x00,0xcc,0x09,0x00,0xc9,0x00,0x00,0xd6,0x02,0x00,
  0xdc,0x03,0x00,0xd5,0x0b,0x01,0xdd,0x0c,0x01,0xd9,0x06,0x0a,0xc3,0x11,0x00,0xca,
  0x13,0x01,0xc6,0x1b,0x04,0xca,0x19,0x06,0xd5,0x12,0x00,0xdd,0x13,0x01,0xda,0x1b,
  0x04,0xd9,0x17,0x0c,0xcb,0x0f,0x10,0xd2,0x13,0x14,0xe5,0x02,0x02,0xec,0x02,0x01,
  0xe3,0x0c,0x02,0xeb,0x0a,0x01,0xe1,0x02,0x0d,0xeb,0x03,0x0a,0xe8,0x0b,0x0a,0xf4,
  0x01,0x01,0xfa,0x01,0x02,0xf3,0x0b,0x01,0xfe,0x0b,0x02,0xf4,0x02,0x0d,0xfc,0x02,
  0x0b,0xf2,0x0b,0x0c,0xff,0x0b,0x0e,0xe4,0x12,0x04,0xea,0x11,0x01,0xe5,0x17,0x08,
  0xfc,0x13,0x02,0xf2,0x10,0x08,0xec,0x01,0x13,0xea,0x0c,0x12,0xe5,0x08,0x19,0xf5,
  0x00,0x14,0xfc,0x02,0x13,0xf4,0x0b,0x10,0xfe,0x09,0x12,0xf4,0x02,0x1b,0xfb,0x03,
  0x1b,0xfd,0x0a,0x1c,0xe8,0x15,0x16,0xfd,0x12,0x17,0xd9,0x25,0x0b,0xc0,0x3d,0x00,
  0xd1,0x22,0x0d,0xf2,0x24,0x0a,0xd0,0x0b,0x25,0xe8,0x09,0x23,0xf2,0x01,0x22,0xfa,
  0x05,0x23,0xff,0x11,0x2e,0xe7,0x12,0x26,0xdd,0x22,0x2d,0xa6,0x43,0x00,0xb7,0x47,
  0x00,0xbb,0x54,0x00,0xbc,0x5c,0x02,0xab,0x5a,0x09,0x88,0x7d,0x11,0xb1,0x7e,0x08,
  0xc4,0x4d,0x00,0xc9,0x58,0x00,0xd4,0x4e,0x00,0xc2,0x6e,0x00,0xd4,0x67,0x16,0xd0,
  0x75,0x0f,0xe0,0x72,0x11,0xd2,0x67,0x21,0xea,0x7f,0x2f,0x78,0x88,0x06,0x5d,0x80,
  0x22,0x84,0x8a,0x07,0x82,0x91,0x00,0x9e,0x9d,0x11,0x9c,0x99,0x0e,0xa7,0x99,0x01,
  0xa6,0x9d,0x1e,0xac,0xab,0x00,0xa3,0xa3,0x00,0xb0,0xa6,0x00,0xb3,0xbb,0x00,0xba,
  0xb7,0x00,0xa5,0xb4,0x00,0xa6,0x99,0x39,0x9f,0xbf,0x30,0xad,0xab,0x24,0x94,0xb6,
  0x17,0xd3,0x86,0x0b,0xe9,0x86,0x12,0xf0,0x93,0x14,0xc9,0xb1,0x06,0xcd,0x90,0x2d,
  0xf7,0x9a,0x22,0xeb,0x90,0x31,0xc9,0xbf,0x2c,0xf8,0xaa,0x24,0xef,0xb5,0x26,0xff,
  0xb9,0x39,0xfa,0xb1,0x33,0xb7,0xc9,0x01,0xb6,0xd7,0x00,0xc7,0xc9,0x06,0xd6,0xca,
  0x06,0xc6,0xd6,0x00,0xdf,0xdf,0x00,0xc5,0xc2,0x15,0xcf,0xde,0x13,0xde,0xd4,0x1b,
  0xe4,0xdb,0x01,0xf8,0xdb,0x1a,0xeb,0xd6,0x12,0xce,0xee,0x00,0xc4,0xe3,0x00,0xda,
  0xe9,0x06,0xcc,0xff,0x00,0xdd,0xfb,0x03,0xd9,0xf9,0x05,0xde,0xff,0x10,0xd4,0xfe,
  0x16,0xd1,0xed,0x18,0xe2,0xe5,0x01,0xeb,0xe5,0x01,0xeb,0xee,0x01,0xe2,0xed,0x06,
  0xf1,0xec,0x0b,0xf8,0xe6,0x0a,0xe4,0xf2,0x03,0xec,0xf3,0x03,0xe5,0xfe,0x03,0xee,
  0xff,0x06,0xe7,0xff,0x0b,0xe9,0xfe,0x0c,0xe9,0xf4,0x0c,0xf2,0xf5,0x03,0xf3,0xfb,
  0x03,0xfc,0xfd,0x05,0xff,0xf1,0x09,0xf4,0xfd,0x0a,0xfc,0xfe,0x0c,0xf1,0xf3,0x0a,
  0xe9,0xe9,0x1a,0xfb,0xeb,0x16,0xf8,0xe8,0x15,0xe6,0xfc,0x16,0xeb,0xfb,0x15,0xed,
  0xff,0x1a,0xe7,0xf4,0x16,0xfc,0xf5,0x14,0xf4,0xfb,0x13,0xfc,0xfd,0x14,0xff,0xf3,
  0x1b,0xf4,0xfd,0x1c,0xfd,0xfd,0x1c,0xf4,0xf3,0x17,0xc7,0xc4,0x29,0xfc,0xde,0x29,
  0xff,0xcc,0x3a,0xfe,0xd5,0x39,0xda,0xf3,0x3e,0xde,0xf8,0x23,0xfe,0xed,0x25,0xfe,
  0xeb,0x2c,0xfa,0xe5,0x24,0xed,0xfe,0x23,0xe9,0xf5,0x28,0xf4,0xfe,0x23,0xfe,0xfe,
  0x25,0xfe,0xf3,0x2a,0xf3,0xfc,0x2d,0xfd,0xfd,0x2b,0xf6,0xf3,0x26,0xe2,0xe7,0x35,
  0xff,0xec,0x35,0xff,0xe3,0x3c,0xfc,0xe7,0x36,0xfd,0xf5,0x32,0xfd,0xfc,0x32,0xff,
  0xfe,0x3b,0xfc,0xf8,0x38,0xee,0xf4,0x2c,0xb9,0x96,0x45,0xff,0xbd,0x4c,0xff,0xb7,
  0x42,0xd5,0xdb,0x48,0xff,0xdb,0x43,0xff,0xd9,0x4f,0xff,0xd3,0x46,0xff,0xd9,0x59,
  0xff,0xc4,0x45,0xd8,0xf9,0x52,0xe6,0xe7,0x44,0xff,0xed,0x45,0xfe,0xe7,0x4a,0xe8,
  0xf5,0x4a,0xfe,0xfc,0x4b,0xff,0xf7,0x46,0xff,0xe7,0x51,0xff,0xea,0x55,0xe6,0xf5,
  0x58,0xff,0xf7,0x57,0xff,0xdd,0x6d,0xfc,0xf9,0x64,0xfb,0xf9,0x70,0x21,0xf9,0x04,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x08,
  0xfe,0x00,0x85,0x08,0xa1,0xa2,0xc5,0xca,0x91,0x23,0x40,0xba,0x8c,0x19,0x83,0xe6,
  0x07,0x12,0x2f,0x45,0xa0,0xf0,0xa0,0x31,0x85,0xcb,0x95,0x23,0x49,0x88,0x4c,0x21,
  0xc2,0x11,0x09,0x12,0x21,0x4f,0x7e,0xd0,0xd0,0xb2,0x25,0xc9,0x11,0x24,0x55,0xc6,
  0xa4,0xf1,0x91,0x23,0x87,0x8d,0x0d,0x18,0x6e,0x7c,0xd1,0xf1,0x83,0x89,0x91,0x1f,
  0x4d,0xb8,0x70,0x21,0xf2,0x03,0x88,0x47,0x27,0x42,0xa6,0x28,0x31,0x62,0xe4,0xa4,
  0x13,0x1c,0x23,0x3c,0x98,0x90,0xc3,0xa8,0x29,0x9d,0x15,0x20,0x44,0xf0,0x80,0x22,
  0x46,0xc8,0x8f,0x1f,0x18,0x8f,0x10,0x75,0xb8,0xc5,0x60,0x92,0x28,0x41,0x6e,0x7c,
  0x88,0x43,0xc9,0x5d,0xbd,0x70,0xf8,0xcc,0x9d,0xd3,0x17,0xef,0xce,0x1a,0x12,0x24,
  0xc4,0x3c,0x29,0xaa,0xf5,0xc8,0x12,0xad,0x4b,0x96,0x5c,0x21,0xe2,0x22,0x04,0x9b,
  0x4b,0xf7,0xb8,0xc9,0x4a,0x76,0x8b,0x54,0x2a,0x54,0xcd,0xb8,0x85,0x6b,0xd7,0x48,
  0xc5,0x87,0x1d,0x51,0xf0,0xde,0x35,0x69,0xa4,0x09,0x8d,0x0e,0x2b,0x20,0xf1,0x0b,
  0x27,0xca,0x19,0x33,0x5b,0xb5,0x6e,0xdd,0x42,0x65,0x2b,0xd9,0x35,0x7a,0xfa,0xdc,
  0xb5,0x41,0xf1,0xc2,0x88,0xc5,0x83,0xb0,0x99,0xf4,0x60,0x01,0xe9,0xdf,0x3e,0x7b,
  0xec,0xc0,0xa1,0x4b,0x06,0x0c,0x98,0xaf,0x59,0xcc,0xcc,0xb1,0x63,0xb7,0xef,0x5f,
  0xbf,0x3a,0x1a,0x66,0x70,0xb1,0x62,0x24,0x89,0x11,0x24,0x4a,0x60,0xa0,0x70,0xe3,
  0x67,0x51,0xa2,0x0a,0x02,0x16,0xf8,0xb9,0xe7,0x2d,0x54,0xa8,0x6f,0xfa,0x02,0xfe,
  0x39,0x40,0x20,0x41,0x8f,0x22,0x38,0x6b,0x6e,0x0c,0xd9,0x62,0x04,0xc8,0x8c,0x19,
  0x5d,0x6c,0xac,0xa9,0x07,0x4e,0x1e,0x85,0x00,0x07,0x08,0x2c,0x40,0x04,0x88,0x10,
  0xa0,0x47,0xe9,0x14,0x30,0x00,0x02,0x08,0xec,0xb1,0x0f,0x3e,0xeb,0x60,0x00,0x45,
  0x17,0x57,0x41,0x91,0x83,0x0f,0x1f,0x38,0x42,0x8e,0x31,0xd3,0x24,0x40,0x00,0x04,
  0x10,0x10,0x40,0x01,0x3f,0xf8,0xe4,0xa3,0xcf,0x05,0x07,0x28,0xf0,0x00,0x03,0x08,
  0xd8,0xf3,0xcd,0x3b,0x72,0x90,0x20,0x43,0x10,0x45,0xe8,0xb0,0x03,0x0e,0x2b,0x48,
  0xb3,0x4c,0x2e,0xe8,0x34,0x50,0x40,0x7e,0x06,0xf0,0x91,0x4d,0x31,0xc1,0xdc,0xc3,
  0x07,0x00,0x00,0x0c,0x10,0x40,0x03,0xd4,0x08,0x23,0xce,0x25,0x1e,0xd8,0x00,0xc5,
  0x13,0x31,0xf0,0xa0,0x41,0x1e,0xf4,0x20,0x43,0xcb,0x36,0x93,0x18,0x60,0xe5,0x04,
  0xf6,0x78,0x63,0x4a,0x2e,0xe5,0xcc,0x33,0x81,0x00,0x02,0x24,0xf0,0x8c,0x33,0xbd,
  0x5c,0xe3,0xce,0x09,0x37,0xe8,0x10,0x44,0x12,0x3a,0x60,0xa0,0x4e,0x3d,0xe5,0xe8,
  0xe2,0x4b,0x37,0x9e,0x58,0xc0,0xc7,0x27,0xcc,0xf8,0xf2,0x8b,0x2f,0xb5,0x68,0xc3,
  0x8a,0x1e,0x7c,0x78,0xf2,0x0d,0x32,0xca,0x08,0x53,0x0f,0x1e,0x23,0xe8,0x80,0x44,
  0x12,0x33,0xa8,0xa0,0x0f,0x3e,0xc1,0x6c,0x03,0xcc,0x36,0xde,0x64,0x63,0x4e,0x33,
  0xb3,0xec,0xf2,0x8a,0x2e,0xa6,0xa0,0xe2,0x4d,0x37,0xe8,0xdc,0x23,0x8b,0x2e,0xca,
  0x20,0x23,0x8e,0x24,0x21,0xcc,0x60,0x52,0x0e,0x6c,0xd4,0x83,0x8e,0x2a,0xfe,0xde,
  0xc8,0x12,0xcb,0x37,0xc5,0xa0,0xa2,0x8c,0x32,0xb1,0x6c,0xc3,0x4d,0x33,0xb6,0xa4,
  0x92,0x4b,0x37,0xd0,0x80,0x12,0x0a,0x2f,0xb7,0x74,0x73,0x09,0x08,0x6b,0x26,0x91,
  0x83,0x1a,0xd2,0x60,0x83,0xcd,0x37,0x9b,0x0c,0x33,0xcc,0x9e,0xb3,0x28,0xb3,0x8d,
  0x30,0xd5,0x2c,0xc3,0x4b,0xaf,0xe5,0xd4,0x43,0x88,0x29,0xb5,0xa4,0xd2,0x4d,0x25,
  0x19,0x38,0x81,0x91,0x0c,0x2a,0xdc,0x43,0xcd,0x2a,0xe5,0x10,0x32,0x0a,0x39,0x52,
  0x36,0xc3,0x8b,0x2b,0xc8,0x2c,0xb3,0x0d,0x2d,0xbc,0x00,0x83,0x0e,0x3f,0x83,0xb0,
  0x62,0x0c,0x31,0xde,0x54,0x82,0x6c,0x12,0x4b,0xe8,0xa0,0x82,0x34,0xdd,0xac,0x62,
  0x8e,0x21,0x8f,0x88,0xe2,0x0d,0x32,0x99,0xfe,0xc2,0x8b,0x32,0xad,0xec,0xf2,0x4b,
  0x32,0x5d,0x02,0x92,0x0d,0x33,0xc9,0x70,0x13,0x89,0x07,0x4e,0x2c,0x51,0x46,0x17,
  0x19,0x54,0xa2,0xcd,0x2d,0xc9,0x98,0xf2,0x08,0x32,0xde,0xc4,0xe2,0x4b,0x32,0xba,
  0x90,0x4a,0xcb,0x2f,0xb3,0xc4,0x62,0x8e,0x26,0x86,0x24,0xf3,0x4b,0x2c,0xe3,0xd4,
  0xe1,0x01,0x1a,0x55,0x94,0x51,0x45,0x08,0x76,0x9c,0xf3,0xca,0x2b,0xbf,0x10,0xe2,
  0xca,0x8c,0xdb,0x34,0x83,0xb4,0xc5,0xbf,0xb4,0xe2,0x4d,0x30,0x82,0x98,0xa2,0xcb,
  0x2f,0xb2,0x44,0xa3,0x42,0x0f,0x41,0x6f,0x01,0xc3,0x17,0x2a,0xb4,0x73,0x8d,0x33,
  0xcd,0x70,0xa2,0x89,0x29,0xde,0xf8,0xf2,0x0a,0x2f,0xbc,0xd0,0x42,0x8b,0x2e,0xdb,
  0x94,0x83,0x49,0x21,0xda,0xe8,0xd2,0xcb,0x38,0x1f,0xf3,0x10,0x84,0xfe,0x10,0x46,
  0x08,0xa1,0x43,0x08,0x8d,0xf0,0x53,0x4d,0x31,0xc6,0x94,0xc2,0x89,0x29,0xcc,0x20,
  0x43,0x68,0x33,0xc9,0x34,0xa3,0x8d,0x26,0x98,0x60,0x53,0x0c,0xd6,0xef,0xcc,0x61,
  0x43,0x0c,0x52,0x08,0x71,0x44,0x14,0x31,0xe4,0x90,0x82,0x25,0xe1,0x1c,0x93,0xca,
  0x29,0x99,0x60,0x12,0xcc,0x39,0xe3,0x9c,0xc3,0xcd,0x39,0xc1,0x40,0xce,0x8a,0x36,
  0xa9,0x28,0x23,0x4a,0x23,0x37,0x74,0xe1,0x13,0x46,0xcd,0xc5,0x70,0x43,0x1c,0xf9,
  0x7c,0xb3,0xca,0x2a,0xc4,0x94,0x32,0x88,0x21,0xa0,0x68,0x62,0xbc,0x20,0x74,0x33,
  0x43,0x0a,0x33,0xd5,0x44,0x93,0xc2,0x0b,0x5a,0x5c,0x44,0xd9,0x12,0x66,0xd0,0x20,
  0x82,0x1d,0xfa,0x7c,0x73,0x0c,0x31,0xcc,0xb4,0x5e,0x48,0x21,0x87,0x70,0x92,0xcb,
  0xcb,0xc9,0x7c,0x03,0x4d,0x34,0x6b,0x70,0x40,0x46,0x19,0x5a,0x34,0xd1,0x37,0x10,
  0x57,0x98,0x51,0x06,0x0d,0x29,0xb4,0xd1,0xce,0x38,0xd6,0x54,0xe3,0x8d,0x37,0xcd,
  0xe4,0xa2,0x8d,0x36,0xc0,0x70,0xc5,0x30,0xc6,0x21,0x0d,0x75,0xc4,0x41,0x04,0x34,
  0x38,0x83,0x19,0xac,0xa0,0x84,0x1f,0x38,0xa1,0x08,0x53,0xb0,0x42,0x19,0xa8,0x20,
  0x83,0x0f,0xac,0x40,0x12,0xf0,0xc8,0x07,0x34,0x64,0xf1,0x8a,0x5d,0x6c,0xa9,0x19,
  0xe6,0xc8,0xc7,0x3a,0xea,0xf0,0x81,0x16,0xc0,0x80,0x09,0x59,0x30,0x02,0x11,0x8a,
  0x10,0x84,0x19,0x14,0x41,0x09,0x07,0x59,0x02,0x16,0x74,0x20,0x02,0x12,0xac,0xe0,
  0x0e,0x97,0x10,0x47,0x38,0xaa,0x11,0x0e,0x7a,0x48,0xc3,0x11,0x8e,0x71,0x40,0x41,
  0x0b,0x78,0x40,0x85,0x2d,0x2c,0x81,0x28,0x1f,0xf9,0xc1,0x0c,0x1c,0x62,0x92,0x83,
  0x48,0xc1,0x09,0x2e,0x11,0x81,0x09,0x4e,0xc0,0x86,0x36,0xb4,0x41,0x0d,0x25,0x00,
  0xc1,0x08,0x76,0xe0,0x84,0x1f,0x14,0x05,0x08,0x40,0x88,0x02,0x12,0x7e,0x40,0x04,
  0x26,0x00,0xa1,0x28,0x94,0x41,0x08,0x16,0x28,0xe8,0x02,0xa4,0x74,0x40,0x04,0x37,
  0x08,0xc3,0x4c,0x1c,0x72,0x97,0xf6,0x08,0x61,0x8c,0x40,0xd8,0x82,0x11,0x89,0x12,
  0xc3,0x26,0x10,0x41,0x09,0x48,0x00,0x23,0x12,0xd6,0x48,0x84,0x21,0x90,0x51,0x09,
  0x4c,0xb8,0x4b,0x13,0x98,0x10,0x84,0x20,0xf4,0xa4,0x32,0x5b,0xb8,0xc2,0x5d,0x0e,
  0x62,0x05,0x2b,0x6c,0xe1,0x8c,0x49,0x70,0x8e,0x11,0xf4,0xb2,0x04,0x25,0x30,0x10,
  0x86,0x47,0x50,0xc2,0x0a,0xf7,0x56,0x14,0x23,0x04,0x04,0x00,0x3b
  };
#endif

const unsigned char penguindata[]={
 0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x12,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
 0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x10,0x10,0x10,0xff,0xff,0xff,0xe0,
 0xa0,0x08,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x12,0x00,0x00,0x03,
 0x53,0x08,0xba,0x21,0x12,0x2b,0xc6,0xe6,0x9e,0x94,0x62,0x64,0x77,0xa3,0x20,0x4e,
 0x21,0x74,0x8b,0x60,0x9c,0x1a,0xa9,0x98,0xa8,0x45,0xb2,0x85,0x38,0x76,0x4f,0x6c,
 0xbb,0x93,0x60,0xdb,0x0d,0xe4,0xd9,0x83,0x1d,0xe7,0x57,0x18,0x04,0x6f,0xb8,0x4c,
 0xec,0x88,0x9c,0x01,0x0c,0x47,0x66,0xac,0xa2,0x38,0x19,0x76,0x36,0x83,0xc3,0xf0,
 0xb4,0x5e,0x77,0x03,0xaf,0xf8,0x7b,0x13,0x77,0xad,0xd3,0xad,0x75,0x61,0xa5,0x54,
 0x02,0x27,0x45,0x02,0x00,0x3b
};


CSMainWin::CSMainWin(FXApp *a) :
    FXMainWindow(a,CLASSSTRING, NULL,NULL,DECOR_ALL,20,20) {
  app     = a;
  penguin = new FXGIFIcon(app,penguindata);

  if (LICENSETEXT == "gpl")
    LICENSETEXT = FXString("This program is free software;"
    " you can redistribute it and/or modify it\nunder the"
    " terms of the GNU General Public License (www.fsf.org)");

#ifdef APPLICATIONICON
  appicon = APPLICATIONICON;
#else
  appicon = new FXGIFIcon(app,csmily);
#endif
  setIcon(appicon);

  FXHorizontalFrame *statusbar=new FXHorizontalFrame(this,
       LAYOUT_SIDE_BOTTOM|LAYOUT_RIGHT|FRAME_SUNKEN|LAYOUT_FILL_X,
        0,0,0,0,0,0,0,0,0,0);

  new FXButton(statusbar,FXString("Exit ")+ CLASSSTRING, NULL,this,ID_QUIT,
       FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT);
  new FXLabel(statusbar,"", penguin,
       FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT);
  new FXButton(statusbar, " About ",       NULL,this,ID_ABOUT,
       FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT);

#ifdef NUMPLACEHOLDER
  for (int i=0; i<NUMPLACEHOLDER; i++)
    placeholder.push_back( new FXButton(statusbar, "", NULL,NULL,0,
			   FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_RIGHT) );
#else
#define NUMPLACEHOLDER 0
#endif

  label = new CSLabel(statusbar, " ", NULL,
       FRAME_THICK|FRAME_RAISED|LAYOUT_FILL|JUSTIFY_LEFT);

  klass = new CLASS;
}


// Start
void CSMainWin::create() {
  DBGENTER;
  FXMainWindow::create();  // Create windows
  DBGINFO(FXMainWindow was created);

#ifdef EXTRASETTINGS
  DBGSTAT;
  TRANS(CLASSNAME,klass)->readEntry();
#endif
  DBGSTAT;
  
  FXint w = app->reg().readIntEntry("SETTINGS","width", 800);
  FXint h = app->reg().readIntEntry("SETTINGS","height",600);
  FXint x = app->reg().readIntEntry("SETTINGS","XPos",  50);
  FXint y = app->reg().readIntEntry("SETTINGS","YPos",  50);
  position(x,y,w,h);
  //  resize(w,h);      // Reposition window
  show();               // Show  (PLACEMENT_SCREEN)
  DBGLEAVE;
}

// Quit
long CSMainWin::onCmdQuit(FXObject*,FXSelector,void*) {   DBGENTER;
#ifdef EXTRASETTINGS
  TRANS(CLASSNAME,klass)->writeEntry();
#endif
  app->reg().writeIntEntry("SETTINGS","width", getWidth());
  app->reg().writeIntEntry("SETTINGS","height",getHeight());
  app->reg().writeIntEntry("SETTINGS","XPos",  getX());
  app->reg().writeIntEntry("SETTINGS","YPos",  getY());

  app->exit(0);                                           DBGLEAVE;
  return 1;
}


// About box
long CSMainWin::onCmdAbout(FXObject*,FXSelector,void*) {
  string comstr = clh::compilerstr();

  FXMessageBox about(this,FXString("About ") +CLASSSTRING,
  CLASSSTRING + ascii2UTF8(" - c+ ") +
#if FOX_VERSION_NUMBER==16
    FXStringFormat
#else		
    FXString::value
#endif
    ("Clemens Schiff\n\n"
     "last modified:  %s\n"
     "first compiled: %s\n"
     "last compiled:  %s\n"
     "with %s\n\n"
     "based on FOX GUI Library Version %s (www.fox-toolkit.org)\n\n",
     moddate(1), moddate(3), moddate(2), comstr.c_str(),
     PACKAGE_VERSION) + EXTRAHELP + LICENSETEXT,
		     appicon, MBOX_OK|DECOR_TITLE|DECOR_BORDER);

  about.execute();
  return 1;
}

int CSMainWin::activatePlaHol(FXObject *obj, FXSelector sel, FXString txt) {
  static int w=0;
  if (w < NUMPLACEHOLDER) {
    placeholder[w]->setSelector(sel);
    placeholder[w]->setTarget(obj);
    placeholder[w]->setText(txt);
    ++w;
  }
  return w-1;
}
FXButton *CSMainWin::getButton(int i) {  // i may be w from above
  if (clh::inexBetween(i,0,NUMPLACEHOLDER)) return placeholder[i];
  return NULL;
}

/*
 *  ---  hier it starts ---
 */

#ifndef HAVE_MY_OWN_MAIN

int main(int argc,char *argv[]){
  DBGINIT;

  FXApp *app=new FXApp(CLASSSTRING,"CSPrograms"); // Make application
  app->init(argc,argv);                           // Open display

#ifdef PROCESS_ARGV
  CSMainWin *mawi = new CSMainWin(app);
  if (argc > 1) {
    TRANSFORM(CLASSNAME,mawi->getklass(),k);
    for (int n=1; n<argc; n++) k->process_argv(n,FXString(argv[n]));
  }
#else
  new CSMainWin(app);
#endif

  app->create();      // Resize and display main window
  DBGINFO(last line of main);
  return app->run();  // Run
}

#endif

