/* Foxcards - foxcards.cc
   Copyright (C) 2011 Clemens Schiff

   a collection of card games

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

// #define KAEFER 1
#include "fxclemens.h"

#include "foxhearts.h"    // begun in 2001
#include "foxspider.h"    // begun in 2004
#include "foxklondike.h"  // begun in 2011
#include "foxstreit.h"    // begun in 2013 -- not shown yet, see foxstreit.h

#define NUMPLACEHOLDER 5+STREIT  // must be equal ID_END-BASE
#include "csmainwin.h"

class Foxcards : public FXVerticalFrame {
  FXDECLARE(Foxcards)

public: // this is a final class, no need for protected etc


  enum{BASE = FXVerticalFrame::ID_LAST,
       ID_KLONDIKE, ID_HEARTS, ID_SPIDER, ID_KLONBIG,
#if STREIT==1
       ID_STREIT,
#endif
       ID_END, ID_DUM, ID_LAST};
  
  FXWindow *frame[ID_END-BASE]; // base class of all card tables
  int which;

  Foxcards( ) { }
  ~Foxcards() { } 
  Foxcards(FXApp *ap, FXComposite *p):
   FXVerticalFrame(p,FRAME_THICK|FRAME_NONE|LAYOUT_FILL, 0,0,0,0,0,0,0,0,0,0) {

    TRANSFORM(CSMainWin,p,mawi);
    // some space is claimed by mawi->Label that also has LAYOUT_FILL_X
    FXuint lout = mawi->getButton(0)->getLayoutHints();
    mawi->getButton(0)->setLayoutHints(lout|LAYOUT_FILL_X);
    mawi->activatePlaHol(this,Foxcards::ID_DUM,"   ");
    
#if STREIT==1
    mawi->activatePlaHol(this,Foxcards::ID_STREIT, " Streitpatience ");
#endif
    mawi->activatePlaHol(this,Foxcards::ID_KLONBIG, " Klondike 2 ");
    mawi->activatePlaHol(this,Foxcards::ID_KLONDIKE," Klondike 1 ");
    mawi->activatePlaHol(this,Foxcards::ID_SPIDER,  "    Spider    ");
    mawi->activatePlaHol(this,Foxcards::ID_HEARTS,  "    Hearts    ");

    DBGSTAT; frame[ID_SPIDER  -BASE] = new Foxspider  (ap,this,  LAYOUT_SIDE_TOP|LAYOUT_FILL);
    DBGSTAT; frame[ID_HEARTS  -BASE] = new Foxhearts  (ap,this,  LAYOUT_SIDE_TOP|LAYOUT_FILL);
    DBGSTAT; frame[ID_KLONBIG -BASE] = new Foxklondike(ap,this,2,LAYOUT_SIDE_TOP|LAYOUT_FILL);
    DBGSTAT; frame[ID_KLONDIKE-BASE] = new Foxklondike(ap,this,1,LAYOUT_SIDE_TOP|LAYOUT_FILL);
#if STREIT==1    
    DBGSTAT; frame[ID_STREIT  -BASE] = new Foxstreit  (ap,this,  LAYOUT_SIDE_TOP|LAYOUT_FILL);
#endif
    DBGSTAT; for (int i=1; i<ID_END-BASE; i++) frame[i]->hide();
  }

  void readEntry() { DBGENTER;
    which = getApp()->reg().readIntEntry("FoxCards","which",ID_HEARTS-BASE);
    TRANSFORM(Foxspider,frame[ID_SPIDER-BASE],spider);
    spider->readEntry();
  }
  void writeEntry() { DBGENTER;
    getApp()->reg().writeIntEntry("FoxCards","which",which);
    TRANSFORM(Foxspider,frame[ID_SPIDER-BASE],spider);
    spider->writeEntry();
  }

  long onCmdGame(FXObject *,  FXSelector s, void*) { DBGENTER;
    frame[which]->hide();
    which = FXSELID(s)-BASE;
    return 1;
  }

  long onUpdGame(FXObject *o, FXSelector s, void*) {
    FXuint msg=ID_UNCHECK;
    if (FXSELID(s) == BASE+which) {
      msg=ID_CHECK;
      if (!frame[which]->shown()) {frame[which]->show(); layout();}
    }
    o->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
    return 1;
  }
}; // end of class

// **************************************************************************** 

FXDEFMAP(Foxcards) FoxcardsMap[]={
  FXMAPFUNCS(SEL_COMMAND, Foxcards::BASE,Foxcards::ID_END, Foxcards::onCmdGame),
  FXMAPFUNCS(SEL_UPDATE,  Foxcards::BASE,Foxcards::ID_END, Foxcards::onUpdGame),
};
FXIMPLEMENT(Foxcards,FXVerticalFrame,FoxcardsMap,ARRAYNUMBER(FoxcardsMap))

// **************************************************************************** 

#include "fhearts.h"

#define APPLICATIONICON new FXGIFIcon(a,fhearts)
#define EXTRASETTINGS 1
#define CLASSNAME    Foxcards
#define CLASS  CLASSNAME(a,this)
static const FXString CLASSSTRING = "FoxCards";
static       FXString LICENSETEXT = "gpl";
static const FXString EXTRAHELP   = "Hearts algorithm from \"xhearts\" "
  "written by Mike Yang,\nDon Baccus, Jeff Hemmerling and Bob Ankeney\n\n";

#include "csmainwin.t"
