/* Foxhearts.cpp
   Copyright (C) 2001 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

// #define KAEFER 1
#include "fxclemens.h"
#include <random>
#include "cardface.h"
#include "foxhearts.h"
#include "penguin.h"
#include "fheartsd.h"
#include <ctype.h>

#define BORD 6
#define PASS 20
#define CW (CARD_WIDTH+4)
#define CH (CARD_HEIGHT+4)
#define BLUE FXRGB(0,165,255)
#define GOLD FXRGB(201,201,0)


FXDEFMAP(Foxhearts) FoxheartsMap[]={
  //________Message_Type_________ID_____________________Message_Handler_______
  FXMAPFUNC(SEL_CONFIGURE,     0,                   Foxhearts::onConfigure),
  FXMAPFUNC(SEL_COMMAND,       Foxhearts::ID_START, Foxhearts::onCmdStart),
  FXMAPFUNC(SEL_COMMAND,       Foxhearts::ID_CONTI, Foxhearts::onCmdConti),
  FXMAPFUNC(SEL_COMMAND,       Foxhearts::ID_NAME,  Foxhearts::onCmdName),
  FXMAPFUNC(SEL_TIMEOUT,       Foxhearts::ID_TIME,  Foxhearts::Control),
#ifdef WINREBUG
  FXMAPFUNC(SEL_TIMEOUT,       Foxhearts::WINRESIZE,Foxhearts::onConfigure),
#endif
 FXMAPFUNCS(SEL_COMMAND, Foxhearts::CARD0, Foxhearts::CARD12, Foxhearts::onCmdPlay),
};

// Macro for the Foxhearts class hierarchy implementation
FXIMPLEMENT(Foxhearts,FXHorizontalFrame,FoxheartsMap,ARRAYNUMBER(FoxheartsMap))


static int checkpoint(char suit, char rank) {DBGENTER;
 int m=0;
 if (suit=='h' || (suit=='s'&&rank=='Q') || (suit=='d'&&rank=='J')) m=1;
 return m;
}

static int convert(char suit, char rank) {DBGENTER;
  int r=0,s=0;

  switch(suit) {
    case 'c': case 'C': s=CLUB;    break;
    case 's': case 'S': s=SPADE;   break;
    case 'd': case 'D': s=DIAMOND; break;
    case 'h': case 'H': s=HEART;   break;
    default : return -3;  break;
  }
  switch(rank) {
    case 'A': r= 1; break;
    case '2': r= 2; break;
    case '3': r= 3; break;
    case '4': r= 4; break;
    case '5': r= 5; break;
    case '6': r= 6; break;
    case '7': r= 7; break;
    case '8': r= 8; break;
    case '9': r= 9; break;
    case 'T': r=10; break;
    case 'J': r=11; break;
    case 'Q': r=12; break;
    case 'K': r=13; break;
    default: return -3; break;
  }
  return WHICHFACE(s,r);
}

  /*
   *
   */

void Foxhearts::sortcards(void) {DBGENTER;
  int i,s,n, min,ii, k=0,g=0;
  char suit, rank, su=' ', ra=' ';
  char v[] = {'c','d','s','h'};
  char hu[28];
  for (ii=0;ii<13;ii++) posi[3][ii]=0;

  for (s=0; s<4; s++) {
    while (1) {
      min=1000;
      for (i=0; i<huca_num/2; i++) {
        if ( (suit=humancards[2*i+1]) == v[s] ) {
          rank = humancards[2*i];
          n=convert('c',rank); if (!n) n=C_NU; /* ace */
          if (n<min) { min=n; su=suit; ra=rank; ii=i; }
      } }
      if (min==1000) break;
      card[g]->setIcon(face[convert(su,ra)]); if (ii>12) posi[3][g]=2;
      hu[k++]=ra; hu[k++]=su;
      if (++g==13) goto end;
      humancards[2*ii+1]='#';
  } }
 end:
  for (i=0; i<26; i++) humancards[i]=hu[i];
}

// Start new game
long Foxhearts::onCmdStart(FXObject*,FXSelector,void*) {DBGENTER;
  int i,j;
  if (misum < 0) conti->setSelector(ID_CONTI);

  for (j=0; j<13; j++) {
    for (i=0;i<4;i++) posi[i][j]=0;
    comp0[j]->setIcon(peng); comp0[j]->show();
    comp1[j]->setIcon(peng); comp1[j]->show();
    comp2[j]->setIcon(peng); comp2[j]->show();
     card[j]->show();
  }

  heartsd_first_init();
  heartsd_init();
  nplay=pass=cards_per_round=misum=masum=shotthemoon=sumcon[17]=0;

  for (i=0;i<4;i++) {for (j=0;j<13;j++) posi[i][j]=0; }
  for (i=0;i<4;i++) spieler[i].init();
  UpdScore();
  ++nplay;
  scor[4]->setText(clh::fxnum2str(nplay)); aver[4]->setText(clh::fxnum2str(nplay));
  conti->setText("pass\n\n3 cards to\n\nHarpo");
  sortcards();
  Configure();

  return 1;
}

long Foxhearts::onCmdConti(FXObject*,FXSelector,void*) {DBGENTER;
  int i,j,ca[] = {0,0,0};

  switch (pass) {

  case 3:  // pass the cards
    j=0;
    for (i=0; i<13; i++) {
      if (posi[3][i]==2) {ca[j]=i; j++;}
    }
    heartsd_pass(ca[0],ca[1],ca[2]);
    sortcards();
    Configure();
    conti->setText("click to\n\nstart\n\nnew round");
    pass=4;
    break;

  case 4:  // accept cards
    for (j=0;j<13;j++) posi[3][j]=0;
    Configure();
    pass = 5;
    app->addTimeout(this,ID_TIME,100); block=1;
    break;

  case 9:  // play next round
    heartsd_init();
    ++nplay;
    scor[4]->setText(clh::fxnum2str(nplay)); aver[4]->setText(clh::fxnum2str(nplay));
    pass=cards_per_round=misum=masum=shotthemoon=sumcon[17]=0;
    for (j=0; j<13; j++) {
      for (i=0;i<4;i++) posi[i][j]=0;
      comp0[j]->setIcon(peng); comp0[j]->show();
      comp1[j]->setIcon(peng); comp1[j]->show();
      comp2[j]->setIcon(peng); comp2[j]->show();
       card[j]->show();
    }
    sortcards();
    name[0]->setText("Harpo");
    name[1]->setText("Groucho");
    name[2]->setText("Chico");
    name[3]->setText(username);
    Configure();

    switch (hand) {
    case 1: conti->setText("pass\n\n3 cards to\n\nHarpo"); break;
    case 2: conti->setText("pass\n\n3 cards to\n\nGroucho"); break;
    case 3: conti->setText("pass\n\n3 cards to\n\nChico"); break;
    default:
      heartsd_pass(ca[0],ca[1],ca[2]);
      pass = 5;
      app->addTimeout(this,ID_TIME,100); block=1;
      break;
    }
    break;

  default: break;
  }
  return 1;
}


// Play the game
long Foxhearts::onCmdPlay(FXObject*,FXSelector sel,void*) {DBGENTER;
  int y,s = FXSELID(sel) - CARD0;

  if (block) return 1; // timer is running

  if (pass<=3) {

    y = card[s]->getY();
    switch (posi[3][s]) {
    case 0:
      if (pass<3) {pass++; posi[3][s]=2; card[s]->setY(y-PASS);}
      break;
    case 2:
      pass--; posi[3][s]=0; card[s]->setY(y+PASS);
      break;
    default: break;
    }

  } else if (pass == 5) {

    huca_ind = 2*s;
    char su = humancards[huca_ind+1];
    char ra = humancards[huca_ind];
    if (heartsd_play(4)) {
      card[s]->move(play3x,play3y); card[s]->raise();
      if (checkpoint(su,ra)) sum[masum++]=card[s];
      posi[3][s]=1;
      cards_per_round++;
      y = slow;
      if (cards_per_round==4) {
        app->beginWaitCursor();
        y = speed;
        heartsd_play(-2); // get new leader
        FXString ss("next\nplayer:\n\n");
        switch (leader) { case 1: ss.append("Harpo");   break;
                          case 2: ss.append("Groucho"); break;
                          case 3: ss.append("Chico");   break;
                         default: ss.append(username);  break;
        } conti->setText(ss);
      }
      app->addTimeout(this,ID_TIME,y); block=1;
    } else {
      conti->setText("wrong\ncard\n\n--\n\nplay\nanother\none");
    }
  }
  return 1;
}


long Foxhearts::Control(FXObject*,FXSelector,void*) {DBGENTER;
  int i,j,m,next_player;

  block=0;

  if (cards_per_round == 0) {
    heartsd_play(-1);
    next_player=leader;
    if (leader==4 && ROund==1) {conti->setText("play\n\n2 of Clubs"); return 1;}
  } else {
    next_player = map_player(leader, cards_per_round);
  }

  if (cards_per_round < 4) {
    if (next_player==4) {conti->setText("play\n\na card"); return 1;}

    heartsd_play(next_player); cards_per_round++;
    next_player--;
    do { j=ZUFALL(13)-1; } while(posi[next_player][j]==-1);
    posi[next_player][j]=1;
    m=checkpoint(compsuit,comprank);

    switch(next_player) {
      case 0:
        comp0[j]->move(play0x,play0y); comp0[j]->raise();
        comp0[j]->setIcon(face[convert(compsuit,comprank)]);
	if (m) sum[masum++]=comp0[j];
	break;
      case 1:
        comp1[j]->move(play1x,play1y); comp1[j]->raise();
        comp1[j]->setIcon(face[convert(compsuit,comprank)]);
	if (m) sum[masum++]=comp1[j];
	break;
      case 2:
        comp2[j]->move(play2x,play2y); comp2[j]->raise();
        comp2[j]->setIcon(face[convert(compsuit,comprank)]);
	if (m) sum[masum++]=comp2[j];
	break;
      default: break;
    }
    i = slow;
    if (cards_per_round==4) {
      app->beginWaitCursor();
      i = speed;
      heartsd_play(-2); // get new leader
      FXString ss("next\nplayer:\n\n");
      switch (leader) { case 1: ss.append("Harpo");   break;
                        case 2: ss.append("Groucho"); break;
                        case 3: ss.append("Chico");   break;
                       default: ss.append(username);  break;
      } conti->setText(ss);
    }
    app->addTimeout(this,ID_TIME,i); block=1;

  } else {  // in this round all cards are played

    for (i=0; i<4; i++) {
      for (j=0; j<13; j++) {
        if (posi[i][j]==1) {
          if (i==0) comp0[j]->hide();
          if (i==1) comp1[j]->hide();
          if (i==2) comp2[j]->hide();
          if (i==3)  card[j]->hide();
          posi[i][j]=-1;
    } } }
    cards_per_round=0;

    for (i=misum; i<masum; i++) sumcon[i]=leader-1;
    misum=masum;
    app->endWaitCursor();

    m=0; 
    if (ROund < 13) {
      app->addTimeout(this,ID_TIME,slow); block=1;
    } else {
      heartsd_play(-3);
      sumcon[17]=2;
      UpdScore();
      Configure();
      conti->setText("press\n\nbutton\n\nto\n\ncontinue");
      pass = 9;
    }

    for (i=0; i<4; i++) {
      j = heartsd_pts_score(i);
      if (shotthemoon) { if (j<1) j=26+j; else j=j-26; }
      FXString ss=clh::fxnum2str(j);
      switch (i) { case 0: name[i]->setText("Harpo  "+ss);   break;
                   case 1: name[i]->setText("Groucho  "+ss); break;
                   case 2: name[i]->setText("Chico  "+ss);   break;
                  default: name[i]->setText(username+"  "+ss);  break;
    } }

  }
  return 1;
}

/*
 *
 */
#if ALLOW_CPP0X_LAMBDAS==0
static bool grospos(const Spieler &a, const Spieler &b) {return a.pos    < b.pos;}
static bool grosser(const Spieler &a, const Spieler &b) {return a.points < b.points;}
#endif

void Foxhearts::UpdScore(void) {DBGENTER;
  int s[4], aa=0;
  for (int j=0; j<4; j++) {s[j] = heartsd_score(j); aa += s[j];}
  aa /= 4;   // always integer
  for (int j=0; j<4; j++) spieler[j].calc(s[j],aa);

#if ALLOW_CPP0X_LAMBDAS==0
  std::sort(spieler.begin(),spieler.end(), grosser);
#else
  std::sort(spieler.begin(),spieler.end(), [](const Spieler &a, const Spieler &b) {return a.points < b.points;});
#endif
  int mini = spieler[0].points;

  for (int j=0; j<4; j++) {
    scor[j]->setText( clh::fxnum2str(spieler[j].points) );
    aver[j]->setText( clh::fxnum2str(spieler[j].money)+UTF8_EURO );
    // smin[j]->setText( "Min/Max "+clh::fxnum2str(spieler[j].minmon)+UTF8_EURO );
    // smax[j]->setText( clh::fxnum2str(spieler[j].maxmon)+UTF8_EURO );
    smin[j]->setText( "("+clh::fxnum2str(spieler[j].minmon)+UTF8_EURO+" "+clh::fxnum2str(spieler[j].maxmon)+UTF8_EURO +")");
    scna[j]->setText( spieler[j].name );
    scaa[j]->setText( spieler[j].name );

    if (spieler[j].points==mini && nplay>0) {scna[j]->setBackColor(GOLD);    scaa[j]->setBackColor(GOLD);}
    else                                    {scna[j]->setBackColor(defcolor);scaa[j]->setBackColor(defcolor);}
  }
#if ALLOW_CPP0X_LAMBDAS==0
  std::sort(spieler.begin(),spieler.end(), grospos);
#else
  std::sort(spieler.begin(),spieler.end(), [](const Spieler &a, const Spieler &b) {return a.pos < b.pos;});
#endif

  for (int j=0; j<4; j++) {
    if (spieler[j].points==mini && nplay>0) name[j]->setBackColor(GOLD); else name[j]->setBackColor(BLUE);
  }
}


long Foxhearts::onCmdName(FXObject*,FXSelector,void*) {DBGENTER;
  int i;
  for (i=0; i<4; i++) { if ( username==scna[i]->getText() ) break; }
  username = uname->getText();
  scna[i]->setText(username);
  name[3]->setText(username);
  return 1;
}

// set up the layout of the 4 decks
void Foxhearts::Configure() {
  int x,w,y,h;
  wid = table->getWidth()-6;
  hei = table->getHeight()-6;

  if (sumcon[17]==0) { // usual layout

  play1x=play3x=((wid-CW)/2);
  play0y=play2y=((hei-CH)/2);

  play0x=clh::maxof( (wid/2-3*CW /2-BORD) ,     (3*BORD+80+  CW) ); 
  play2x=clh::minof(((wid  +  CW)/2+BORD), (wid-(3*BORD+80+2*CW)));
  play1y=clh::maxof((hei/2-CH-BORD),     (3*BORD+20+  CH)); 
  play3y=clh::minof((hei/2   +BORD),(hei-(3*BORD+20+2*CH)));
#if 0
  // for small screens like my eeePC
  play0x=clh::minof(play0x, wid/2-CW);
  play2x=clh::maxof(play2x, wid/2);
  play1y=clh::minof(play1y, hei/2-CH);
  play3y=clh::maxof(play3y, hei/2);
#else
  if (hei < 4*CH) {
    play0x -= CW;
    play1x -= CW; play1y = clh::minof(play1y, hei/2-CH);
    play3x -= CW; play3y = clh::maxof(play3y, hei/2);
  }
#endif
  // computer 0 (left)
  h = (hei-(2*BORD+CH)*2-CH)/13;
  for (y=0;y<13;y++) {
    switch (posi[0][y]) { default: break;
    case 0: comp0[y]->move(BORD, y*h + 2*BORD+CH); comp0[y]->raise(); break;
    case 1: comp0[y]->move(play0x,play0y);         comp0[y]->raise(); break;
  } }
  name[0]->move(2*BORD+CW,hei/2);

  // computer 2 (right)
  w = wid - BORD - CW;
  for (y=0;y<13;y++) {
    switch (posi[2][y]) { default: break;
    case 0: comp2[y]->move(w, y*h + 2*BORD+CH); comp2[y]->raise(); break;
    case 1: comp2[y]->move(play2x,play2y);      comp2[y]->raise(); break;
  } }
  name[2]->move(wid-2*BORD-CW-80,hei/2);

  // computer 1 (top)
  w = (wid-40)/14;
  for (x=12;x>-1;x--) {
    switch (posi[1][x]) { default: break;
    case 0: comp1[x]->move(20+x*w, BORD);  comp1[x]->raise(); break;
    case 1: comp1[x]->move(play1x,play1y); comp1[x]->raise(); break;
  } }
  name[1]->move(wid/2-40,2*BORD+CH);

  // human (bottom)
  h = hei-BORD-CH;
  for (x=0;x<13;x++) {
    switch (posi[3][x]) { default: break;
    case 0: card[x]->move(20+x*w, h);     card[x]->raise(); break;
    case 1: card[x]->move(play3x,play3y); card[x]->raise(); break;
    case 2: card[x]->move(20+x*w,h-PASS); card[x]->raise(); break;
  } }
  name[3]->move(wid/2-40,hei-2*BORD-CH-20);

    // ---------------------------------------------
  } else {  // layout when points are displayed
    // ---------------------------------------------

    int j;
    w = (wid-40)/17;
    h = (hei-2*BORD)/4;
    y=BORD;
    for (int player=0; player<4; player++) {
      x=BORD;
      j=0;
      for (int ca=0; ca<masum; ca++) {
        if ( sumcon[ca] == player ) {
          sum[ca]->move(x,y); x+=w; j++;
          sum[ca]->show(); sum[ca]->raise();
	}
      }
// one criteria: 1 player needs to have at least 14 cards (and maybe jack of dia.)
      if (j>13) shotthemoon++;
      name[player]->move(BORD,y+CH/2-10); name[player]->raise();
      y+=h;
    }

    if (shotthemoon) {
      for (int player=0; player<4; player++) {
        j = heartsd_pts_score(player);
// next criteria: 3 players must have 0 or -10 points
        if (j==0 || j==-10) shotthemoon++;
      }
      if (shotthemoon!=4) shotthemoon=0;
    }

  } // endif
}

// Widget has been resized
#ifdef WINREBUG
long Foxhearts::onConfigure(FXObject*,FXSelector sel,void*) {DBGENTER;
  if (FXSELID(sel)==WINRESIZE) {
#else
long Foxhearts::onConfigure(FXObject*,FXSelector,void*) {
#endif
    Configure();
#ifdef WINREBUG
  } else {
    app->addTimeout(this,WINRESIZE,50);
  }
#endif
  return 1;
}


// // About box
// long Foxhearts::onCmdAbout(FXObject*,FXSelector,void*){
//   FXMessageBox about(this,"About FoxHearts",
// #if FOX_VERSION_NUMBER==16
//     FXStringFormat(
// #else
//     FXString::value(
// #endif
//  "FoxHearts - by Clemens Schiff\n\nlast modified: %s\nlast compiled: %s\n\nbased on code from Mike Yang, Don Baccus, Jeff Hemmerling, Bob Ankeney\nand on FOX GUI Library Version %s (www.fox-toolkit.org)\n\nThis program is free software; you can redistribute it and/or modify it\nunder the terms of the GNU General Public License (www.fsf.org)",moddate(1),moddate(2),VERSION),
//   NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
//   about.execute();
//   return 1;
// }


// Construct a Foxhearts
Foxhearts::Foxhearts(FXApp *appli, FXComposite *p,
         FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
         FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
  FXHorizontalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {  DBGENTER;

  int i;
  FXVerticalFrame *buttonFrame;

  // needed as in fheartsd.c++ a pre C++11 random generator is used
  srand(static_cast<unsigned int>(time(NULL)%RAND_MAX));
  
  app=appli;
  peng = new FXGIFIcon(app,bigpenguin);

  // table to put the cards on
  table=new FXHorizontalFrame(this,
     LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT|FRAME_SUNKEN|FRAME_RIDGE,
     0,0,0,0, 0,0,0,0);
  table->setBackColor(FXRGB(0,200,0));

  DBGSTAT; cardface(app);  // create the cards from the old spider bitmaps

  opts=FRAME_THICK|FRAME_RAISED|LAYOUT_EXPLICIT;
  for (i=0;i<13;i++) {
    LOOP(j,4) posi[j][i]=0;
  // player's cards
     card[i] = new FXButton(table,"",peng,this,CARD0+i,opts, 0,0,CW,CH);
     card[i]->setDefaultCursor(app->getDefaultCursor(DEF_CROSSHAIR_CURSOR));
  // computer cards
    comp0[i] = new FXLabel(table,"",peng,opts, 0,0,CW,CH);
    comp1[i] = new FXLabel(table,"",peng,opts, 0,0,CW,CH);
    comp2[i] = new FXLabel(table,"",peng,opts, 0,0,CW,CH);
  }

  // names
  DBGSTAT; std::string sS = USER(true);
  if (sS=="") username = "Zeppo"; else username = FXSTRING(sS);

  spieler.push_back( Spieler(FXString("Harpo"),   1) );
  spieler.push_back( Spieler(FXString("Groucho"),12) );
  spieler.push_back( Spieler(FXString("Chico"),  23) );
  spieler.push_back( Spieler(username,           94) );

  for (i=0; i<4; i++)
    name[i] = new FXLabel(table,spieler[i].name,  NULL,JUSTIFY_CENTER_X|LAYOUT_EXPLICIT, 0,0,80,20);

  // -------------- RIGHT pane for the buttons  ---------------------

  buttonFrame=new FXVerticalFrame(this,
     LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);

  FXVerticalFrame *con3=new FXVerticalFrame(buttonFrame,
       LAYOUT_TOP|FRAME_RIDGE|LAYOUT_FILL_X);
  new FXLabel(con3,"your name",NULL,JUSTIFY_LEFT|LAYOUT_FILL_X|LAYOUT_TOP);
  uname = new FXTextField(con3,-1,this, ID_NAME ,
             LAYOUT_TOP|LAYOUT_RIGHT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);
  uname->setText(username);

  FXTabBook *tabbook=new FXTabBook(buttonFrame, NULL,0,
      TABBOOK_TOPTABS|LAYOUT_FILL_X|FRAME_SUNKEN);
  new FXTabItem(tabbook," Score ");
  DBGSTAT;

  // Scores
  FXMatrix *Sco = new FXMatrix(tabbook,2,
     LAYOUT_FILL|LAYOUT_TOP|LAYOUT_LEFT|MATRIX_BY_COLUMNS|FRAME_RIDGE,
     0,0,0,0,10,10,10,10);

  /**/      new FXLabel(Sco,"Game:",NULL,JUSTIFY_LEFT);
  scor[4] = new FXLabel(Sco,"-",NULL,JUSTIFY_RIGHT|MATRIX_FILL_X);
  new FXHorizontalSeparator(Sco);
  new FXLabel(Sco,"",NULL,JUSTIFY_RIGHT|MATRIX_FILL_X);

  for (i=0; i<4; i++) {
    scna[i] = new FXLabel(Sco,"-",NULL,JUSTIFY_LEFT);
    scor[i] = new FXLabel(Sco,"-",NULL,JUSTIFY_RIGHT|MATRIX_FILL_X);
  }

  new FXTabItem(tabbook," Money ");
  FXMatrix *Mon = new FXMatrix(tabbook,2,
     LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT|MATRIX_BY_COLUMNS|FRAME_RIDGE,
     0,0,0,0,10,10,10,10);
  /**/      new FXLabel(Mon,"Game:",NULL,JUSTIFY_LEFT);
  aver[4] = new FXLabel(Mon,"-",NULL,LAYOUT_RIGHT|JUSTIFY_RIGHT);
  new FXHorizontalSeparator(Mon); new FXHorizontalSeparator(Mon);

  for (i=0; i<4; i++) {
    scaa[i] = new FXLabel(Mon,"-",NULL,JUSTIFY_LEFT);
    aver[i] = new FXLabel(Mon,"-",NULL,LAYOUT_RIGHT|JUSTIFY_RIGHT);
    smin[i] = new FXLabel(Mon," ",NULL,LAYOUT_RIGHT|JUSTIFY_RIGHT);
    smax[i] = new FXLabel(Mon," ",NULL,LAYOUT_RIGHT|JUSTIFY_RIGHT);
  }

  DBGSTAT;
// Button to start
  new FXButton(buttonFrame,"new game",NULL,this,ID_START,
    FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,5,5);

  conti = new FXButton(buttonFrame,
        "press\n\nbutton\n\nto start\n\ngame",NULL,this,
        ID_START, // at first (misum<0) this button starts the game
	FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y,
	0,0,0,0,10,10,5,5);
  conti->setDefaultCursor(app->getDefaultCursor(DEF_ROTATE_CURSOR));

  defcolor=getBackColor();

  speed=2000*TIMEOUTFAK; // the delay when all 4 cards are displayed
  slow=100*TIMEOUTFAK;
  misum=-5; sumcon[17]=0;
  block=0;

  UpdScore();
  DBGLEAVE;
}

