#ifndef FOXHEARTS_H
#define FOXHEARTS_H

#ifdef WIN32
// strange, but necessary (fox 1.2.11)
// still necessary with fox 1.7.19
#define WINREBUG 1
#endif

class Spieler { // german for player
public:
  FXString name;
  int points, money, minmon, maxmon, pos;
  Spieler(const FXString n, const int o) : name(n), pos(o) {init();}
  void init() {points=money=minmon=maxmon=0;}
  void calc(const int p, const int a) {
    points = p;
    money  = a - p;
    minmon = clh::minof(money,minmon);
    maxmon = clh::maxof(money,maxmon);
  }
};

class Foxhearts : public FXHorizontalFrame {
  FXDECLARE(Foxhearts)

private:
  FXHorizontalFrame  *table;
  FXApp       *app;
  FXButton    *card[13], *conti;
  FXGIFIcon   *peng;
  FXLabel     *comp0[13],*comp1[13],*comp2[13], *sum[15];
  FXLabel     *name[4], *scor[5], *scna[4],   *scaa[4],*aver[5], *smin[4],*smax[4];
  FXString    username;
  FXTextField *uname;
  FXColor     defcolor;

  int wid,hei,pass,cards_per_round,speed,slow,nplay,
      misum,masum,sumcon[18];
  int play0x,play0y,play1x,play1y,play2x,play2y,play3x,play3y;
  int shotthemoon,block,posi[4][13];
  std::vector<Spieler> spieler;  // german for player

public:
  enum{
    ID_START=FXHorizontalFrame::ID_LAST,
    ID_CONTI,
    ID_NAME, ID_TIME, WINRESIZE,
    CARD0,CARD1,CARD2,CARD3,CARD4,CARD5,CARD6,CARD7,
    CARD8,CARD9,CARD10,CARD11,CARD12,CARD13,
    ID_LAST
    };

public:
  // Message handlers
  long onConfigure(FXObject*,FXSelector,void*);
  long onCmdStart(FXObject*,FXSelector,void*);
  long onCmdPlay(FXObject*,FXSelector,void*);
  long onCmdConti(FXObject*,FXSelector,void*);
  long onCmdName(FXObject*,FXSelector,void*);
  long Control(FXObject*,FXSelector,void*);

  void sortcards(void);
  void Configure(void);
  void UpdScore(void);

private:
  Foxhearts() { }         // Foxhearts constructor
public:
  Foxhearts(FXApp *appli, FXComposite *p,
         FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  ~Foxhearts() { } // Foxhearts  destructor
};

#endif
