/* Foxklondike.cc
   Copyright (C) 2011 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define KAEFER 0
#define WITH_BESTLIST 0
#include "fxclemens.h"

#include "cardface.h"
#include "foxklondike.h"
#if WITH_BESTLIST==1
#include "bestlist.h"
#endif

FXDEFMAP(Foxklondike) FoxklondikeMap[]={
  FXMAPFUNC (SEL_COMMAND, Foxklondike::ID_TURN, Foxklondike::onCmdTurn),
};
FXIMPLEMENT(Foxklondike,Patience,FoxklondikeMap,ARRAYNUMBER(FoxklondikeMap))


// Construct a Foxklondike
Foxklondike::Foxklondike(FXApp *appli,
	 FXComposite *main, const int ndeck,
         FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
			 FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
Patience(appli,main,3+4*ndeck,40,ndeck*C_NU,opts,x,y,w,h,pl,pr,pt,pb,hs,vs), NDECK(ndeck) {

  LOOP(i,4) red[i]=black[i]=false;
  black[CLUB]  = true;
  black[SPADE] = true;
  red[HEART]   = true;
  red[DIAMOND] = true;

  capoi.resize( C_NU*NDECK, 0);
  outcol.resize(4*NDECK, HEART);
  if (ndeck==1) {
    outcol[1]=CLUB;
    outcol[2]=DIAMOND;
    outcol[3]=SPADE;
  } else {
    outcol[2]=CLUB;
    outcol[3]=CLUB;
    outcol[4]=DIAMOND;
    outcol[5]=DIAMOND;
    outcol[6]=SPADE;
    outcol[7]=SPADE;
  }

  turn = new FXButton(table,"turn\nthe\nstack",NULL,this,ID_TURN,
		      FRAME_RAISED|LAYOUT_EXPLICIT, 0,0, CW-8, CH-8);
  turn->setBackColor(FXRGB(220,220,0));
  turn->move(9, 14);  // instead of move(5, 10);

  lab_points = new FXLabel(table,"",NULL,
			    FRAME_RAISED|LAYOUT_EXPLICIT, 0,0, CW, 50);
  lab_points->setBackColor(FXRGB(220,20,0));

  // -------------- TOP pane for the buttons  ---------------------

  opts=FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|JUSTIFY_NORMAL|ICON_BEFORE_TEXT;

  FXButton *fbun =
  new FXButton(buttonFrame,"start again",NULL,this,Patience::ID_RESTART,opts,0,0,0,0,0,0,0,0);
  /// cards will not be layed out as in shuffle
  fbun->disable();  // totally buggy, should be fixed

  new FXButton(buttonFrame,"view moves", NULL,this,Patience::ID_REPLAY, opts,0,0,0,0,0,0,0,0);
  new FXButton(buttonFrame,"new",        NULL,this,Patience::ID_START,  opts,0,0,0,0,0,0,0,0);
  new FXButton(buttonFrame,"backup",     NULL,this,Patience::ID_BACK,   opts,0,0,0,0,0,0,0,0);
}

void Foxklondike::create() {
  Patience::create();
  shuffle(); Configure();
}


void Foxklondike::shuffle() {
  cardsfromstack = 0;
  turn->show();
  capoi.assign(C_NU*NDECK,0); // lab_points->setText("0");
  Carry<int> fa(0, NCARDS,2);
  int  n,w,r,s;

  for (int i=0; i<NCARDS; i++) {
    do { n = ZUFALL(NCARDS)-1; } while (fa(n,0) == 22);
    fa(n,0) = 22; // set card n
    while (1) {
      s = ZUFALL(NCARDS)%4;
      r = ZUFALL(NCARDS)%13 +1;
      w = WHICHFACE(s,r); // s r for card n
      if (fa(w,1) < NDECK) {
	card[n]->init();
 	card[n]->setrank(r);  // begins at 1
 	card[n]->setsuit(s);  // begins at 0
 	card[n]->setdeck(fa(w,1));  // backcolor 0 or 1
 	++fa(w,1);
 	break;
  } } }

  w=0;
  for (int i=0; i<NCOL; i++) {    // put the cards on the table
    LOOP(j,i+1) {
      do { n = ZUFALL(NCARDS)-1; } while (fa(n,0) != 22);
      fa(n,0) = 33;
      w++;
      card[n]->setrow( j );
      card[n]->setcolumn( i );
  } } 

  s=0;
  while (w < NCARDS) { // put the rest on the stack
    do { n = ZUFALL(NCARDS)-1; } while (fa(n,0) != 22);
    fa(n,0) = 44;
    card[n]->setrow( --s );
    card[n]->setcolumn( 0 );  // all cards on column 0
    card[n]->setmaymove(1);
    ++w;
  }
}

long Foxklondike::onCmdTurn(FXObject*, FXSelector, void*) {
  int num=0;
  for (int n=0; n<NCARDS; n++)  {  // new numbering
    if (card[n]->getpos()==Fsbutton::STACK) {
      card[n]->setrow(--num);
      card[n]->setopen(0);
  } }
  messa->setText("ok");  
  Configure();
  return 1;
}


// set up the layout of the cards
void Foxklondike::Configure(int push) {
  Patience::Configure(push);
  lab_points->move( 5+2*(CW+wid), 14);

  int num=0, cs=-8;
  for (int j=NC-1; j>-1; j--) {
    int n = column(0,j,Fsbutton::STACK);
    if (n > NIL) {
      num++;
      if (card[n]->getopen()==1) {
	cs=n; // highest card on stack
	card[n]->move(5+CW+wid, 10);
	card[n]->raise();
      } else {
	card[n]->move(5, 10);
      }
  } }
  if (turn->shown() && num==0) turn->hide(); // stack is empty

  onHelp(cs);
  if (push==0) return;

  ///------ automatic removal of cards

  num=13;
  for (int i=0; i<4*NDECK; i++) {
    int j = column(i,NC,Fsbutton::OOT);
    if (j>0) {
      int n = column(i,j-1,Fsbutton::OOT);
      num = clh::minof(num,card[n]->getrank());
    } else num=0;
  }
  num++; // is the highset removable rank
  // num += 2;

  
  int points   = 0;
  int cardsout = 0;
#if WITH_BESTLIST==1
  int p = (NDECK==1 ? 2:1);
#else
  int p = 1;
#endif
  for (int i=0; i<NDECK*C_NU; i++) {
    if (capoi[i]>0) {
      cardsout++;
      if (capoi[i]==2) points += p; // else points+=2;
  } }
  lab_points->setText(clh::fxnum2str(cardsfromstack) + "/" + clh::fxnum2str(points));

  for (int i=0; i<NCOL; i++) {
    int j = column(i,NC,Fsbutton::GAME);
    if (j>0) {
      int n  = column(i,j-1,Fsbutton::GAME);
      if (autoout(n, num)) {   // if (card[n]->getrank()<=num) {
  	card[n]->setbutton(RIGHTBUTTON);
	capoi[n] = 1;
	app->addTimeout(this,CARD0+n,400*TIMEOUTFAK);
	return;
  } } }
  if (cs>-1) {  // card on stack
    if (autoout(cs, num)) {  //  if (card[cs]->getrank()<=num) {
      card[cs]->setbutton(RIGHTBUTTON);
      capoi[cs] = 1;
      app->addTimeout(this,CARD0+cs,400*TIMEOUTFAK);
      return;
  } }

#if WITH_BESTLIST==1
  if (cardsout == NDECK*C_NU) {
    Bestlist *bestlist = new Bestlist(app,"Klondike"," Points "," No. of Decks ");
    bestlist->kontrolle(-points,NDECK,Bestlist::ENGLISH);
    bestlist->zeige();
    delete bestlist;
  }
#endif
}


///////////////////////////////////////////////////////////////

void Foxklondike::onHelp(const int cs) {
  if (cs>-1) { // highest card on stack
    int ra = card[cs]->getrank();
    int su = card[cs]->getsuit();
    for (int i=0; i<NCOL; i++) {
      if ( fitsincol(i,su,ra) ) {  // new place found
	helper[i]->setBackColor(FXRGB(0,200,200));
    } }
  }

  for (int i=0; i<NCOL; i++) {
    if (column(i,NC,Fsbutton::GAME)==0) continue; // empty
    int su=0,ra=0;
    for (int k=column(i,NC,Fsbutton::GAME)-1; k>-1; k--) {
      if (card[column(i,k,Fsbutton::GAME)]->getmaymove()) {
	su = card[column(i,k,Fsbutton::GAME)]->getsuit();
	ra = card[column(i,k,Fsbutton::GAME)]->getrank();
	if (k==0 && ra==13) goto its_a_king;
    } }
    for (int j=0; j<NCOL; j++) {
      if (i==j) continue;
      if ( fitsincol(j,su,ra) ) helper[i]->setBackColor(FXRGB(250,125,0));
    }
  its_a_king:;
  }
}

bool Foxklondike::autoout(const int n, const int num) {
  int ra = card[n]->getrank();
  if (ra <= num) return true;

  if (NDECK == 1) {
    for (int m=0; m<4; m++) {
      if (outcol[m] == card[n]->getsuit()) {
	if (ra == num+1 && num == column(m,NC,Fsbutton::OOT) ) return true;
	break;
    } }
  } else {
    std::array<int,2> ww;
    int ii =0;
    for (int m=0; m<4*NDECK; m++) {
      if (outcol[m] == card[n]->getsuit()) ww[ii++] = m;
    }
    // beide asse muessen da sein
    if (ra == num+1 && num <= column(ww[0],NC,Fsbutton::OOT) && num <= column(ww[1],NC,Fsbutton::OOT))  return true;
    
  }
  return false;
}

bool Foxklondike::putcardout(int nu, int ra, int su) {
  if (card[nu]->getopen()==0) return false;
  for (int m=0; m<4*NDECK; m++) {
    if (outcol[m]==su) {
      if (column(m,NC,Fsbutton::OOT)==ra-1) {
        card[nu]->setcolumn(-(m+1));
        card[nu]->setrow(ra-1);
        return true;
  } } }
  return false;
}

bool Foxklondike::fitsincol(int c, int su, int ra) {
  int r = rowincolumn(c,Fsbutton::GAME);
  if (r==0) {  // empty slot
    if (ra==13) return true; else return false; // ok for king
  }
  int nn = column(c,r-1,Fsbutton::GAME);
  if (card[nn]->getrank()-1 == ra) {
    int s = card[nn]->getsuit();
    return ((red[s] && black[su]) || (red[su] && black[s]));
  }
  return false;
}

/* -------- */

void Foxklondike::playCard(int nu) {
  int pos      =  card[nu]->getpos();
  int ra       =  card[nu]->getrank(); // 1,2,3,...,13
  int su       =  card[nu]->getsuit(); // 0,1,2,3
  int startcol =  card[nu]->getcolumn();
  int startrow =  card[nu]->getrow();
  int endcol   = (card[nu]->getX() + CW/2)*NCOL / tabwid;

  FXString errmsg="cannot move card";
  if (card[nu]->getmaymove() == 0) goto failure;

  if (card[nu]->getButton() == RIGHTBUTTON) { // put card out
    if (putcardout(nu,ra,su)) {++capoi[nu]; goto success;}
    goto failure;
  }

  if (pos==Fsbutton::STACK && card[nu]->getopen()==0) { // get new card from the stack
    card[nu]->setopen(1);       ++cardsfromstack;
    goto success;
  }

  if (pos==Fsbutton::STACK) {
    if (card[nu]->getY() < CH+20 +4) {  // card is clicked only
      for (int m=0; m<NCOL; m++) {
        if ( fitsincol(m,su,ra) ) {  // new place found
  	  card[nu]->setrow(column(m,NC,Fsbutton::GAME));
          card[nu]->setcolumn(m);
	  goto success;
      } }
      errmsg = "nowhere to move "+cardname(su,ra);
      goto failure;
    }
    if ( fitsincol(endcol,su,ra) ) {   // card was placed by user
      card[nu]->setrow(column(endcol,NC,Fsbutton::GAME));
      card[nu]->setcolumn(endcol);
      goto success;
    }
    errmsg = "move not possible";
    goto failure;
  }

  if (endcol == startcol) {  // card is clicked, see where we can place it
    endcol = NIL;
    for (int m=0; m<NCOL; m++) {
      if (m==startcol) continue;
      if ( fitsincol(m,su,ra) ) {endcol=m; break;}
    }
    if (endcol==NIL) {
      messa->setText("nowhere to move "+cardname(su,ra));
      goto failure;
    }
  }

  if (startcol != endcol) {    // card was placed by user (or clicked)
    if ( fitsincol(endcol,su,ra) ) {
      int i,k=0,j=rowincolumn(endcol);
      while ( (i=cardinrowcol(startrow,startcol,pos)) > NIL ) {
	card[i]->setrow(j+k);
        card[i]->setcolumn(endcol);
	startrow++; k++;
      }
      goto success;
    }
  }
  errmsg = "move not possible";
  goto failure;

success:
  messa->setText("ok");
  Configure();
  return;

 failure:
  messa->setText(errmsg);
  Configure(0);
}

