
/*  FoxMapH - Clemens Schiff 2005

   better do not use C style comments in file <>.fm
   every line with FXMAPFUNC must be finished by  ),

---------------------------------------------------------------------------

   The program might have good chances of winning at
   The International Obfuscated C Code Contest
   but nevertheless is useful: no more need to maintain the message ID in
   an enum and to define any message handler in a <>.h file

   foxmaph reads the macros FXDEFMAP and FXIMPLEMENT that now have to be
   in a seperate file <>.fm From this it generates a file <>.fh that should
   be included in <>.h

---------------------------------------------------------------------------

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a kopy of the GNU General Public License
   along with this program; if not, see:  http://www.fsf.org
*/

// #define LINELENGTH 10000
#include "clemens.h"
#include "cocain.h"



string remove_blanks_and_cpp_comments(string ss) {
  ss += " ";
  string tt="";
  for (size_t i=0; i<ss.size(); i++) {
    if (ss[i]=='/' && ss[i+1]=='/') break;
    if (ss[i]!=' ') tt += ss[i];
  }
  return tt;
}


int main(int argc, char *argv[]) {
  if (argc<2) {
    printf("WARNING in FOXMAPH: arguments expected\n");
    return 0;  // not always wrong
  }

  int iarg=0;
  while (++iarg < argc) {  // ZWERG(argv[iarg]);

    string     infile = clh::getfname(string(argv[iarg])) + ".fm";
    string     oufile = clh::getfname(infile)             + ".fh";
    clh::fileAttrib infiat(infile);
    clh::fileAttrib oufiat(oufile);

    if (infiat.empty()) continue;  // i.e. infiat has a time stamp != 0
    if (infiat.get_moditime() <= oufiat.get_moditime()) continue; // nothing to do, infile younger/equal outfile

    ///--------------------------------------------------------------------
    
#if MINGW==1
    string tmfile = clh::mktmpdir(clh::replace(oufile,"/:\\",'O'));
    std::ofstream outf(tmfile, std::ofstream::out);
#else
    std::ofstream outf(oufile, std::ofstream::out);
#endif
    Cocain coca(infile,'C');
    bool first = true;
    string st  = "o";
    
    ///--------------------------------------------------------------------

    while (st != "EOF") {
      int s1, s2, cs=0;
      string tt, impl="", clas="", def="";
      std::vector<string> ids, fun;
      
      ///--------------------------------------------------------------------

      while ( (st = coca.read()) != "EOF") {  // ZWERG(st);
	if (st.size() < 1) continue;

	if (st[0] == '#') {  // may contain preprocessor directives
	  if (clh::substrcompa(st,1,"elif",true)) {def = "\n" + st + "\n"; break;}
	  if (clh::substrcompa(st,1,"else",true)) {def = "\n" + st;        break;}
	  if (clh::substrcompa(st,1,"endi",true)) {def =        st;        break;}
	  outf << st << endl;
	  continue;
	}
	tt = remove_blanks_and_cpp_comments(st);

	// look for keywords
	if (tt.substr(0,9) == "FXMAPFUNC") {
	  while (1) {  //  continuation lines...
	    if (tt.substr( tt.size()-2, 2) == "),") break;
	    tt += remove_blanks_and_cpp_comments( coca.read() );
	  }
	  // get name of message handler (i.e. funtion prototype)
	  // FXMAPFUNC(SEL_COMMAND,Vivi::ID_ABOUT,Vivi::onCmdAbout),
	  s1 = tt.find_last_of(":") + 1;
	  s2 = tt.find_last_of(")");
	  // function must be part of class
	  if (tt.substr(s1-cs-2,cs)==clas) fun.push_back(tt.substr(s1, s2-s1));

	  if (tt[9]=='(') {  // single fxmapfunc
	    // isolate the ID (this might be a constant number (typically 0))
	    tt.erase(s1-2); //  FXMAPFUNC(SEL_COMMAND,Vivi::ID_ABOUT,Vivi
	    s1 = tt.find_last_of(":");
	    if (static_cast<string::size_type>(s1) != string::npos) {
	      s1++;
	      s2 = tt.find_last_of(",");  // enum must be part of class
	      if (tt.substr(s1-cs-2,cs)==clas) ids.push_back(tt.substr(s1, s2-s1));
	    }

	  } else { // fxmapfuncs ( may contain additional id between /*  */ )
	    // isolate first ID (this should never be a constant number)
	    s1 = 2 + tt.find_first_of(":");
	    s2 = tt.find_first_of(",",s1);
	    if (tt.substr(s1-cs-2,cs)==clas) ids.push_back(tt.substr(s1, s2-s1));

	    // now the c comment might follow
	    s1 = tt.find("/*",s2);
	    if (static_cast<string::size_type>(s1) != string::npos) {
	      s1 += 2;
	      int s3 = tt.find("*/",s1);
	      while (s1<s3) {
		s2 = clh::minof(s3, static_cast<int>(tt.find_first_of(",",s1)));
		ids.push_back(tt.substr(s1, s2-s1));
		s1 = s2+1;
	      } }
	    s1 = 2 + tt.find_first_of(":",s2);
	    s2 = tt.find_first_of(",",s1);
	    if (tt.substr(s1-cs-2,cs)==clas) ids.push_back(tt.substr(s1, s2-s1));
	  }
	}

	else if (tt.substr(0,10)=="/*EXTRA_ID") {
	  /*EXTRA_IDID_HELP,ID_HELP_SONDER,ID_HELP_DATEI,ID_HELP_ALLGEM,*/
	  s1 = s2 = 10;
	  bool ok=true;
	  while (ok) {
	    switch(tt[s2]) {
	    case '*': ok=false; if (s2-s1<2) break; // else fallthru
	    case ',': ids.push_back(tt.substr(s1, s2-s1)); s1=s2+1; break;
	    default:  break;
	    }
	    s2++;
	  }
	}

	else if (tt.substr(0,8) == "FXDEFMAP") { // get class name
	  cs   = tt.find(")") - 9;
	  clas = tt.substr(9, cs);
	}

	else if (tt.substr(0,11) == "FXIMPLEMENT") {
	  s1 = tt.find_first_of(",") + 1;
	  s2 = tt.find_last_of(","); tt.erase(s2-1);
	  s2 = tt.find_last_of(",");
	  impl = tt.substr(s1, s2-s1);
	  // break;  // it is the last line
	}
      }

      ///--------------------------------------------------------------------

      if (impl.size() > 1 && clas.size()) {      
	if (first ) {
	outf << "/* File generated by FoxMapH from \"" << infile << "\" */" << endl;
	outf << "// necessary for FOXs message handling"  << endl;
	first = false;
	}
	outf << "FXDECLARE(" << clas << ")"      << endl;
	outf << "protected: "<< clas << "() { }" << endl;

	// do not sort ids - their sequence typically matters
	// sort(ids.begin(),ids.end());
	std::vector<string> eds;
	for (const auto &i : ids) {
	  for (const auto &e : eds) {if (i == e) goto found;}
	  eds.emplace_back(i);
	found:;
	}
	int k=0;
	outf << "public:\n enum{ ID_FIRST=" << impl << "::ID_LAST,\n  ";
	for (size_t i=0; i<eds.size(); i++) {
	  outf << " " << eds[i] << ",";
	  if (++k==6) {k=0; outf << "\n  ";}
	}
	outf << " ID_LAST};\n   /* message handlers */"  << endl;
    
	clh::unique(fun, false,false);
	for (const auto &f : fun) outf << "   long " << f << "(FXObject *obj, FXSelector sel=0, void *ptr=nullptr);"  << endl;

	outf << "\n  "
	     << "static_assert("                            // <FXSelector> too large for case labels
	     << "static_cast<unsigned long long>(std::numeric_limits<int>::max())"
	     << " > \n                "
	     << "static_cast<unsigned long long>(" << clas << "::ID_LAST), "
	     << "\"enum in " << oufile << " is too large\");"
	     << endl;
      }
      
      outf << def  << endl;

    }  ///--------------------------------------------------------------------

    outf.close();
#if MINGW==1
    clh::kopie(tmfile, oufile, 1);   // get rid of \r\n
#endif
    // both in and ou file get the same time stamp
    infiat.modifyOtherTime(oufile);
  }
  return 0;
}

