# -*- makefile -*-

include basics.makefile

#$#TGZ# basics.makefile
#$#TGZ# foxmaph.c++ moddate.c++ exfoxdefin.c++
#$#TGZ# cocain.c++ cocain.h clemens.h clemiler.h
#$#TGZ# README COPYING

######################################

.PHONY: last

FOXSETUPPROGS = foxmaph exfoxdefin moddate

all : FoxSetupProgs $(OBJ)/fox-make.inc last

last :
	$(addprefix $(EXEDIR)/, $(addsuffix $(EXESUFFIX), foxmaph)) $(wildcard *.fm)

$(OBJ)/fox-make.inc : $(FOXTOPDIR)/config.status exfoxdefin.c++
	$(addprefix $(EXEDIR)/, $(addsuffix $(EXESUFFIX), exfoxdefin)) $(FOXTOPDIR) $(OBJ)/fox-make.inc
	rm -f $(OBJ)/*.d

######################################

$(OBJ)/cocain.o  : cocain.c++ cocain.h clemens.h  clemiler.h
$(OBJ)/moddate.o : moddate.c++ resetTime.h clemens.h  clemiler.h


moddate    = $(OBJ)/moddate.o    $(OBJ)/cocain.o 
foxmaph    = $(OBJ)/foxmaph.o    $(OBJ)/cocain.o
exfoxdefin = $(OBJ)/exfoxdefin.o $(OBJ)/cocain.o


FoxSetupProgs : $(foreach ii,$(FOXSETUPPROGS), $(addprefix $(EXEDIR)/, $(addsuffix $(EXESUFFIX), $(ii))))
$(foreach ii,$(FOXSETUPPROGS), $(eval $(call CXX_PROGRAM_template,$(ii))) )


