/* Foxspider.cpp
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

// #define KAEFER 1
#include "fxclemens.h"
#include "foxspider.h"
#include "carddefinitions.h"
#include "cardface.h"

FXDEFMAP(Foxspider) FoxspiderMap[]={
  FXMAPFUNC (SEL_COMMAND,      Foxspider::ID_SAVE,    Foxspider::onCmdSave),
  FXMAPFUNC (SEL_COMMAND,      Foxspider::ID_OPEN,    Foxspider::onCmdOpen),
  FXMAPFUNCS(SEL_COMMAND,      Foxspider::ID_SUIT,
                               Foxspider::ID_SUIT_END,Foxspider::onCmdCard),
  FXMAPFUNCS(SEL_UPDATE,       Foxspider::ID_SUIT,
                               Foxspider::ID_SUIT_END,Foxspider::onUpdCard),
};
FXIMPLEMENT(Foxspider,Patience,FoxspiderMap,ARRAYNUMBER(FoxspiderMap))

// Construct a Foxspider
Foxspider::Foxspider(FXApp *appli,
         FXComposite *main,
         FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
         FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
  Patience(appli,main,10,80,2*C_NU,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {
  DBGINFO(constructor);

  LOCP(i,4) whichsuit[i]=1;
  filename=lastdir="";
  defcolor=getBackColor();

  // -------------- TOP pane for the buttons  ---------------------

  opts=FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|JUSTIFY_NORMAL|ICON_BEFORE_TEXT;

  new FXCheckButton(buttonFrame,"CLUB",       this,ID_CLUB,           opts,0,0,0,0,0,0,0,0);
  new FXCheckButton(buttonFrame,"SPADE",      this,ID_SPADE,          opts,0,0,0,0,0,0,0,0);
  new FXCheckButton(buttonFrame,"HEART",      this,ID_HEART,          opts,0,0,0,0,0,0,0,0);
  new FXCheckButton(buttonFrame,"DIAMOND",    this,ID_DIAMOND,        opts,0,0,0,0,0,0,0,0);
  new FXButton(     buttonFrame,"new",   NULL,this,Patience::ID_START,opts,0,0,0,0,0,0,0,0);
  new FXButton(     buttonFrame,"backup",NULL,this,Patience::ID_BACK, opts,0,0,0,0,0,0,0,0);

  FXMenuBar  *menubar =new FXMenuBar(textFrame,LAYOUT_LEFT);
  FXMenuPane *filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"File",NULL,filemenu, FRAME_THICK|FRAME_RAISED);
  new FXMenuCommand(filemenu,"shuffle + start new game",   NULL, this,Patience::ID_START);
  new FXMenuCommand(filemenu,"restart this same game",     NULL, this,Patience::ID_RESTART);
  new FXMenuCommand(filemenu,"view animation of all moves",NULL, this,Patience::ID_REPLAY);
  new FXMenuCommand(filemenu,"Save ...",NULL, this,ID_SAVE);
  new FXMenuCommand(filemenu,"Open ...",NULL, this,ID_OPEN);

  DBGINFO(end of constructor);
}


void Foxspider::shuffle() {
  int fa[4][13][2];
  int r,s,su=8,n=0;

  LOCP(i,NCARDS) {
    card[i]->init();
    card[i]->setrank(NIL);
    card[i]->setopen(NIL);
  }

  do {
    LOCP(i,4) { n+=whichsuit[i]; if (whichsuit[i]) su=i; }
    if (n!=1) su = 8; // if there is only 1 deck then the suit is su
    if (n==0) {r = ZUFALL(4)-1; whichsuit[r]=1;}
  } while (n==0);

  LOCP(i,4) {
    s=i;
    if (whichsuit[i]==0) {
      switch (n) {
      case  1: s=su; break;
      case  3: do {s=ZUFALL(4)-1;} while (whichsuit[s]==0); break;
      default: // case 2
	if (su==8) { // first time
	  for (s=0; s< 4; s++) {if (whichsuit[s]) break;} su=9;
	} else {     // second time
	  for (s=3; s>-1; s--) {if (whichsuit[s]) break;} su=8;
	}
	break;
      }
    }
    LOCP(j,13) { fa[i][j][0]=WHICHFACE(s,j+1); fa[i][j][1]=2; }
  }    //                                   there are 4*2 decks

  // now shuffle
  LOCP(i,NCARDS) {
    do { n = ZUFALL(NCARDS)-1; } while (card[n]->getrank()!=NIL);
    while (1) {
      s = ZUFALL( 4)-1;
      r = ZUFALL(13)-1;
      if ( fa[s][r][1] > 0 ) {
	card[n]->setrank(r+1);
	card[n]->setsuit( WHICHSUIT(fa[s][r][0]) );
	fa[s][r][1]--;  // ZWErg(n);ZWErg(r+1);ZWERG(card[n]->getsuit());
	card[n]->setdeck(fa[s][r][1]);  // backcolor 0 or 1
	break;
  } } }

  n=0;
  LOCP(i,5) {       // put 50 cards on the stack
    LOCP(j,NCOL) {
      do { n = ZUFALL(NCARDS)-1; } while (card[n]->getopen()!=NIL);
      card[n]->setrow( -(i+1) );
      card[n]->setcolumn( j );
      card[n]->setopen(0);
  } }

  LOCP(i,NCOL) {    // put the rest on the table
    if (i%3) s=5; else s=6;
    LOCP(j,s) {
      do { n = ZUFALL(NCARDS)-1; } while (card[n]->getopen()!=NIL);
      card[n]->setrow( j );
      card[n]->setcolumn( i );
      card[n]->setopen(0);
  } } 
}


void Foxspider::Configure(int push) {  DBGINFO(Configure);
  Patience::Configure(0);              DBGINFO(Configure);

  LOCP(n,NCARDS) {
    int r = card[n]->getrow();
    if ( r < 0 ) {  // card is on the hidden stack
      r = ABS(r)-1;
      card[n]->move(5+r*wid, 10);     
  } }

  LOCP(i,NCOL) { 
    int n = searchhigh(rowincolumn(i)-1,i);
    LOCP(j,column(i,NC,Fsbutton::GAME)) {  // number of cards per column
      int nn = column(i,j,Fsbutton::GAME);
      card[nn]->setmaymove( n<=j ? 1:0 );
  } }

  if (push) {LOCP(n,NCARDS) card[n]->push();}
  onHelp();
}

void Foxspider::onHelp() {
  int j,n=0;
  char ss[8]; FXString tt;
  std::vector<int> wo(NCOL);

  strcpy(ss,"<->");
  LOCP(i,NCOL) {
    ss[1]='A'+i;
    if  (column(i,0,Fsbutton::GAME)==NIL) wo[i]=4; else wo[i]=0;
    helper[i]->setText(FXString(ss));
  }

  strcpy(ss,"- ");
  LOCP(i,NCOL) {
    if (wo[i]==4) {n++; continue;}  // column is empty
    j = searchhigh(rowincolumn(i)-1,i);
    int nn = column(i,j,Fsbutton::GAME);
    int ra = card[nn]->getrank();
    int su = card[nn]->getsuit();
    for (int k=0; k < NCOL; k++) {
      if (i==k) continue;
      if (wo[k]==4) {n++; continue;}  // column is empty

      if (fitsincol(k,NIL,ra)) {
        if (fitsincol(k,su,ra)) {ss[0]='A'+k; wo[i]=2;} else ss[0]='a'+k;
        n++; wo[i]=clh::maxof(wo[i],1); wo[k]=clh::maxof(wo[k],1);
        tt = helper[i]->getText(); if (tt.length()==3) tt += " -> ";
        tt += FXString(ss);
        helper[i]->setText( tt );
      }
    }
  }

  LOCP(i,NCOL) {
    if (wo[i] <1) helper[i]->setText("");
    if (wo[i]==1) helper[i]->setBackColor(FXRGB(220,220, 0));
    if (wo[i] >1) helper[i]->setBackColor(FXRGB(220, 80,80));
  }
  if (n==0) {
     messa->setText("no more moves");
     helper[1]->setText("no");
     helper[2]->setText("more");
     helper[3]->setText("moves");
  }
}


long Foxspider::onCmdCard(FXObject*, FXSelector sel, void*) {
  int s = FXSELID(sel)-ID_CLUB;
  whichsuit[s] ? whichsuit[s]=0 : whichsuit[s]=1;
  return 1;
}
long Foxspider::onUpdCard(FXObject *obj, FXSelector sel, void*) {
  int s = FXSELID(sel)-ID_CLUB;
  FXuint msg=ID_UNCHECK;
  if ( whichsuit[s] ) msg=ID_CHECK;
  obj->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
}


void Foxspider::writeEntry() {
  app->reg().writeIntEntry("FoxSpider","which0",whichsuit[0]);
  app->reg().writeIntEntry("FoxSpider","which1",whichsuit[1]);
  app->reg().writeIntEntry("FoxSpider","which2",whichsuit[2]);
  app->reg().writeIntEntry("FoxSpider","which3",whichsuit[3]);
  app->reg().writeStringEntry("FoxSpider","lastdir",lastdir.text());
}

void Foxspider::readEntry() {
  whichsuit[0]=app->reg().readIntEntry("FoxSpider","which0",1);
  whichsuit[1]=app->reg().readIntEntry("FoxSpider","which1",1);
  whichsuit[2]=app->reg().readIntEntry("FoxSpider","which2",1);
  whichsuit[3]=app->reg().readIntEntry("FoxSpider","which3",1);
  lastdir     =app->reg().readStringEntry("FoxSpider","lastdir","");

  shuffle(); Configure();
}


long Foxspider::onCmdSave(FXObject*,FXSelector,void*) {
  DBGINFO(onCmdSave() begin);

  FXFileDialog open(this,"Save in ...");
  open.setPatternList("Spider files (*.spider)\n"
		      "All Files (*)\n");
  if (filename!="") {
    lastdir = FXPath::directory(filename);
    open.setFilename(filename);
    open.setDirectory(lastdir);
  }
  if (open.execute()) {
    filename=open.getFilename();

    FILE *out = fopen(filename.text(),"w");
    fprintf(out,"%d %d %d %d %d",card[0]->getsize(),
	  whichsuit[0],whichsuit[1],whichsuit[2],whichsuit[3]);
    LOCP(n,NCARDS) card[n]->schreibe(out);
    fclose(out);
  }
  return 1;
}

long Foxspider::onCmdOpen(FXObject *, FXSelector, void*){
  DBGINFO(onCmdOpen() begin);

  const FXchar patterns[]=
    "Spider files (*.spider)\n"
    "All Files (*)\n" ;

  FXFileDialog open(this,"Open Input File");
  open.setPatternList(patterns);
  open.setDirectory(lastdir);

  if (open.execute()) {
    filename=open.getFilename();
    lastdir = FXPath::directory(filename);
    FILE *v;
    if ( (v=fopen(filename.text(),"r"))==NULL ) return 1;
    int siz;
    fscanf(v,"%d %d %d %d %d",&siz,
        &whichsuit[0],&whichsuit[1],&whichsuit[2],&whichsuit[3]);
    LOCP(n,NCARDS) card[n]->lese(v,siz);
    fclose(v);
    Configure();
  }

  DBGINFO(onCmdOpen() end);
  return 1;
}


///////////////////////////////////////////////////////////////////////


int Foxspider::fitsincol(int c, int su, int ra, int io) {
  int rc = rowincolumn(c)-1;
  if (rc<0) return io;  // empty slot
  int nn = cardinrowcol(rc,c,Fsbutton::GAME);
  if (card[nn]->getrank()-1 == ra) {
    if (su == NIL) return 1;
    if (su == card[nn]->getsuit()) return 1;
  }
  return 0;
}

int Foxspider::whichcolfits(int col, int su, int ra) {
  LOOP(k,3) {
    int s = col;
    int n = NCOL;
    while(--n) {
      if (--s == -1) s+=NCOL;
      switch (k) {
      case 0:
        if ( fitsincol(s,su, ra,0) ) return s;
	break;
      case 1:
        if ( fitsincol(s,NIL,ra,0) ) return s;
	break;
      case 2:
        if ( fitsincol(s,NIL,ra) ) return s;
	break;
      }
  } }
  return NIL;
}

int Foxspider::searchhigh(int row, int col) {
  // find all fitting cards in column col
  if (column(col,NC,Fsbutton::GAME)==0) return 0;
  int ra = card[column(col,row,Fsbutton::GAME)]->getrank();  DBGINUM(ra);
  int su = card[column(col,row,Fsbutton::GAME)]->getsuit();  DBGINUM(su);
    
  while (1) {
    row--; ra++;                                DBGINUM(row);DBGINUM(ra);
    if (row<0) break;
    int nu = column(col,row,Fsbutton::GAME);    DBGINUM(nu);
    if (card[nu]->getopen()==0) break;
    if (su == card[nu]->getsuit() && ra == card[nu]->getrank()) continue;
    break;
  }
  return row+1;
}

int Foxspider::checkifcomplete(int col, int io) {
  int z = rowincolumn(col);
  if (z<13) return 0;
  int r = searchhigh(z-1,col);

  if ( card[column(col,r,Fsbutton::GAME)]->getrank() == 13 ) { // it is a king
    int n=0;
    LOCP(i,z) n += card[column(col,i,Fsbutton::GAME)]->getmaymove();
    if (n==13) { // ok, column is complete
      if (io==0) return 1; // ok, just checking

      int away=999;
      LOCP(i,NCARDS) away=clh::minof(card[i]->getcolumn(),away); 
      if (away<0) away--; else away=-1;

      LOOP(i,13) {      // while (n > 0) {  not MS compatible.....
	n--;
	z--;
        card[column(col,z,Fsbutton::GAME)]->setcolumn( away );
	card[column(col,z,Fsbutton::GAME)]->setrow(n);
      }
      return 1;
  } }
  return 0;
}

void Foxspider::playCard(int nu) {
  DBGINFO(playCard); DBGINUM(nu);

  int startcol = card[nu]->getcolumn();
  int startrow = card[nu]->getrow();
  messa->setText("ok");
  if (card[nu]->getmaymove() == 0) {Configure(0); return;}

  if (startrow < 0) {  // new cards from the stack
    LOCP(i,NCARDS) {
      if (card[i]->getmaymove() == 1 && card[i]->getrow() < 0) {
    	card[i]->setrow(rowincolumn( card[i]->getcolumn() ));
     	card[i]->setopen(1);
      }
    }
    Configure();
    return;
  }
  if (card[nu]->getButton() == RIGHTBUTTON) { // try to remove 13 cards
    if (checkifcomplete(startcol,1)) Configure(); else Configure(0);
    return;
  }

  int ra = card[nu]->getrank();
  int su = card[nu]->getsuit();
  int pos    = card[nu]->getpos();
  int endcol = (card[nu]->getX()+CW/2)*NCOL/table->getWidth();
  DBGINUM(ra);DBGINUM(su);

  if ( endcol == startcol ) {// card is clicked, see where we can place it
    startrow = searchhigh(startrow,startcol);
    nu = cardinrowcol(startrow,startcol,Fsbutton::GAME);
    ra = card[nu]->getrank();
    su = card[nu]->getsuit();
    endcol = whichcolfits(startcol,su,ra);  DBGINUM(startrow); DBGINUM(endcol);

    if (endcol==NIL) {
      endcol=startcol;
      messa->setText("nowhere to move "+cardname(su,ra));
    }
  }
  DBGINUM(startcol); DBGINUM(endcol);

  if (startcol != endcol) {
    if ( fitsincol(endcol,NIL,ra) ) { // now move
      int i,k=0,j=rowincolumn(endcol);
      while ( (i=cardinrowcol(startrow,startcol,pos)) > NIL ) {   DBGINUM(i);
        card[i]->setrow(j+k);
        card[i]->setcolumn(endcol);
	startrow++; k++;
      }
      Configure();       DBGINUM(startrow); DBGINUM(startcol);
      return;
    } else {
      messa->setText("move not possible");
    }
  }

  Configure(0);
  DBGINFO(playCard end);
}

