#ifndef FOXSPIDER_H
#define FOXSPIDER_H

#include "patience.h"


class Foxspider : public Patience {
  FXDECLARE(Foxspider)

private:
  FXString     lastdir, filename;

  int whichsuit[4];
  FXColor      defcolor;

protected:
  Foxspider(){ }

public:
 // enum{ ID_FIRST=Patience::ID_LAST,
 //   ID_SAVE, ID_OPEN, ID_SUIT,
 //   ID_CLUB   = ID_SUIT+CLUB,
 //   ID_SPADE  = ID_SUIT+SPADE,
 //   ID_HEART  = ID_SUIT+HEART,
 //   ID_DIAMOND= ID_SUIT+DIAMOND, ID_SUIT_END,
 //   ID_LAST};
 enum{ ID_FIRST=Patience::ID_LAST,
   ID_SAVE, ID_OPEN, ID_SUIT,
       ID_CLUB,   /// same order as in "carddefinitions.h"
       ID_SPADE,  
       ID_HEART,  
       ID_DIAMOND, ID_SUIT_END,
   ID_LAST};

  Foxspider(FXApp *appli, FXComposite *p,
         FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  ~Foxspider() { } // Foxspider  destructor

  virtual void Configure(int push=1);
  virtual void shuffle();
  virtual void playCard(int nu);
  void readEntry();
  void writeEntry();
  void onHelp();

  int  fitsincol(int c, int su, int ra, int io=1);
  int  whichcolfits(int col, int su, int ra);
  int  searchhigh(int row, int col);
  int  checkifcomplete(int col, int io=1);

  long onCmdCard(FXObject*, FXSelector, void*);
  long onCmdOpen(FXObject*, FXSelector, void*);
  long onCmdSave(FXObject*, FXSelector, void*);
  long onUpdCard(FXObject*, FXSelector, void*);
};
#endif

