/* Foxstreit.cc
   Copyright (C) 2013 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define KAEFER 0
#include "fxclemens.h"
#include "foxstreit.h"

#if STREIT == 1

#include "cardface.h"

FXDEFMAP(Foxstreit) FoxstreitMap[]={
  FXMAPFUNC(SEL_COMMAND, Foxstreit::ID_TURN,   Foxstreit::onCmdTurn),
  FXMAPFUNC(SEL_UPDATE,  Foxstreit::ID_TURN,   Foxstreit::onUpdTurn),
  FXMAPFUNC(SEL_TIMEOUT, Foxstreit::ID_TURN,   Foxstreit::onCmdTurn),
};
FXIMPLEMENT(Foxstreit,Patience,FoxstreitMap,ARRAYNUMBER(FoxstreitMap))



// Construct a Foxstreit
Foxstreit::Foxstreit(FXApp *appli,
	 FXComposite *main,
         FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
			 FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
Patience(appli,main, 2,1,NDECK*C_NU, opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {

  LOOP(i,4) red[i]=black[i]=false;
  black[CLUB]  = true;
  black[SPADE] = true;
  red[HEART]   = true;
  red[DIAMOND] = true;

  // capoi.create( 0,  C_NU*NDECK);
  // outcol.create(HEART, 4*NDECK);
  // if (ndeck==1) {
  //   outcol(1)=CLUB;
  //   outcol(2)=DIAMOND;
  //   outcol(3)=SPADE;
  // } else {
  //   outcol(2)=CLUB;
  //   outcol(3)=CLUB;
  //   outcol(4)=DIAMOND;
  //   outcol(5)=DIAMOND;
  //   outcol(6)=SPADE;
  //   outcol(7)=SPADE;
  // }

  // -------------- TOP pane for the buttons  ---------------------

  opts=FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|JUSTIFY_NORMAL|ICON_BEFORE_TEXT;

  // FXButton *fbun =
  // new FXButton(buttonFrame,"start again",NULL,this,Patience::ID_RESTART,opts,0,0,0,0,0,0,0,0);
  // /// cards will not be layed out as in shuffle
  // fbun->disable();  // totally buggy, should be fixed
  // new FXButton(buttonFrame,"view moves", NULL,this,Patience::ID_REPLAY, opts,0,0,0,0,0,0,0,0);
  // new FXButton(buttonFrame,"new",        NULL,this,Patience::ID_START,  opts,0,0,0,0,0,0,0,0);
  // new FXButton(buttonFrame,"backup",     NULL,this,Patience::ID_BACK,   opts,0,0,0,0,0,0,0,0);

  new FXButton(table,"-",NULL,this,ID_TURN,
		      FRAME_RAISED|FRAME_THICK|LAYOUT_EXPLICIT, 0,0, CH, CW);

  // clean up a bit, this is not needed in streit
  buttonFrame->hide();
  helperFrame->hide();
  column.clear();
}

void Foxstreit::create() {
  Patience::create();
  shuffle(); Configure();
}


void Foxstreit::shuffle() {
  LOOP(i,2) {dump[i].clear(); extra[i].clear(); stack[i].clear();}
  LOOP(i,8) {game[i].clear();   out[i].clear();}
  status = START;

  std::vector<bool> fa(NCARDS,false), fd(NCARDS,true);
  int  n,w,r,s,d;

  for (int i=0; i<NCARDS; i++) {
    do { n = ZUFALL(NCARDS)-1; } while (fa[n]);
    fa[n] = true; // set card n
    while (true) {
      s = ZUFALL(NCARDS)%4;
      r = ZUFALL(NCARDS)%13 +1;
      d = ZUFALL(NCARDS)%2;          // ZWErg(s);  ZWErg(r);ZWErg(d);
      w = d*C_NU + WHICHFACE(s,r);   // ZWErg(n);ZWERG(w);
      if (fd[w]) {     // s r d for card n
	card[n]->init();
 	card[n]->setrank(r);  // begins at 1
 	card[n]->setsuit(s);  // begins at 0
 	card[n]->setdeck(d);  // backcolor 0 or 1
	stack[d].push_back(n);
 	fd[w] = false;
 	break;
  } } }

  LOOP(j,2) {LOOP(i,12) pushpop(stack[j], extra[j]);}
}

static const int XD=2;
static const int YD=2;


// set up the layout of the cards
void Foxstreit::Configure(int push) {
  if (tabmid < 2) return;
  // if (push) {for (int n=0; n<NCARDS; n++) card[n]->push();}  // not here

  int x,y,w,h;
  LOOP(i,2) {
    if (i==COMP) {h = YD;           x=-2;} /// computer cards (top)
    if (i==USER) {h = tabhei-YD-CH; x=2;}  /// user cards (bottom)
    for (auto n : stack[i]) {card[n]->move(tabmid-CW-5*XD,      h); card[n]->raise();}
    for (auto n : dump[i])  {card[n]->move(tabmid+CW+5*XD,      h); card[n]->raise();}
    for (auto n : extra[i]) {card[n]->move(tabmid+2*(CW+5*XD)+x,h); card[n]->raise(); x+=2;}
  }

  int yi = (tabhei - 2*(CH + 2*YD)) / 4;
  int xx = tabwid - (tabmid + (CW+2*XD));
  for (int j=0; j<6; j+=4) {
    y = 2*YD + CH;
    x = tabmid + XD; if (j==0) x=mirror(x);
    for (int i=0; i<4; i++) {
      for (auto n : out[i+j]) {card[n]->move(x,y); card[n]->raise(); }
      y += yi;
  } }

  for (int j=0; j<6; j+=4) {
    y = 2*YD + CH;
    for (int i=0; i<4; i++) {
      if (game[i+j].size() > 0) {
        x = tabmid + (CW+2*XD);                                 if (j==0) x = mirror(x);
        w = clh::minof(static_cast<int>(xx/game[i+j].size()), CW/2); if (j==0) w = -w;
        for (auto n : game[i+j]) {card[n]->move(x,y); card[n]->raise(); x +=w; }
      }
      y += yi;
  } }


}

long Foxstreit::onCmdTurn(FXObject*, FXSelector, void*) {
  switch (status) {
  case START:
    LOOP(i, 4) {
      pushpop(stack[COMP],game[i  ]);
      pushpop(stack[USER],game[i+4]);
      card[game[i  ].back()]->setopen(1);
      card[game[i+4].back()]->setopen(1);
      card[game[i  ].back()]->setmaymove(1);
      card[game[i+4].back()]->setmaymove(1);
    }
    do {
      LOOP(i,2) pushpop(stack[i],dump[i]);
    } while (card[dump[COMP].back()]->getrank() == card[dump[USER].back()]->getrank());
    LOOP(i,2) card[dump[i].back()]->setopen(1);
    status = PAUSE;
    app->addTimeout(this,ID_TURN,2000*TIMEOUTFAK);
    break;

  case PAUSE:
    LOOP(i,2) card[dump[i].back()]->setopen(0);
    if (card[dump[COMP].back()]->getrank() > card[dump[USER].back()]->getrank()) status=COMP; else status=USER;
    LOOP(i,2) while (dump[i].size() > 0) pushpop(dump[i],stack[i]);
    break;
  default: break;
  }

  
  Configure();
  return 1;
}
long Foxstreit::onUpdTurn(FXObject *obj, FXSelector, void*) {
  TRANSFORM(FXButton,obj,but);
  but->move(XD, tabhei-CW-10);
  FXuint msg=ID_UNCHECK;

  switch (status) {
  case START:    but->setText("Start Game");    break;
  case PAUSE:    but->setText("blabla");    break;
  case COMP:    but->setText("Computer beginnt");  msg=ID_CHECK;   break;
  case USER:    but->setText("User beginnt");    break;
  default: break;
  }
  obj->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
}


///////////////////////////////////////////////////////////////

bool Foxstreit::putcardout(int nu, int ra, int su) {
  if (card[nu]->getopen()==0) return false;

  --ra;
  if (ra==0) {
    if (out[su  ].size()==0)  {pushpop(nu,out[su]); return true;}
    if (out[su+4].size()==0)  {pushpop(nu,out[su]); return true;}
  } else {
    if (out[su  ].back()==ra) {pushpop(nu,out[su]); return true;}
    if (out[su+4].back()==ra) {pushpop(nu,out[su]); return true;}
  }

  // /// try to put it on opponents dump
  // switch(status) {
  // case 5:   // computer
  //   if (card[udump.back()]

  return false;
}

// bool Foxstreit::fitsincol(int c, int su, int ra) {
//   int r = rowincolumn(c,Fsbutton::GAME);
//   if (r==0) {  // empty slot
//     if (ra==13) return true; else return false; // ok for king
//   }
//   int nn = column(c,r-1,Fsbutton::GAME);
//   if (card[nn]->getrank()-1 == ra) {
//     int s = card[nn]->getsuit();
//     return ((red[s] && black[su]) || (red[su] && black[s]));
//   }
//   return false;
// }

// /* -------- */

void Foxstreit::playCard(int nu) {
  //  int pos      =  card[nu]->getpos();
  int ra       =  card[nu]->getrank(); // 1,2,3,...,13
  int su       =  card[nu]->getsuit(); // 0,1,2,3

  FXString errmsg="cannot move card";
  if (card[nu]->getmaymove() == 0) goto failure;

  if (card[nu]->getButton() == RIGHTBUTTON) { // put card out
    if (putcardout(nu,ra,su)) goto success;
    goto failure;
  }

//   if (pos==Fsbutton::STACK && card[nu]->getopen()==0) { // get new card from the stack
//     card[nu]->setopen(1);
//     goto success;
//   }

//   if (pos==Fsbutton::STACK) {
//     if (card[nu]->getY() < CH+20 +4) {  // card is clicked only
//       for (int m=0; m<NCOL; m++) {
//         if ( fitsincol(m,su,ra) ) {  // new place found
//   	  card[nu]->setrow(column(m,NC,Fsbutton::GAME));
//           card[nu]->setcolumn(m);
// 	  goto success;
//       } }
//       errmsg = "nowhere to move "+cardname(su,ra);
//       goto failure;
//     }
//     if ( fitsincol(endcol,su,ra) ) {   // card was placed by user
//       card[nu]->setrow(column(endcol,NC,Fsbutton::GAME));
//       card[nu]->setcolumn(endcol);
//       goto success;
//     }
//     errmsg = "move not possible";
//     goto failure;
//   }

//   if (endcol == startcol) {  // card is clicked, see where we can place it
//     endcol = NIL;
//     for (int m=0; m<NCOL; m++) {
//       if (m==startcol) continue;
//       if ( fitsincol(m,su,ra) ) {endcol=m; break;}
//     }
//     if (endcol==NIL) {
//       messa->setText("nowhere to move "+cardname(su,ra));
//       goto failure;
//     }
//   }

//   if (startcol != endcol) {    // card was placed by user (or clicked)
//     if ( fitsincol(endcol,su,ra) ) {
//       int i,k=0,j=rowincolumn(endcol);
//       while ( (i=cardinrowcol(startrow,startcol,pos)) > NIL ) {
// 	card[i]->setrow(j+k);
//         card[i]->setcolumn(endcol);
// 	startrow++; k++;
//       }
//       goto success;
//     }
//   }
//   errmsg = "move not possible";
//   goto failure;

success:
  messa->setText("ok");
  Configure();
  return;

 failure:
  messa->setText(errmsg);
  Configure(0);
}

#endif
