#ifndef FOXSTREIT_H
#define FOXSTREIT_H

#define STREIT  1  /* still (forever?) under development */

#if STREIT == 1

#include "patience.h"
#define OTHR  status==USER?COMP:USER

class Foxstreit : public Patience {
  FXDECLARE(Foxstreit)

private:
  static const int NDECK = 2;
  enum{COMP, USER, NUMCU, START, PAUSE, BEGIN};
  bool red[4], black[4];
  int status;
  std::array<std::vector<int>,2> stack, dump, extra;
  std::array<std::vector<int>,8> game, out;

  void pushpop(std::vector<int> &from, std::vector<int> &to) {
    to.push_back(from.back()); from.pop_back();
  }

  void pushpop(const int nu, std::vector<int> &to) {
    LOOP(i,2) {if ( dump[i].back()==nu) {pushpop( dump[i],to); return;}}
    LOOP(i,8) {if ( game[i].back()==nu) {pushpop( game[i],to); return;}}
    LOOP(i,2) {if (stack[i].back()==nu) {pushpop(stack[i],to); return;}}
    LOOP(i,2) {if (extra[i].back()==nu) {pushpop(extra[i],to); return;}}
    LOOP(i,8) {if (  out[i].back()==nu) {pushpop(  out[i],to); return;}}
  }
  int mirror(int x) { return tabmid-(x-tabmid) - CW; }

protected:
  Foxstreit() { }

public:
  virtual void Configure(int push=1);
  virtual void shuffle();
  virtual void playCard(int nu);
  virtual void create();

  bool putcardout(int n, int r, int s);
  // bool fitsincol(int c, int su, int ra);

  Foxstreit(FXApp *appli, FXComposite *p,
         FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  ~Foxstreit() { /*outcol.clear(); capoi.clear();*/ } // Foxstreit  destructor

  enum{ ID_FIRST=Patience::ID_LAST, ID_TURN, ID_LAST};
  long onCmdTurn(FXObject*, FXSelector, void*);
  long onUpdTurn(FXObject*, FXSelector, void*);
};

#endif
#endif

