/*
   Copyright (C) 2004 Clemens Schiff

   project foxspider

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

// #define KAEFER 1
#include "fxclemens.h"
#include "fsbutton.h"
#include "cardface.h"

FXDEFMAP(Fsbutton) FsbuttonMap[]={
  FXMAPFUNC(SEL_MOTION,  0,  Fsbutton::onMotion),
};
FXIMPLEMENT(Fsbutton,CSButton,FsbuttonMap,ARRAYNUMBER(FsbuttonMap))
using namespace std;


Fsbutton::Fsbutton(FXComposite* p,const FXString& text,FXIcon* ic,FXObject* tgt,
   FXSelector sel,FXuint opts, FXint x,FXint y,FXint w,FXint h,
   FXint pl,FXint pr,FXint pt,FXint pb) :
    CSButton(p,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb) {

  const int r = 240;
  color[0] = FXRGB(r,   3*r/4,r/10);
  color[1] = FXRGB(r/10,r/2,  r/2);
  hicol[0] = makeHiliteColor(color[0]);
  shcol[0] = makeShadowColor(color[0]);
  hicol[1] = makeHiliteColor(color[1]);
  shcol[1] = makeShadowColor(color[1]);

  init();
}

void Fsbutton::init() {
  pressed=xold=yold=0;
  rank=suit=row=column=-888; open=maymove=deck=0;
  setDefaultCursor(getApp()->getDefaultCursor(DEF_DNDSTOP_CURSOR));
}

long Fsbutton::onMotion(FXObject *,FXSelector ,void *) {
  if (!maymove) return 1;

  if ( flags&FLAG_PRESSED ) { // button is pressed
    if (pressed==0) {
      getCursorPosition(xold,yold,button);
      raise();
      pressed=1;
    } else {
      getCursorPosition(xx,yy,button);
      move( getX()+xx-xold, getY()+yy-yold );
    }
  } else {
    pressed=0;
  }
  return 1;
}

void Fsbutton::setmaymove(int s) {
  if (s!=maymove) {
    maymove=s;
    if (maymove) setDefaultCursor(getApp()->getDefaultCursor(DEF_CROSSHAIR_CURSOR));
    else         setDefaultCursor(getApp()->getDefaultCursor(DEF_DNDSTOP_CURSOR));
  }
}


void Fsbutton::updopen(FXIcon *ic[], FXIcon *back) {
  if (open==1) {
    setIcon(ic[WHICHFACE(suit,rank)]);
  } else {
    setBackColor(color[deck]); setHiliteColor(hicol[deck]); setShadowColor(shcol[deck]);
    setIcon(back);
  }
}

void Fsbutton::schreibe(FILE *v) {
  fprintf(v," %d %d",suit,rank);
  LOOP(n,ro.size()) fprintf(v," %d %d %d",ro[n],co[n],op[n]);
}
void Fsbutton::lese(FILE *v, int siz) {
  clear();
  fscanf(v," %d %d",&suit,&rank);
  LOOP(n,siz) {fscanf(v," %d %d %d",&row,&column,&open); push();}
}

void Fsbutton::push() {
  ro.push_back(row);
  co.push_back(column);
  op.push_back(open);
  ma.push_back(maymove);
}
void Fsbutton::pop() {
  if (ro.size() > 0) {
    ro.pop_back();     row=ro[ro.size()-1];
    co.pop_back();  column=co[co.size()-1];
    op.pop_back();    open=op[op.size()-1];
    ma.pop_back(); setmaymove(ma[ma.size()-1]);
  }
}

int Fsbutton::replay(int n) {
  if (n==int(ro.size())) return -88;
    row=ro[n];
 column=co[n];
   open=op[n];
   return n;
}
