#ifndef FSBUTTON_H
#define FSBUTTON_H

#include "csbutton.h"
#include <array>

class Fsbutton : public CSButton {
  FXDECLARE(Fsbutton)

private:
  int  xold, yold, xx,yy, pressed;
  FXuint button;
  std::vector <int> ro,co,op,ma;
  int maymove, open, column, row, rank, suit, deck;
// #if ALLOW_CPP11==0
//   FXColor color[2], hicol[2], shcol[2];
// #else
  std::array<FXColor,2> color, hicol, shcol;
// #endif

protected:
  Fsbutton() { }

public:
  /// Construct a Fsbutton
  Fsbutton(FXComposite* p,const FXString& text,FXIcon* ic=NULL,
           FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=BUTTON_NORMAL,
           FXint x=0,FXint y=0,FXint w=0,FXint h=0,
  FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  long onMotion(FXObject*,FXSelector,void*);
  void init(); 
  void push();
  void pop();
  void clear() {ro.clear(); co.clear(); op.clear(); ma.clear();}
   int replay(int n);
   int getsize() { return int(co.size()); }
  void schreibe(FILE *v);
  void lese(FILE *v, int siz);
  void updopen(FXIcon *ic[], FXIcon *back);
  void setbutton(int w) {whichbutton=w;}

  int  getmaymove() {return maymove;}
  void setmaymove(int m);
  int  getopen() {return open;}
  void setopen(int m) {open=m;}
  int  getdeck() {return deck;}
  void setdeck(int m) {deck=m;}
  int  getcolumn() {return column;} // neg. column: card is put out of game
  void setcolumn(int m) {column=m;}
  int  getrow() {return row;}       // neg. row : card is on the hidden stack
  void setrow(int m) {row=m;}
  int  getrank() {return rank;}     // wert   2
  void setrank(int m) {rank=m;}
  int  getsuit() {return suit;}     // farbe  Kreuz
  void setsuit(int m) {suit=m;}

  enum {ID_FSBUTTON=CSButton::ID_LAST, ID_LAST};
  static const int STACK =0;  //  enum {STACK, GAME, OOT,  NUMPOS};
  static const int GAME  =1;
  static const int OOT   =2;  // variable OUT forbiddden on Win
  static const int NUMPOS=OOT+1;

  int  getpos() {
    if (row   <0) return STACK;
    if (column<0) return OOT;
    return GAME;
  }

};
#endif
