/* Patience.cpp
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


// #define KAEFER 1
#include "fxclemens.h"

#include "cardface.h"
#include "patience.h"
#include "penguin.h"

const int Patience::NIL = -888;
const int Patience::CW  = CARD_WIDTH  +4;
const int Patience::CH  = CARD_HEIGHT +4;
const FXColor Patience::HELPERCOL = FXRGB(220,220,220);


FXDEFMAP(Patience) PatienceMap[]={
  FXMAPFUNC(SEL_CONFIGURE,     0,              Patience::onConfigure),
#ifdef WINREBUG
  FXMAPFUNC(SEL_TIMEOUT,  Patience::WINRESIZE, Patience::onConfigure),
#endif
  FXMAPFUNCS(SEL_COMMAND, Patience::CARD0, /* CARD149=CARD0+210 */ 
                                          Patience::CARD150, Patience::onPlayCard),
  FXMAPFUNCS(SEL_UPDATE,  Patience::CARD0,Patience::CARD150, Patience::onUpdPlayCard),
  FXMAPFUNCS(SEL_TIMEOUT, Patience::CARD0,Patience::CARD150, Patience::onPlayCard),

  FXMAPFUNC(SEL_COMMAND,  Patience::ID_START,  Patience::onCmdStart),
  FXMAPFUNC(SEL_COMMAND,  Patience::ID_RESTART,Patience::onCmdStart),
  FXMAPFUNC(SEL_COMMAND,  Patience::ID_BACK,   Patience::onCmdBack),
  FXMAPFUNC(SEL_UPDATE,   Patience::ID_BACK,   Patience::onUpdBack),
  FXMAPFUNC(SEL_COMMAND,  Patience::ID_REPLAY, Patience::onReplay),
  FXMAPFUNC(SEL_UPDATE,   Patience::ID_REPLAY, Patience::onUpdBack),
  FXMAPFUNC(SEL_TIMEOUT,  Patience::REPLAY,    Patience::onReplay),
};

FXIMPLEMENT(Patience,FXVerticalFrame,PatienceMap,ARRAYNUMBER(PatienceMap))


// Construct a Patience
Patience::Patience(FXApp *appli, FXComposite *main, const int ncol, const int nc, const int ncards,
         FXuint opts,
         FXint x,FXint y,FXint w,FXint h,
         FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) :
  FXVerticalFrame(main,opts,x,y,w,h,pl,pr,pt,pb,hs,vs), NCOL(ncol), NC(nc), NCARDS(ncards) {

  app=appli;
  peng     = new FXGIFIcon(app,bigpenguin);
  tabwid=tabhei=tabmid=0;
  column.create(0, NCOL,NC+1,Fsbutton::NUMPOS);

  cardface(app);  // create cards from the old spider bitmaps

  // -------------- TOP pane for the buttons  ---------------------

  buttonFrame=new FXHorizontalFrame(this,
     LAYOUT_FILL_X|LAYOUT_LEFT|FRAME_SUNKEN|PACK_UNIFORM_WIDTH,
     0,0,0,0,0,0,0,0,0,0);

  textFrame=new FXHorizontalFrame(this, LAYOUT_FILL_X|LAYOUT_LEFT|FRAME_RIDGE);
  messa = new FXLabel(textFrame,"Welcome",NULL,
              LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RIDGE|LAYOUT_RIGHT);
  messa->setBackColor(FXRGB(250,250,250));

  helperFrame=new FXHorizontalFrame(this,
     LAYOUT_FILL_X|LAYOUT_LEFT|FRAME_SUNKEN|PACK_UNIFORM_WIDTH|LAYOUT_BOTTOM);

  LOCP(i,NCOL) {
    helper.push_back( new FXLabel(helperFrame," ",NULL,LAYOUT_FILL_X) );
    helper[i]->setBackColor(HELPERCOL);
  }

  // ---------------- table to put the cards on --------------------

  table=new FXVerticalFrame(this,
      LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_RIDGE,
      0,0,0,0, 0,0,0,0);
  table->setBackColor(FXRGB(0,100+ZUFALL(100),0));

  opts=FRAME_THICK|FRAME_RAISED|LAYOUT_EXPLICIT;
  for (int i=0; i<NCARDS; i++) {
    card.push_back( new Fsbutton(table,"",peng,this,CARD0+i,opts, 0,0,CW,CH) );
  }
}

// Start new game
long Patience::onCmdStart(FXObject *, FXSelector sel, void*){
  if (FXSELID(sel) == ID_START) {
    shuffle();
  } else {
    for (int n=0; n<NCARDS; n++) {card[n]->replay(0); card[n]->init();} // reset
  }
  for (int   n=0; n<NCARDS; n++) card[n]->clear();
  Configure();
  return 1;
}


long Patience::onPlayCard(FXObject*, FXSelector sel, void*) {
  playCard( FXSELID(sel)-CARD0 );
  return 1;
}

long Patience::onUpdPlayCard(FXObject*,FXSelector sel,void*) {
  int n = FXSELID(sel) - CARD0;
  card[n]->updopen(face,peng);
  return 1;
}


long Patience::onCmdBack(FXObject *, FXSelector, void*) {
  int i=0;
  LOCP(n,NCARDS) {
    i+=card[n]->getopen();
    card[n]->pop();
    i-=card[n]->getopen();
  }
  if (i) messa->setText("cheater");
  Configure(0);
  return 1;
}

long Patience::onUpdBack(FXObject *obj, FXSelector, void*) {
  FXuint msg=ID_ENABLE;
  if (card[0]->getsize() < 2) msg=ID_DISABLE;
  obj->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
}


// Widget has been resized
#ifdef WINREBUG
long Patience::onConfigure(FXObject*,FXSelector sel,void*) {
  if (FXSELID(sel)==WINRESIZE) {
#else
long Patience::onConfigure(FXObject*,FXSelector,void*) {
#endif
    wid = (table->getWidth() - NCOL*CW - 10)/(NCOL-1);
    hei = (table->getHeight() -   2*CH - 10);
    int n=tabwid+tabhei;
    tabwid = table->getWidth();
    tabhei = table->getHeight();
    tabmid = tabwid/2;
//  otherwise endless loop
//  because onCmdHelp in Configure() resizes table
    if (n-tabwid-tabhei) Configure(0);  // was configure() May11
#ifdef WINREBUG
  } else {
    app->addTimeout(this,WINRESIZE,50*TIMEOUTFAK);
  }
#endif
  return 1;
}


long Patience::onReplay(FXObject*,FXSelector sel,void*) {
  if (FXSELID(sel)==ID_REPLAY) {
     app->beginWaitCursor();
     LOCP(n,NCARDS) rpl=card[n]->replay(0); 
     app->addTimeout(this,REPLAY,500*TIMEOUTFAK);
  } else {
    rpl++;
    LOCP(n,NCARDS) {
      if (card[n]->replay(rpl) < 0) {
        app->endWaitCursor();
        return 1;
    } }
  }
  app->addTimeout(this,REPLAY,500*TIMEOUTFAK);
  Configure(0);
  return 1;
}

///////////////////////////////////////////////////////////////


// set up the layout of the cards
void Patience::Configure(int push) {
  int w = clh::putbetween(wid, 0,8);
  column.assign(NIL);

  LOCP(n,NCARDS) {
    int r = card[n]->getrow();
    int c = card[n]->getcolumn();  // ZWErg(n);ZWErg(c);ZWERG(r);

    if ( r < 0 ) {  // card is on the hidden stack
      r = ABS(r)-1;
      //  card[n]->move(5+r*w, 10);   different in spider and klondike  
      column(c,r,Fsbutton::STACK) = n;
      continue;
    }
    if ( c < 0 ) {  // card is put out of game
      c = ABS(c)-1;
      card[n]->setmaymove(0);
      card[n]->move( 5+(NCOL-c-1)*(CW+wid), 10);     
      column(c,r,Fsbutton::OOT) = n;
      continue;
    }
    column(c,r,Fsbutton::GAME) = n;
  }

  for (int k=0; k < Fsbutton::NUMPOS; k++) {
    LOCP(i,NCOL) {
      if (k==Fsbutton::GAME) {
	w=0;
	LOCP(j,NC) {if (column(i,j,k) > NIL) ++w; else break;}
	if (w>0) {w = clh::putbetween(hei/w, 0,30);}
      }
      LOCP(j,NC) {
	int n = column(i,j,k);
	if (n > NIL) {
          if (k==Fsbutton::GAME) card[n]->move( 5+i*(CW+wid), CH+20+j*w);
	  card[n]->raise();
	} else {
	  if (j>0) {
	    n = column(i,j-1,k);
	    if (k!=Fsbutton::STACK) card[n]->setopen(1);
	    if (k!=Fsbutton::OOT  ) card[n]->setmaymove(1);
	  }
	  column(i,NC,k) = j;  // number of rows in this column
	  break;
	}
  } } }

  if (push) {LOCP(n,NCARDS) card[n]->push();}
  /**/       LOCP(i,NCOL) {helper[i]->setBackColor(HELPERCOL); helper[i]->setText("");}
}



///////////////////////////////////////////////////////////////

int Patience::cardinrowcol(const int row, const int col, const int pos) {
  int r = row;
  if (pos==Fsbutton::OOT) ERRORABORT;
  if (pos==Fsbutton::STACK) r = ABS(row)-1;  //  ZWERG(column(col,r,pos));
  return column(col,r,pos);
}

 // get number of cards in column 
int Patience::rowincolumn(const int c, const int pos) {
  return column(c,NC,pos);
}
