/* Patience.cpp
   Copyright (C) 2004 Clemens Schiff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef PATIENCE_H
#define PATIENCE_H

//------------------------------------------
// base class for foxklondike, foxspider and foxstreit
//------------------------------------------

#include "fsbutton.h"

#ifdef WIN32
// strange, but necessary (fox 1.2.11)
// still necessary with fox 1.7.19
#define WINREBUG 1
#endif

class Patience : public FXVerticalFrame {
  FXDECLARE(Patience)

protected:
  static const int NIL;
  static const int CW;
  static const int CH;
  static const FXColor HELPERCOL;
  const int NCOL,    // spider, klondike:  num. of columns of layed cards
    /**/    NC,      // not sure, max. num. of cards per column?
    /**/    NCARDS;  // total number of cards

  FXApp             *app;
  FXVerticalFrame   *table;
  FXHorizontalFrame *buttonFrame;
  FXHorizontalFrame *helperFrame;
  FXHorizontalFrame *textFrame;
  std::vector<Fsbutton *> card;
  std::vector<FXLabel *> helper;
  FXLabel       *messa;
  FXGIFIcon     *peng;

  int tabwid, tabhei, tabmid, wid, hei, rpl;
  Carry<int> column;

  Patience() : NCOL(0), NC(0), NCARDS(0) { }

public:
  Patience(FXApp *appli, FXComposite *p, const int ncol, const int nc, const int ncards,
         FXuint opts=0,
         FXint x=0,FXint y=0,FXint w=0,FXint h=0,
         FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=0,FXint vs=0);

  virtual ~Patience() { } // Patience  destructor

  virtual void Configure(int push=1);
  virtual void shuffle() {}
  virtual void playCard(int) {}

  int  rowincolumn(const int c, const int pos=Fsbutton::GAME);
  int  cardinrowcol(const int row, const int col, const int pos);

 enum{ ID_FIRST=FXVerticalFrame::ID_LAST,
   WINRESIZE, CARD0, CARD149=CARD0+210, CARD150,
   ID_START, ID_RESTART, ID_BACK, ID_REPLAY,
   REPLAY, ID_LAST};

/* message handlers */

  long onCmdBack(FXObject*, FXSelector, void*);
  long onCmdStart(FXObject*, FXSelector, void*);
  long onConfigure(FXObject*, FXSelector, void*);
  long onPlayCard(FXObject*, FXSelector, void*);
  long onReplay(FXObject*, FXSelector, void*);
  long onUpdBack(FXObject*, FXSelector, void*);
  long onUpdPlayCard(FXObject*, FXSelector, void*);
};

#endif

